/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.pv.console.presentation;

import com.sun.symon.apps.pv.console.presentation.SMPvCreateViewRunnable;
import com.sun.symon.apps.pv.console.presentation.SMPvDRListener;
import com.sun.symon.apps.pv.console.presentation.SMPvData;
import com.sun.symon.apps.pv.console.presentation.SMPvDataTree;
import com.sun.symon.apps.pv.console.presentation.SMPvException;
import com.sun.symon.apps.pv.console.presentation.SMPvGlobals;
import com.sun.symon.apps.pv.console.presentation.SMPvShowDetailsListener;
import com.sun.symon.apps.pv.console.presentation.SMPvUpdateBean;
import com.sun.symon.apps.pv.console.presentation.SMPvViewPnt;
import com.sun.symon.apps.pv.console.presentation.SMPvViewPointListener;
import com.sun.symon.apps.pv.console.tool.SMPvCompDetailPanel;
import com.sun.symon.apps.pv.console.tool.SMPvLocFileLoader;
import com.sun.symon.base.client.SMLogin;
import com.sun.symon.base.client.SMPropertyData;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.console.awx.AwxBusyPanel;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SMPvBean
extends JPanel {
    int agentPort;
    String hostName;
    String moduleName;
    SMRawDataRequest dReq = null;
    SMResourceAccess resAcc = null;
    JPanel main;
    JLabel statusMsg = null;
    JPanel displayArea;
    JPanel imageDisplayArea;
    JLabel pathLabel;
    JComboBox viewPointMenu;
    SMPvViewPointListener menuListener = null;
    Vector views;
    Vector alarmCache = new Vector();
    int viewIndex = 0;
    Vector navViews;
    int navIndex;
    JPanel navPanel;
    JPanel navControl;
    JButton previous;
    JButton next;
    SMPvViewPnt currentViewPnt;
    JButton showHideDetails;
    JCheckBox refreshDetails;
    SMPvCompDetailPanel compDetail = null;
    boolean compDetailsShowing = false;
    Object dataUpdateThread;
    Object alarmUpdateThread;
    SMPvCreateViewRunnable viewCreateRunnable;
    SMPvDataTree dataTree = null;

    public SMPvBean() {
        this.main = new JPanel();
        this.viewCreateRunnable = new SMPvCreateViewRunnable(this);
    }

    public void activateNext() {
        this.next.setEnabled(true);
    }

    public void activatePrevious() {
        this.previous.setEnabled(true);
    }

    public SMPvCompDetailPanel addComponentDetailPanel() {
        this.createComponentDetail();
        return this.compDetail;
    }

    public void addPhysicalView(SMPvViewPnt sMPvViewPnt) {
        if (sMPvViewPnt == null) {
            return;
        }
        if (this.viewExists(sMPvViewPnt)) {
            return;
        }
        if (this.viewIndex > 1 && this.navIndex != this.navViews.size()) {
            this.navViews.addElement(this.navViews.elementAt(this.navIndex - 1));
        }
        this.views.addElement(sMPvViewPnt);
        this.viewIndex = this.views.size();
        this.navViews.addElement(sMPvViewPnt);
        this.navIndex = this.navViews.size();
        this.addView();
    }

    public void addView() {
        boolean bl = true;
        this.removeView();
        if (this.currentViewPnt != null && this.currentViewPnt.getPvData() == ((SMPvViewPnt)this.navViews.elementAt(this.navIndex - 1)).getPvData()) {
            bl = false;
        }
        this.currentViewPnt = (SMPvViewPnt)this.navViews.elementAt(this.navIndex - 1);
        this.getDisplayArea().add(this.currentViewPnt.getPvNodeTree().getImagePanel());
        if (bl) {
            this.populateMenuOptions();
        }
        int n = 0;
        while (n < this.currentViewPnt.getPvData().getViewNum()) {
            String string = this.currentViewPnt.getPvData().getVpStr(n);
            if (string.equals(this.currentViewPnt.getVpStr())) {
                this.viewPointMenu.setSelectedIndex(n);
            }
            ++n;
        }
        this.updateNavigationControls();
        this.getParent().validate();
        this.getParent().invalidate();
        this.setVisible(true);
    }

    public SMPvViewPnt addViewPnt(SMPvData sMPvData, int n) throws Exception {
        this.busyProcessStart();
        SMPvViewPnt sMPvViewPnt = sMPvData.getPvViewPnt(n);
        if (!sMPvViewPnt.viewPntTreeExists()) {
            sMPvViewPnt.createPvViewPnt();
        }
        this.busyProcessEnd();
        if (sMPvViewPnt.getPvNodeTree() == null || sMPvViewPnt.getPvNodeTree().getImagePanel() == null) {
            this.postStatus(this.getI18NString("pvNoViewPoint"));
            return null;
        }
        return sMPvViewPnt;
    }

    public void busyProcessEnd() {
        JFrame jFrame = this.getRootFrame(this);
        jFrame.getGlassPane().setVisible(false);
        Toolkit.getDefaultToolkit().sync();
    }

    public void busyProcessStart() {
        JFrame jFrame = this.getRootFrame(this);
        if (!(jFrame.getGlassPane() instanceof AwxBusyPanel)) {
            jFrame.setGlassPane(new AwxBusyPanel());
            jFrame.validate();
        }
        jFrame.getGlassPane().setVisible(true);
        Toolkit.getDefaultToolkit().sync();
    }

    public void cleanup() {
        this.stopDataUpdateThread();
        this.stopAlarmUpdateThread();
    }

    public JPanel createActionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 10));
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(new JLabel(this.getI18NString("pvViewPoint")));
        JComboBox jComboBox = new JComboBox();
        jComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        jComboBox.setEditable(false);
        jComboBox.setLightWeightPopupEnabled(false);
        this.setViewPointMenu(jComboBox);
        jPanel2.add(jComboBox);
        if (this.getModuleName().equals("Config-Reader4u")) {
            JButton jButton = new JButton(this.getI18NString("pvDR"));
            jButton.addActionListener(new SMPvDRListener(this));
            jPanel2.add(jButton);
        }
        this.showHideDetails = new JButton(this.getI18NString("pvShowDetails"));
        this.showHideDetails.addActionListener(new SMPvShowDetailsListener(this));
        jPanel2.add(this.showHideDetails);
        this.refreshDetails = new JCheckBox(this.getI18NString("pvRefreshDetails"), false);
        this.refreshDetails.setToolTipText(this.getI18NString("pvRefreshTip"));
        this.refreshDetails.setVisible(false);
        jPanel2.add(this.refreshDetails);
        jPanel.add("West", jPanel2);
        return jPanel;
    }

    public void createComponentDetail() {
        if (this.compDetail == null) {
            this.compDetail = new SMPvCompDetailPanel(this.getModuleName());
            this.compDetail.setVisible(false);
        }
    }

    private JPanel createNavigationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.navControl = new JPanel(new FlowLayout());
        this.previous = new JButton(new ImageIcon(this.resAcc.getImage("topoimages/back32x32-j.gif")));
        this.navControl.add(this.previous);
        this.next = new JButton(new ImageIcon(this.resAcc.getImage("topoimages/forward32x32-j.gif")));
        this.navControl.add(this.next);
        this.previous.setActionCommand("Previous");
        this.next.setActionCommand("Next");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Previous")) {
                    if (SMPvBean.this.navIndex > 0) {
                        --SMPvBean.this.navIndex;
                    }
                } else if (actionEvent.getActionCommand().equals("Next") && SMPvBean.this.navIndex < SMPvBean.this.navViews.size()) {
                    ++SMPvBean.this.navIndex;
                }
                SMPvBean.this.addView();
            }
        };
        this.previous.addActionListener(actionListener);
        this.next.addActionListener(actionListener);
        jPanel.add(this.navControl);
        return jPanel;
    }

    public JPanel createNodePathPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 10));
        JLabel jLabel = new JLabel(this.getI18NString("pvComponent"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 10));
        jPanel.add("West", jLabel);
        JLabel jLabel2 = new JLabel(this.getI18NString("pvComponentPath"));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
        this.setPathLabel(jLabel2);
        jLabel2.setForeground(Color.blue);
        jPanel.add((Component)jLabel2, "Center");
        return jPanel;
    }

    public void deactivateNext() {
        this.next.setEnabled(false);
    }

    public void deactivatePrevious() {
        this.previous.setEnabled(false);
    }

    public String determineModuleName() {
        return new String("Config-Reader4u");
    }

    public boolean fileExists(String string) {
        return this.resAcc.fileExists("xfile:/pvimages/" + string);
    }

    public String getAgentHost() {
        return this.hostName;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public Object getAlarmUpdateThread() {
        return this.alarmUpdateThread;
    }

    public Vector getComponentDetail(SMPvData sMPvData) {
        Object object;
        Vector vector;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector<String> vector5 = new Vector<String>();
        Vector vector6 = new Vector();
        String string = null;
        if (sMPvData.getCompInfoDB() != null && !this.refreshNow()) {
            return sMPvData.getCompInfoDB();
        }
        this.postStatus(this.getI18NString("pvLoadingComponentDetails"));
        String string2 = sMPvData.getManagedObjectName();
        string = this.dataTree.isRawTreeCacheLoaded() ? new String(String.valueOf(string2) + "." + sMPvData.getNodeInstance()) : string2;
        vector4 = (Vector)this.dataTree.getPropCache().get(string2);
        if (vector4 == null) {
            return null;
        }
        String string3 = this.dataTree.getBaseUrl();
        int n = 0;
        while (n < vector4.size()) {
            String string4 = ((SMPropertyData)vector4.elementAt(n)).getPropertyName();
            try {
                vector = SMRawDataRequest.createURL((String)string3, (String)string2, (String)string4, (String)"", (String)"");
                if (((SMPropertyData)vector4.elementAt(n)).getPropertyType()) {
                    vector5.addElement(String.valueOf(vector) + "#0");
                } else if (this.dataTree.isRawTreeCacheLoaded()) {
                    object = this.dataTree.getRawTreePropCache().get(String.valueOf(string) + ".SNMP").toString();
                    if (object == null) {
                        return null;
                    }
                    vector5.addElement(String.valueOf(vector) + "#" + (String)object);
                } else {
                    vector5.addElement((String)((Object)vector));
                }
            }
            catch (Exception exception) {
                return null;
            }
            vector3.addElement(vector4.elementAt(n));
            ++n;
        }
        vector6 = (Vector)this.dataTree.getCompDataCache().get(string);
        if (vector6 == null || this.refreshNow()) {
            if (this.refreshNow()) {
                this.dataTree.getCompDataCache().remove(string);
                sMPvData.resetCompInfoDB();
            }
            try {
                vector2 = this.dReq.getURLValue(vector5);
            }
            catch (Exception exception) {
                return null;
            }
            if (vector2 == null || vector2.size() != vector3.size()) {
                return null;
            }
            vector6 = new Vector();
            int n2 = 0;
            while (n2 < vector3.size()) {
                vector = (Vector)vector2.elementAt(n2);
                if (vector != null) {
                    object = vector.elementAt(0).toString();
                    if (object != null && !((String)object).equals("") && !((String)object).equals(" ")) {
                        vector = new Vector();
                        UcListUtil.decomposeList((String)object, vector);
                        vector6.addElement(vector);
                    } else {
                        vector = new Vector();
                        vector.addElement("");
                        vector6.addElement(vector);
                    }
                }
                ++n2;
            }
            this.dataTree.getCompDataCache().put(string, vector6);
        }
        int n3 = 0;
        while (n3 < vector6.size()) {
            int n4;
            vector = ((SMPropertyData)vector3.elementAt(n3)).getPropertyName();
            object = (Vector)vector6.elementAt(n3);
            boolean bl = true;
            if (((SMPropertyData)vector3.elementAt(n3)).getPropertyType()) {
                n4 = 0;
            } else {
                n4 = Integer.parseInt(sMPvData.getNodeInstance()) - 1;
                bl = false;
            }
            Vector<String> vector7 = new Vector<String>();
            vector7.addElement(String.valueOf(sMPvData.getManagedObjectName()) + "." + vector);
            if (bl) {
                String string5 = new String("");
                Enumeration enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    string5 = string5.concat(enumeration.nextElement().toString()).concat(" ");
                }
                vector7.addElement(string5);
            } else if (this.dataTree.isRawTreeCacheLoaded()) {
                vector7.addElement(((Vector)object).elementAt(0).toString());
            } else {
                vector7.addElement(((Vector)object).elementAt(n4).toString());
            }
            sMPvData.compInfoDB.addElement(vector7);
            ++n3;
        }
        return sMPvData.compInfoDB;
    }

    public SMPvCompDetailPanel getComponentDetailPanel() {
        return this.compDetail;
    }

    public Image getComponentImage(String string) {
        return this.resAcc.getImage("pvimages/" + string);
    }

    public Vector getComponentLocations(String string) {
        if (!this.resAcc.fileExists("xfile:/pvimages/" + string)) {
            return null;
        }
        String string2 = this.resAcc.getLocationFile("pvimages/" + string);
        if (string2 == null) {
            return null;
        }
        SMPvLocFileLoader sMPvLocFileLoader = new SMPvLocFileLoader();
        return sMPvLocFileLoader.loadLocations(string2);
    }

    public SMPvViewPnt getCurrentViewPnt() {
        return this.currentViewPnt;
    }

    public SMPvDataTree getDataTreeRef() {
        return this.dataTree;
    }

    public Object getDataUpdateThread() {
        return this.dataUpdateThread;
    }

    protected boolean getDetailsFlag() {
        return this.compDetailsShowing;
    }

    public JPanel getDisplayArea() {
        return this.imageDisplayArea;
    }

    public Frame getFrame(Component component) {
        Frame frame = new Frame();
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    public String getI18NString(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.apps.pv.console.presentation.PhysicalView:" + string));
    }

    public String getModuleName() {
        return this.moduleName;
    }

    protected JButton getMoreButtonRef() {
        return this.showHideDetails;
    }

    public JPanel getNavControls() {
        return this.navControl;
    }

    public JLabel getPathLabel() {
        return this.pathLabel;
    }

    public SMRawDataRequest getRawDataRequestHandle() {
        return this.dReq;
    }

    private SMResourceAccess getResourceHandle() {
        return this.resAcc;
    }

    public JFrame getRootFrame(Component component) {
        JFrame jFrame = new JFrame();
        while ((component = component.getParent()) != null) {
            if (!(component instanceof JFrame)) continue;
            jFrame = (JFrame)component;
            break;
        }
        return jFrame;
    }

    public JComboBox getViewPointMenu() {
        return this.viewPointMenu;
    }

    public JLabel getWindowStatusField() {
        return this.statusMsg;
    }

    public void hideComponentDetails() {
        this.compDetailsShowing = false;
        this.getComponentDetailPanel().setVisible(false);
        this.refreshDetails.setVisible(false);
        this.validate();
    }

    public void init() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        SMModuleRequest sMModuleRequest = new SMModuleRequest(this.dReq);
        try {
            if (!sMModuleRequest.isModuleLoaded(this.getAgentHost(), this.getAgentPort(), this.getModuleName())) {
                JLabel jLabel = new JLabel(this.getI18NString("pvNoPV"));
                this.postStatus(this.getI18NString("pvNoModule"));
                this.add(jLabel);
                this.getParent().validate();
                return;
            }
        }
        catch (Exception exception) {
            JLabel jLabel = new JLabel(this.getI18NString("pvNoPV"));
            this.postStatus(exception.getMessage());
            this.add(jLabel);
            this.getParent().validate();
            return;
        }
        this.main.setLayout(new BorderLayout());
        this.main.setForeground(Color.black);
        this.main.add("North", this.createActionPanel());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10), BorderFactory.createLoweredBevelBorder()));
        this.displayArea = new JPanel(new FlowLayout());
        this.imageDisplayArea = new JPanel(new FlowLayout());
        this.displayArea.add(this.imageDisplayArea);
        jPanel.add("Center", this.displayArea);
        this.navPanel = this.createNavigationPanel();
        jPanel.add((Component)this.navPanel, "South");
        this.postStatus(this.getI18NString("pvLoadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("pvLoadingHierarchyFailed"));
            return;
        }
        this.postStatus(this.getI18NString("pvLoadingConsole"));
        if (!this.initSMPvBean()) {
            this.postStatus(this.getI18NString("pvLoadingConsoleFailed"));
            return;
        }
        this.postStatus("");
        this.main.add("West", jPanel);
        this.main.add("Center", this.addComponentDetailPanel());
        this.main.add("South", this.createNodePathPanel());
        this.add((Component)this.main, gridBagConstraints);
    }

    public boolean initDataTree() {
        try {
            if (this.dataTree == null) {
                this.dataTree = new SMPvDataTree();
                if (this.dataTree == null) {
                    return false;
                }
                this.dataTree = new SMPvDataTree();
                if (this.dataTree == null) {
                    return false;
                }
                this.dataTree.setRawDataRequestHandle(this.dReq);
                this.dataTree.setAgentHost(this.hostName);
                this.dataTree.setAgentPort(this.agentPort);
                this.dataTree.setModuleName(this.getModuleName());
                this.dataTree.setBeanReference(this);
            }
            this.dataTree.initTree();
        }
        catch (Exception exception) {
            JLabel jLabel = new JLabel(this.getI18NString("pvNoPV"));
            this.postStatus(this.getI18NString(exception.getMessage()));
            this.removeAll();
            this.revalidate();
            this.add(jLabel);
            this.getParent().validate();
            return false;
        }
        return true;
    }

    public boolean initSMPvBean() {
        this.views = null;
        this.views = new Vector();
        this.viewIndex = 0;
        this.navViews = new Vector();
        this.navIndex = 0;
        this.alarmCache = null;
        this.alarmCache = new Vector();
        this.dataUpdateThread = null;
        this.alarmUpdateThread = null;
        this.currentViewPnt = null;
        try {
            this.addPhysicalView(this.addViewPnt(this.dataTree.rootPvData, 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (exception instanceof SMPvException) {
                JLabel jLabel = new JLabel(this.getI18NString("pvNoPV"));
                this.postStatus(this.getI18NString(exception.getMessage()));
                this.removeAll();
                this.revalidate();
                this.add(jLabel);
                this.getParent().validate();
                this.cleanup();
            }
            return false;
        }
        try {
            this.dataUpdateThread = this.startDataUpdateThread();
            this.alarmUpdateThread = this.startAlarmUpdateThread();
        }
        catch (Exception exception) {}
        return true;
    }

    public boolean isComponentDetailShowing() {
        return this.compDetailsShowing;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.out.println("Usage: SMPvBean agentHost agentPort serverHost");
            System.exit(1);
        }
        Frame frame = new Frame("Symon Physical View");
        SMPvBean sMPvBean = new SMPvBean();
        try {
            String string = "687a8398ad4a85077d33b72a94e16ffde0c4ba023e9c9ba77b247cc25bd3cd0015bc24b7429916751e681fd02e5ad6eb5345eb7c75b39a1c304e0f000846aa470b755b0640af974e7fc70daa6191dff6efa31a09431bb5e9848b7dc4cf4b97e1dbca31792d2860ca5a5990dfb369e1bcf296274a4e4984c8089329679dd304cd";
            SMLogin sMLogin = new SMLogin();
            sMLogin.connect(stringArray[2], 0, "adetti", "hello", string);
            sMPvBean.setRawDataRequestHandle(sMLogin.getRawDataRequest());
            sMPvBean.setAgentHost(stringArray[0]);
            sMPvBean.setAgentPort(Integer.parseInt(stringArray[1]));
        }
        catch (Exception exception) {}
        sMPvBean.init();
        frame.add(sMPvBean);
        frame.pack();
        frame.validate();
        frame.show();
    }

    public void populateComponentDetails(Object object) {
        if (this.compDetail != null && this.compDetail.isShowing()) {
            this.compDetail.populateDetailsTable(object);
        }
    }

    private void populateMenuOptions() {
        try {
            this.viewPointMenu.removeAllItems();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (this.menuListener != null) {
            this.viewPointMenu.removeActionListener(this.menuListener);
            this.menuListener = null;
        }
        if (this.currentViewPnt != null) {
            SMPvData sMPvData = this.currentViewPnt.getPvData();
            int n = 0;
            while (n < sMPvData.getViewNum()) {
                String string = sMPvData.getVpStr(n);
                this.viewPointMenu.addItem(String.valueOf(sMPvData.getNodeName()) + " - " + this.getI18NString(string));
                ++n;
            }
            this.viewPointMenu.validate();
            this.menuListener = new SMPvViewPointListener(this, sMPvData);
            this.viewPointMenu.addActionListener(this.menuListener);
        }
    }

    public void postStatus(String string) {
        if (this.statusMsg != null) {
            this.statusMsg.setText(string);
            this.statusMsg.validate();
        }
    }

    public void processAlarms(Vector vector) {
        Vector vector2;
        Vector<Vector> vector3 = new Vector<Vector>();
        int n = 0;
        while (n < vector.size()) {
            vector2 = SMPvGlobals.processRawAlarmData(vector.elementAt(n).toString());
            vector3.addElement(vector2);
            ++n;
        }
        vector2 = new Vector();
        int n2 = 0;
        while (n2 < vector3.size()) {
            Vector vector4 = (Vector)vector3.elementAt(n2);
            String string = vector4.elementAt(0).toString();
            if (string.indexOf("WRN") != -1 || string.indexOf("ERR") != -1 || string.indexOf("INF") != -1) {
                vector2.addElement(vector4);
            }
            ++n2;
        }
        vector3.removeAllElements();
        int n3 = 0;
        while (n3 < vector2.size()) {
            vector3.addElement((Vector)vector2.elementAt(n3));
            ++n3;
        }
        vector2.removeAllElements();
        vector2 = null;
        int n4 = vector3.size();
        int n5 = 0;
        while (n5 < this.alarmCache.size()) {
            Vector vector5 = (Vector)this.alarmCache.elementAt(n5);
            String string = vector5.elementAt(0).toString();
            String string2 = SMPvGlobals.getAlarmNodeName(vector5.elementAt(7).toString());
            if (!string.equals("alarm_closed")) {
                boolean bl = false;
                int n6 = 0;
                while (n6 < n4) {
                    Vector vector6 = (Vector)vector3.elementAt(n6);
                    String string3 = vector6.elementAt(0).toString();
                    String string4 = SMPvGlobals.getAlarmNodeName(vector6.elementAt(7).toString());
                    if (string2.equals(string4) && string.equals(string3)) {
                        vector6.addElement("alarm_unchanged");
                        bl = true;
                        break;
                    }
                    if (string2.equals(string4)) {
                        vector5.addElement("alarm_closed");
                        vector3.addElement(vector5);
                        bl = true;
                        break;
                    }
                    bl = false;
                    ++n6;
                }
                if (!bl) {
                    vector5.addElement("alarm_closed");
                    vector3.addElement(vector5);
                }
            }
            ++n5;
        }
        this.alarmCache.removeAllElements();
        int n7 = 0;
        while (n7 < vector3.size()) {
            this.alarmCache.addElement(vector3.elementAt(n7));
            ++n7;
        }
        vector3.removeAllElements();
        vector3 = null;
    }

    public void processOneAlarm(Vector vector) {
        String string = SMPvGlobals.getAlarmNodeName(vector.elementAt(7).toString());
        String string2 = vector.elementAt(0).toString();
        String string3 = vector.lastElement().toString();
        SMPvData sMPvData = SMPvData.findAlarmNode(this.dataTree.getRoot(), string);
        if (sMPvData == null) {
            return;
        }
        if (string3.equals("alarm_closed")) {
            if (string2.indexOf("ERR") != -1) {
                sMPvData.decRedCnt();
            } else if (string2.indexOf("WRN") != -1) {
                sMPvData.decYellowCnt();
            } else if (string2.indexOf("INF") != -1) {
                sMPvData.decBlueCnt();
            }
            this.dataTree.getCompDataCache().remove(sMPvData.getManagedObjectName());
            sMPvData.resetCompInfoDB();
        } else if (!string3.equals("alarm_unchanged")) {
            if (string2.indexOf("ERR") != -1) {
                sMPvData.incRedCnt();
            } else if (string2.indexOf("WRN") != -1) {
                sMPvData.incYellowCnt();
            } else if (string2.indexOf("INF") != -1) {
                sMPvData.incBlueCnt();
            }
            this.dataTree.getCompDataCache().remove(sMPvData.getManagedObjectName());
            sMPvData.resetCompInfoDB();
        }
    }

    protected boolean refreshNow() {
        return this.refreshDetails.isSelected();
    }

    public void removeView() {
        this.setVisible(false);
        this.getDisplayArea().removeAll();
    }

    public void setAgentHost(String string) {
        this.hostName = new String(string);
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public void setModuleName(String string) {
        this.moduleName = new String(string);
    }

    public void setPath(String string) {
        this.pathLabel.setText(string);
    }

    protected void setPathLabel(JLabel jLabel) {
        this.pathLabel = jLabel;
    }

    public SMRawDataRequest setRawDataRequestHandle() {
        return this.dReq;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.dReq = sMRawDataRequest;
        this.resAcc = new SMResourceAccess(this.dReq);
    }

    public void setSize() {
        Dimension dimension = new Dimension(this.getDisplayArea().getSize());
        dimension.height += 200;
        super.setSize(dimension);
    }

    protected void setViewPointMenu(JComboBox jComboBox) {
        this.viewPointMenu = jComboBox;
    }

    public void setWindowStatusField(Object object) {
        this.statusMsg = (JLabel)object;
    }

    public void showComponentDetails() {
        this.compDetailsShowing = true;
        this.getComponentDetailPanel().setVisible(true);
        this.refreshDetails.setVisible(true);
        this.validate();
    }

    private Object startAlarmUpdateThread() throws Exception {
        this.stopAlarmUpdateThread();
        String string = SMRawDataRequest.createURL((String)this.getAgentHost(), (int)this.getAgentPort(), (String)this.getModuleName(), (String)"", (String)"", (String)"", (String)"", (String)"");
        Vector<String> vector = new Vector<String>();
        String string2 = SMRawDataRequest.buildShadowURL((String)string, (String)"statuslist", null);
        vector.addElement(string2);
        SMPvUpdateBean sMPvUpdateBean = new SMPvUpdateBean(this);
        return this.dReq.getURLValue(vector, "60", (SMRawDataResponse)sMPvUpdateBean, (Object)"alarmUpdate");
    }

    public Object startDataUpdateThread() throws Exception {
        try {
            if (this.dataUpdateThread != null) {
                this.dReq.removeURLRequest(this.dataUpdateThread);
            }
        }
        catch (Exception exception) {}
        String string = SMRawDataRequest.createURL((String)this.getAgentHost(), (int)this.getAgentPort(), (String)this.getModuleName(), (String)"", (String)"", (String)"", (String)"", (String)"");
        Vector<String> vector = new Vector<String>();
        String string2 = SMRawDataRequest.createURL((String)string, (String)"system", (String)"total_config_changes#0", (String)"", (String)"");
        vector.addElement(string2);
        SMPvUpdateBean sMPvUpdateBean = new SMPvUpdateBean(this);
        return this.dReq.getURLValue(vector, "300", (SMRawDataResponse)sMPvUpdateBean, (Object)"dataTreeUpdate");
    }

    public void startViewCreateThread(SMPvData sMPvData, int n) {
        this.viewCreateRunnable.setThreadParam(sMPvData, n);
        Thread thread = new Thread((Runnable)this.viewCreateRunnable, "ViewCreateThread");
        thread.start();
    }

    public void stopAlarmThread() {
        try {
            this.dReq.removeURLRequest(this.alarmUpdateThread);
        }
        catch (Exception exception) {}
    }

    public void stopAlarmUpdateThread() {
        try {
            if (this.alarmUpdateThread != null) {
                this.dReq.removeURLRequest(this.alarmUpdateThread);
            }
        }
        catch (Exception exception) {}
    }

    public void stopDataUpdateThread() {
        try {
            if (this.dataUpdateThread != null) {
                this.dReq.removeURLRequest(this.dataUpdateThread);
            }
        }
        catch (Exception exception) {}
    }

    protected void toggleDetailsFlag() {
        this.compDetailsShowing ^= true;
    }

    public void updateBeanAlarms() {
        Vector vector;
        int n = 0;
        while (n < this.alarmCache.size()) {
            vector = (Vector)this.alarmCache.elementAt(n);
            this.processOneAlarm(vector);
            ++n;
        }
        vector = new Vector();
        int n2 = 0;
        while (n2 < this.alarmCache.size()) {
            Vector vector2 = (Vector)this.alarmCache.elementAt(n2);
            String string = vector2.lastElement().toString();
            if (!string.equals("alarm_closed")) {
                vector.addElement(vector2);
            }
            ++n2;
        }
        this.alarmCache.removeAllElements();
        int n3 = 0;
        while (n3 < vector.size()) {
            this.alarmCache.addElement(vector.elementAt(n3));
            ++n3;
        }
        vector.removeAllElements();
        vector = null;
    }

    public void updateBeanDataTree() {
        this.stopDataUpdateThread();
        this.stopAlarmUpdateThread();
        this.getParent().setVisible(false);
        this.removeView();
        this.getParent().validate();
        this.postStatus(this.getI18NString("pvReloadingHierarchy"));
        if (!this.initDataTree()) {
            this.postStatus(this.getI18NString("pvLoadingHierarchyFailed"));
            this.getParent().setVisible(true);
            return;
        }
        this.postStatus(this.getI18NString("pvReloadingConsole"));
        if (!this.initSMPvBean()) {
            this.postStatus(this.getI18NString("pvLoadingConsoleFailed"));
            this.getParent().setVisible(true);
            return;
        }
        this.postStatus("");
        this.getParent().validate();
        this.getParent().setVisible(true);
        this.populateComponentDetails(new Vector());
    }

    public void updateNavigationControls() {
        if (this.navViews.size() == 1) {
            this.deactivatePrevious();
            this.deactivateNext();
            return;
        }
        if (this.navIndex == 1) {
            this.deactivatePrevious();
            this.activateNext();
        } else if (this.navIndex == this.navViews.size()) {
            this.deactivateNext();
            this.activatePrevious();
        } else {
            this.activateNext();
            this.activatePrevious();
        }
    }

    public boolean viewExists(SMPvViewPnt sMPvViewPnt) {
        int n = this.views.size();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.navViews.size()) {
            if (sMPvViewPnt == (SMPvViewPnt)this.navViews.elementAt(n2)) {
                this.navIndex = n2 + 1;
                this.addView();
                return true;
            }
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        return false;
    }
}

