/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.client.console;

import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.console.SMToolArguments;
import com.sun.symon.base.client.console.SMTopologyInfo;
import com.sun.symon.base.utility.UcInternationalizer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class SMSystemCommand
implements Runnable,
SMToolArguments {
    private String[] args;
    private boolean selectionRequired = false;

    private Process launchCommand(String[] stringArray, String string, int n) {
        Process process = null;
        String string2 = "";
        try {
            string2 = this.makeCommand(this.args, string, n);
            process = Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
            JOptionPane.showMessageDialog(null, String.valueOf(this.localize("executeFail")) + ": " + string2, this.localize("title"), 0);
        }
        return process;
    }

    private String localize(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.client.console.SMSystemCommand:" + string), (boolean)false);
    }

    public static void main(String[] stringArray) {
        SMSystemCommand sMSystemCommand = new SMSystemCommand();
        sMSystemCommand.setArguments(stringArray);
    }

    private String makeCommand(String[] stringArray, String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("os.name", "");
        String string3 = string2.startsWith("Windows") ? stringArray[1] : stringArray[0];
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("$host")) {
                stringBuffer.append(string);
            } else if (string4.equals("$port")) {
                stringBuffer.append(n);
            } else {
                stringBuffer.append(string4);
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void run() {
        SMTopologyInfo[] sMTopologyInfoArray = SMConsoleContext.getInstance().getSelectedTopologyObjects();
        Process process = null;
        if (sMTopologyInfoArray == null) {
            if (this.selectionRequired) {
                JOptionPane.showMessageDialog(null, this.localize("noNodeSelected"), this.localize("title"), 1);
                return;
            }
            process = this.launchCommand(this.args, "localhost", 161);
            try {
                process.waitFor();
            }
            catch (Exception exception) {}
            return;
        }
        ArrayList<Process> arrayList = new ArrayList<Process>(sMTopologyInfoArray.length);
        int n = 0;
        while (n < sMTopologyInfoArray.length) {
            process = this.launchCommand(this.args, sMTopologyInfoArray[n].getHost(), sMTopologyInfoArray[n].getPort());
            arrayList.add(n, process);
            ++n;
        }
        ListIterator listIterator = ((AbstractList)arrayList).listIterator();
        while (listIterator.hasNext()) {
            process = (Process)listIterator.next();
            try {
                process.waitFor();
            }
            catch (Exception exception) {}
        }
    }

    public void setArguments(String[] stringArray) {
        if (stringArray == null || stringArray.length < 2) {
            return;
        }
        if (stringArray[0].equals("-s")) {
            this.selectionRequired = true;
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
            stringArray = stringArray2;
            if (stringArray.length < 2) {
                return;
            }
        }
        this.args = stringArray;
        new Thread((Runnable)this, "SMSystemCommand").start();
    }
}

