/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.security;

import java.math.BigInteger;
import java.security.SecureRandom;

public class SyExponentialKeyAgreement {
    private BigInteger modulus = new BigInteger("43134076919916162298122238168767096621326146600374522417054463099424534941639043220663084453532400108489661631");
    private BigInteger base = new BigInteger("83493073508457874871240674165692668536191158035607109619155479709552185335420779955546166000515757623029224471");
    private BigInteger exponent = null;
    private BigInteger secret = null;

    public SyExponentialKeyAgreement() {
        this.generateExponent();
    }

    public SyExponentialKeyAgreement(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.base = bigInteger2;
        this.generateExponent();
    }

    private void generateExponent() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[64];
        secureRandom.nextBytes(byArray);
        this.exponent = new BigInteger(1, byArray);
    }

    public byte[] getPublicValue() {
        BigInteger bigInteger = this.base.modPow(this.exponent, this.modulus);
        return bigInteger.toByteArray();
    }

    public byte[] getSecretKey() {
        return this.secret.toByteArray();
    }

    public void setPublicValue(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        this.secret = bigInteger.modPow(this.exponent, this.modulus);
    }
}

