/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.server.remitters.snmpjob;

import com.sun.symon.base.server.common.ScRequestDispatchException;
import com.sun.symon.base.server.common.ScRequestSink;
import com.sun.symon.base.server.emitters.control.SeControlEmitter;
import com.sun.symon.base.server.events.SvRequestEvent;
import com.sun.symon.base.server.remitters.SmRemitter;
import com.sun.symon.base.server.remitters.cache.SmCacheRemitter;
import com.sun.symon.base.server.snmp.SsDecodeException;
import com.sun.symon.base.server.snmp.SsEncodeException;
import com.sun.symon.base.server.snmp.SsMessage;
import com.sun.symon.base.server.snmp.v1.SsTrap;
import com.sun.symon.base.server.snmp.v2.SsRequest;
import com.sun.symon.base.server.snmp.v2u.SsResponse;
import com.sun.symon.base.server.types.StSnmpOBJECT_IDENTIFIER;
import com.sun.symon.base.server.types.StSnmpOCTET_STRING;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcPeriodicException;
import com.sun.symon.base.utility.UcTickerTimer;
import com.sun.symon.base.utility.UcTickerTimerResponse;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class SmSnmpJobRemitter
extends SmRemitter {
    private static final int PACKET_SIZE = 65536;
    private DatagramSocket Socket;
    private String TrapHost = null;
    private int TrapPort = -1;
    private String TrapCommunity = "public";
    private String TrapEnterprise = "1.3.6.1.4.1.1242.1";
    private static final int DEFAULT_TRAP_FREQ = 300;
    private int TrapFreq = 300;
    private SmCacheRemitter Cache = new SmCacheRemitter(){

        protected void cacheEmpty() {
            UcDDL.logInfoMessage((String)"trap writer stopped");
            SmSnmpJobRemitter.this.Ticker.stop();
        }

        protected void jobAdded() {
            if (SmSnmpJobRemitter.this.Ticker.start()) {
                UcDDL.logInfoMessage((String)"trap writer started");
                SmSnmpJobRemitter.this.sendTrap();
            }
        }
    };
    private boolean Initd;
    private UcTickerTimer Ticker;
    private int STATUS_TRAP = 0;
    private int REFRESH_TRAP = 1;
    private int WARMSTART_TRAP = 2;
    private SeControlEmitter Controller;

    public SmSnmpJobRemitter() {
        super(null);
        this.pushRemitter(this.Cache);
        this.Initd = false;
        try {
            this.Ticker = new UcTickerTimer((long)this.TrapFreq, new UcTickerTimerResponse(){

                public void processTick() {
                    SmSnmpJobRemitter.this.sendTrap();
                }

                public void processTickEnd() {
                }
            });
        }
        catch (UcPeriodicException ucPeriodicException) {}
    }

    public synchronized boolean canHandle(SvRequestEvent svRequestEvent) {
        if (!this.Initd) {
            this.Initd = true;
            this.init();
        }
        return true;
    }

    private void confirmInform(SsMessage ssMessage, InetAddress inetAddress, int n) {
        byte[] byArray;
        try {
            byArray = this.makeConfirmation(ssMessage).toBytestream();
        }
        catch (SsEncodeException ssEncodeException) {
            UcDDL.logErrorMessage((String)"invalid packet", (Throwable)ssEncodeException);
            return;
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
        try {
            this.Socket.send(datagramPacket);
            UcDDL.logDebugMessage((String)("response sent to " + inetAddress + ":" + n));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"send() failed", (Throwable)exception);
        }
    }

    private void emit(final String string, final int n) {
        UcDDL.logDebugMessage((String)("trap key = '" + string + "'"));
        this.Cache.emit(new SmCacheRemitter.Matcher(){

            public boolean doEmit(String string2) {
                if (string2.compareTo(string) == 0) {
                    UcDDL.logInfoMessage((String)("remitting job, exact match for job key = " + string2));
                    return true;
                }
                if (n == SmSnmpJobRemitter.this.REFRESH_TRAP) {
                    if (string2.startsWith(string) && string2.charAt(string.length()) == '.') {
                        UcDDL.logInfoMessage((String)("remitting job, partial refresh match for job key = " + string2 + " trap key = " + string));
                        return true;
                    }
                } else if (n == SmSnmpJobRemitter.this.STATUS_TRAP) {
                    if (string.startsWith(string2) && string.charAt(string2.length()) == '.') {
                        UcDDL.logInfoMessage((String)("remitting job, partial status match for job key = " + string2 + " trap key = " + string));
                        return true;
                    }
                } else if (n == SmSnmpJobRemitter.this.WARMSTART_TRAP && string2.startsWith(string)) {
                    UcDDL.logInfoMessage((String)("remitting job, warm start match for job key = " + string2 + " trap key = " + string));
                    return true;
                }
                return false;
            }
        });
    }

    public String getTrapCommunity() {
        return this.TrapCommunity;
    }

    public String getTrapEnterprise() {
        return this.TrapEnterprise;
    }

    public int getTrapFreq() {
        return this.TrapFreq;
    }

    public String getTrapHost() {
        return this.TrapHost;
    }

    public int getTrapPort() {
        return this.TrapPort;
    }

    private void handleV1Trap(SsTrap ssTrap) {
        int n = ssTrap.getGenericTrap();
        int n2 = ssTrap.getSpecificTrap();
        String string = ssTrap.getAgentAddress();
        String string2 = ssTrap.getContextName();
        int n3 = this.STATUS_TRAP;
        StSnmpOBJECT_IDENTIFIER stSnmpOBJECT_IDENTIFIER = null;
        if (n == 6 && (n2 == 1 || n2 == 2)) {
            if (n2 == 1) {
                UcDDL.logDebugMessage((String)"process status trap");
                stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssTrap.getVariable(String.valueOf(this.TrapEnterprise) + ".1.3.1.0");
                if (stSnmpOBJECT_IDENTIFIER == null) {
                    UcDDL.logErrorMessage((String)"can't find status oid");
                    return;
                }
            } else {
                UcDDL.logDebugMessage((String)"process refresh trap");
                n3 = this.REFRESH_TRAP;
                stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssTrap.getVariable(String.valueOf(this.TrapEnterprise) + ".1.3.2.0");
                if (stSnmpOBJECT_IDENTIFIER == null) {
                    UcDDL.logErrorMessage((String)"can't find refresh oid");
                    return;
                }
            }
        } else if (n == 1) {
            UcDDL.logDebugMessage((String)"process warm start trap");
            n3 = this.WARMSTART_TRAP;
        } else {
            return;
        }
        if (n3 == this.WARMSTART_TRAP) {
            this.emit(string, n3);
            if (this.Controller != null) {
                this.Controller.handleWarmStartTrap(string);
            }
        } else {
            this.emit(String.valueOf(string) + ":" + string2 + ":" + stSnmpOBJECT_IDENTIFIER.toString(), n3);
        }
    }

    private void handleV2Trap(SsMessage ssMessage) {
        StSnmpOCTET_STRING stSnmpOCTET_STRING;
        String string = ssMessage.getContextName();
        StSnmpOBJECT_IDENTIFIER stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable("1.3.6.1.6.3.1.1.4.1.0");
        int n = this.STATUS_TRAP;
        if (stSnmpOBJECT_IDENTIFIER == null) {
            UcDDL.logErrorMessage((String)"can't find trap type");
            return;
        }
        if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(String.valueOf(this.TrapEnterprise) + ".0.1") == 0) {
            UcDDL.logDebugMessage((String)"process status trap");
            stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable(String.valueOf(this.TrapEnterprise) + ".1.3.1.0");
            if (stSnmpOBJECT_IDENTIFIER == null) {
                UcDDL.logErrorMessage((String)"can't find status oid");
                return;
            }
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo(String.valueOf(this.TrapEnterprise) + ".0.2") == 0) {
            UcDDL.logDebugMessage((String)"process refresh trap");
            n = this.REFRESH_TRAP;
            stSnmpOBJECT_IDENTIFIER = (StSnmpOBJECT_IDENTIFIER)ssMessage.getVariable(String.valueOf(this.TrapEnterprise) + ".1.3.2.0");
            if (stSnmpOBJECT_IDENTIFIER == null) {
                UcDDL.logErrorMessage((String)"can't find refresh oid");
                return;
            }
        } else if (stSnmpOBJECT_IDENTIFIER.toString().compareTo("1.3.6.1.6.3.1.1.5.2") == 0) {
            UcDDL.logDebugMessage((String)"process warm start trap");
            n = this.WARMSTART_TRAP;
        } else {
            return;
        }
        if ((stSnmpOCTET_STRING = (StSnmpOCTET_STRING)ssMessage.getVariable("1.3.6.1.6.3.1.1.4.6.0")) == null) {
            UcDDL.logErrorMessage((String)"can't find trap address");
            return;
        }
        String string2 = stSnmpOCTET_STRING.toString();
        String string3 = (0xFF & string2.charAt(0)) + "." + (0xFF & string2.charAt(1)) + "." + (0xFF & string2.charAt(2)) + "." + (0xFF & string2.charAt(3));
        if (n == this.WARMSTART_TRAP) {
            this.emit(string3, n);
            if (this.Controller != null) {
                this.Controller.handleWarmStartTrap(string3);
            }
        } else {
            this.emit(String.valueOf(string3) + ":" + string + ":" + stSnmpOBJECT_IDENTIFIER.toString(), n);
        }
    }

    private void init() {
        try {
            this.Socket = new DatagramSocket();
        }
        catch (SocketException socketException) {
            UcDDL.logErrorMessage((String)"socket creation failed", (Throwable)socketException);
            return;
        }
        Thread thread = new Thread("Trap UDP Reader"){

            public void run() {
                SmSnmpJobRemitter.this.readTraps();
            }
        };
        thread.setPriority(10);
        thread.start();
    }

    private SsMessage makeConfirmation(SsMessage ssMessage) throws SsEncodeException {
        SsRequest ssRequest;
        switch (ssMessage.getVersion()) {
            case 2: {
                ssRequest = new com.sun.symon.base.server.snmp.v2.SsResponse();
                break;
            }
            case 3: {
                ssRequest = new SsResponse();
                break;
            }
            default: {
                throw new SsEncodeException("Invalid request version");
            }
        }
        ssRequest.setState(ssMessage.getState());
        ssRequest.setContextName(ssMessage.getContextName());
        ssRequest.setSecurityName(ssMessage.getSecurityName());
        ssRequest.setSecurityLevel(ssMessage.getSecurityLevel());
        ssRequest.setSecurityModel(ssMessage.getSecurityModel());
        ssRequest.setSendId(ssMessage.getSendId());
        ssRequest.setRequestId(ssMessage.getRequestId());
        ssRequest.setVariableNames(ssMessage.getVariableNames());
        ssRequest.setVariableValues(ssMessage.getVariableTypes(), ssMessage.getVariableValues());
        return ssRequest;
    }

    protected ScRequestSink newSink(SvRequestEvent svRequestEvent) throws ScRequestDispatchException {
        return null;
    }

    private void readTrapProcess(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        SsMessage ssMessage = null;
        try {
            ssMessage = SsMessage.toMessage(byArray2);
        }
        catch (SsDecodeException ssDecodeException) {
            UcDDL.logErrorMessage((String)"Invalid snmp packet received", (Throwable)ssDecodeException);
            return;
        }
        if (ssMessage.getVersion() == 1 && ssMessage.getType() == 4) {
            this.handleV1Trap((SsTrap)ssMessage);
        } else if (ssMessage.getVersion() == 2 && ssMessage.getType() == 3 || ssMessage.getVersion() == 3 && ssMessage.getType() == 3) {
            this.handleV2Trap(ssMessage);
        } else if (ssMessage.getVersion() == 2 && ssMessage.getType() == 4 || ssMessage.getVersion() == 3 && ssMessage.getType() == 4) {
            this.confirmInform(ssMessage, inetAddress, n2);
            this.handleV2Trap(ssMessage);
        } else {
            UcDDL.logErrorMessage((String)"wrong type of snmp packet received");
        }
    }

    private void readTraps() {
        byte[] byArray = new byte[65536];
        while (true) {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            try {
                this.Socket.receive(datagramPacket);
            }
            catch (IOException iOException) {
                UcDDL.logErrorMessage((String)"receive() failed", (Throwable)iOException);
                return;
            }
            this.readTrapProcess(byArray, datagramPacket.getLength(), datagramPacket.getAddress(), datagramPacket.getPort());
        }
    }

    public void registerController(SeControlEmitter seControlEmitter) {
        this.Controller = seControlEmitter;
    }

    private void sendTrap() {
        SsTrap ssTrap = new SsTrap();
        ssTrap.setSecurityName(this.TrapCommunity);
        ssTrap.setEnterprise(this.TrapEnterprise);
        try {
            ssTrap.setAgentAddress(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)"can't get local host address", (Throwable)unknownHostException);
            return;
        }
        ssTrap.setGenericTrap(6);
        ssTrap.setSpecificTrap(7);
        DatagramPacket datagramPacket = null;
        try {
            byte[] byArray = ssTrap.toBytestreamAndDump();
            datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(this.TrapHost), this.TrapPort);
        }
        catch (UnknownHostException unknownHostException) {
            UcDDL.logErrorMessage((String)("invalid host: '" + this.TrapHost + "'"), (Throwable)unknownHostException);
            return;
        }
        catch (SsEncodeException ssEncodeException) {
            UcDDL.logErrorMessage((String)"invalid packet", (Throwable)ssEncodeException);
            return;
        }
        try {
            this.Socket.send(datagramPacket);
            UcDDL.logDebugMessage((String)("trap sent to " + this.TrapHost + ":" + this.TrapPort));
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"send() failed", (Throwable)exception);
        }
    }

    public void setTrapCommunity(String string) {
        this.TrapCommunity = string;
    }

    public void setTrapEnterprise(String string) {
        this.TrapEnterprise = string;
    }

    public void setTrapFreq(int n) {
        if (n <= 0) {
            UcDDL.logErrorMessage((String)("Invalid trap freq: " + n));
            this.TrapFreq = 300;
        } else {
            this.TrapFreq = n;
        }
    }

    public void setTrapHost(String string) {
        block2: {
            this.TrapHost = string;
            if (this.TrapPort == -1) break block2;
            try {
                String string2 = InetAddress.getByName(this.TrapHost).getHostAddress();
                UcDDL.logInfoMessage((String)("trap handler host and port = " + this.TrapHost + " (" + string2 + ") port " + this.TrapPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public void setTrapPort(int n) {
        block2: {
            this.TrapPort = n;
            if (this.TrapHost == null) break block2;
            try {
                String string = InetAddress.getByName(this.TrapHost).getHostAddress();
                UcDDL.logInfoMessage((String)("trap handler host and port = " + this.TrapHost + " (" + string + ") port " + this.TrapPort));
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    private void subscribeTrap() {
    }
}

