/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.plugin.CacheHandler;
import sun.plugin.protocol.CookieHandler;
import sun.plugin.protocol.http.Handler;
import sun.plugin.protocol.http.HttpClient;

public class HttpURLConnection
extends sun.net.www.protocol.http.HttpURLConnection {
    protected String proxy;
    protected int proxyPort = -1;
    boolean failedOnce = false;
    static CookieHandler handler = null;
    private FileInputStream cacheStream;
    private String cachedFileName;
    private static ResourceBundle rb;

    public HttpURLConnection(URL uRL, Handler handler) throws IOException {
        super(uRL, handler);
        this.proxy = handler.getProxy();
        this.proxyPort = handler.getPort();
    }

    public HttpURLConnection(URL uRL, String string, int n) {
        super(uRL, string, n);
        this.proxy = string;
        this.proxyPort = n;
    }

    public static void setCookieHandler(CookieHandler cookieHandler) {
        handler = cookieHandler;
    }

    public synchronized void connect() throws IOException {
        String string;
        if (this.connected) {
            return;
        }
        String string2 = String.valueOf(HttpURLConnection.getMessage("opening_url")) + this.url + " ";
        if (this.proxy == null) {
            string2 = String.valueOf(string2) + HttpURLConnection.getMessage("no_proxy");
        } else {
            string2 = String.valueOf(string2) + HttpURLConnection.getMessage("proxy_equals") + this.proxy;
            if (this.proxyPort != -1) {
                string2 = String.valueOf(string2) + ":" + this.proxyPort;
            }
        }
        System.out.println(string2);
        System.out.flush();
        if (handler != null && this.getRequestProperty("cookie") == null && (string = handler.getCookieInfo(this.url)) != null) {
            this.setRequestProperty("cookie", string);
        }
        this.http = "http".equals(this.url.getProtocol()) && !this.failedOnce ? HttpClient.New(this.url, this.proxy, this.proxyPort) : this.getProxiedClient(this.url, this.proxy, this.proxyPort);
        this.ps = (PrintStream)this.http.getOutputStream();
        this.setUseCaches(false);
        this.connected = true;
    }

    protected boolean fromClassLoader() {
        new Exception();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new PrintStream(byteArrayOutputStream);
        String string = byteArrayOutputStream.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (!string2.startsWith("sun.applet.AppletClassLoader") && !string2.startsWith("sun.applet.AppletResourceLoader")) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (!this.useCaches) return super.getInputStream();
        HttpURLConnection httpURLConnection = this;
        synchronized (httpURLConnection) {
            try {
                System.getSecurityManager().checkRead(System.getProperty("java.home"));
                this.cacheStream = new FileInputStream(CacheHandler.getCacheFile(this.getURL()));
                if (this.cacheStream == null) return this.cacheStream;
                return this.cacheStream;
            }
            catch (Throwable throwable) {
                this.useCaches = false;
                return super.getInputStream();
            }
        }
    }

    protected final sun.net.www.http.HttpClient getNewClient(URL uRL) throws IOException {
        this.failedOnce = true;
        return this.getProxiedClient(uRL, this.proxy, this.proxyPort);
    }

    protected sun.net.www.http.HttpClient getProxiedClient(URL uRL, String string, int n) throws IOException {
        return new HttpClient(uRL, string, n);
    }

    public static String getMessage(String string) {
        try {
            if (rb == null) {
                rb = ResourceBundle.getBundle("sun.plugin.resources.Activator");
            }
            return rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }
}

