/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;

public class AdvancedPanel
extends ActivatorSubPanel
implements ActionListener,
KeyListener {
    private static boolean hideJITBox;
    private static boolean hideDebugBox;
    private MessageHandler mh = new MessageHandler("advanced");
    private JCheckBox debugButton;
    private JCheckBox jitButton;
    private JTextField debugPort;
    private JLabel debugPortLabel;
    private JLabel jitPathLabel;
    private JTextField jdkPath;
    private JTextField jitPath;
    private JComboBox jdkInstalled;
    private final String otherJDK = this.mh.getMessage("other_jdk");
    private final String defaultJRE = this.mh.getMessage("default_jdk");
    private JLabel pathLabel;

    AdvancedPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("jre_name")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(10, 1)));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(10, 1)));
        this.jdkInstalled = new JComboBox();
        if (this.setInstalledJavaList()) {
            this.jdkInstalled.addActionListener(this);
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
            jPanel.add(this.jdkInstalled);
        }
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(1, 5)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.pathLabel = new JLabel(String.valueOf(this.mh.getMessage("path")) + " ");
        jPanel3.add(this.pathLabel);
        this.jdkPath = new JTextField();
        this.jdkPath.addKeyListener(this);
        jPanel3.add(this.jdkPath);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        this.jitButton = new JCheckBox(this.mh.getMessage("enable_jit"));
        this.jitButton.addActionListener(this);
        jPanel4.add(this.jitButton);
        jPanel4.add(Box.createRigidArea(new Dimension(5, 1)));
        this.jitPathLabel = new JLabel(this.mh.getMessage("jit_path"));
        jPanel4.add(this.jitPathLabel);
        this.jitPath = new JTextField(configurationInfo.getJITPath(), 8);
        this.jitPath.setAlignmentX(0.0f);
        this.jitPath.setMaximumSize(this.jitPath.getPreferredSize());
        this.jitPath.addKeyListener(this);
        jPanel4.add(this.jitPath);
        if (!hideJITBox) {
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
            jPanel.add(jPanel4);
        }
        this.debugButton = new JCheckBox(this.mh.getMessage("enable_debug"));
        this.debugButton.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("debug_settings")));
        jPanel5.add(this.debugButton);
        this.debugPortLabel = new JLabel(this.mh.getMessage("debug_port"));
        jPanel5.add(this.debugPortLabel);
        jPanel5.add(Box.createRigidArea(new Dimension(5, 1)));
        this.debugPort = new JTextField("2502", 6);
        this.debugPort.setAlignmentX(0.0f);
        this.debugPort.setMaximumSize(this.debugPort.getPreferredSize());
        this.debugPort.addKeyListener(this);
        jPanel5.add(this.debugPort);
        if (!hideDebugBox) {
            this.add(Box.createRigidArea(new Dimension(1, 5)));
            this.add(jPanel5);
        }
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.debugButton) {
            this.debugPort.setEnabled(this.debugButton.isSelected());
            this.debugPortLabel.setEnabled(this.debugButton.isSelected());
            this.debugPort.repaint();
            this.debugPortLabel.repaint();
            this.model.setDebugEnabled(this.debugButton.isSelected());
        }
        if (actionEvent.getSource() == this.jdkInstalled) {
            String string = (String)this.jdkInstalled.getSelectedItem();
            if (string == null) {
                return;
            }
            if (string.equals(this.otherJDK)) {
                string = this.jdkPath.getText();
            }
            if (string.equals(this.defaultJRE)) {
                this.model.setJDK("Use Java Plug-in Default");
                this.reset();
            } else if (!string.equals(this.model.getJDK())) {
                this.model.setJDK(string);
                this.reset();
            }
        }
        if (actionEvent.getSource() == this.jitButton) {
            boolean bl = this.jitButton.isSelected();
            this.jitPathLabel.setEnabled(bl);
            this.jitPath.setEnabled(bl);
            this.jitPath.repaint();
            this.jitPathLabel.repaint();
            this.model.setJITEnabled(bl);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.debugPort) {
            this.model.setDebugPort(this.debugPort.getText());
        } else if (keyEvent.getSource() == this.jdkPath) {
            this.model.setJDK(this.jdkPath.getText());
        } else if (keyEvent.getSource() == this.jitPath) {
            if (this.jitPath.getText().length() != 0) {
                this.model.setJITPath(this.jitPath.getText());
            } else {
                this.model.setJITPath(null);
            }
        }
    }

    public void reset() {
        boolean bl = this.model.isJITEnabled();
        this.jitButton.setSelected(bl);
        this.jitPath.setText(this.model.getJITPath());
        this.jitPathLabel.setEnabled(bl);
        this.jitPath.setEnabled(bl);
        boolean bl2 = this.model.isDebugEnabled();
        this.debugButton.setSelected(bl2);
        this.debugPort.setText(this.model.getDebugPort());
        this.debugPort.setEnabled(bl2);
        this.debugPortLabel.setEnabled(bl2);
        boolean bl3 = true;
        String string = this.model.getJDK();
        String[] stringArray = this.model.getInstalledJavaList();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (string == null || stringArray[n].equals(string)) {
                    this.jdkInstalled.setSelectedItem(stringArray[n]);
                    this.jdkPath.setEnabled(false);
                    this.pathLabel.setEnabled(false);
                    bl3 = false;
                    break;
                }
                ++n;
            }
        }
        if (bl3) {
            if (string.compareTo("Use Java Plug-in Default") == 0) {
                this.jdkInstalled.setSelectedItem(this.defaultJRE);
                this.pathLabel.setEnabled(false);
                this.jdkPath.setEnabled(false);
            } else {
                this.jdkPath.setText(string);
                this.jdkPath.setEnabled(true);
                this.jdkInstalled.setSelectedItem(this.otherJDK);
                this.pathLabel.setEnabled(true);
            }
        }
    }

    public static void setHideDebugBox(boolean bl) {
        hideDebugBox = bl;
    }

    public static void setHideJITBox(boolean bl) {
        hideJITBox = bl;
    }

    private boolean setInstalledJavaList() {
        if (this.jdkInstalled.getItemCount() > 0) {
            this.jdkInstalled.removeAllItems();
        }
        this.jdkInstalled.addItem(this.defaultJRE);
        String[] stringArray = this.model.getInstalledJavaList();
        int n = 0;
        while (n < stringArray.length) {
            this.jdkInstalled.addItem(stringArray[n]);
            ++n;
        }
        this.jdkInstalled.addItem(this.otherJDK);
        return true;
    }
}

