/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.navig.motif;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import sun.plugin.navig.motif.Plugin;

public class Worker {
    private static DataInputStream in;
    private static DataOutputStream out;
    private static int eventWindowID;
    private static int count;
    private static Hashtable proxmap;
    private static String cookieString;
    private static String cacheFile;
    private static byte[] httpsReply;
    private static byte[] httpsPostReply;
    public static final int JAVA_PLUGIN_SHOW_STATUS = 16121857;
    public static final int JAVA_PLUGIN_SHOW_DOCUMENT = 16121858;
    public static final int JAVA_PLUGIN_FIND_PROXY = 16121859;
    public static final int JAVA_PLUGIN_FIND_COOKIE = 16121860;
    public static final int JAVA_PLUGIN_CACHE_URL = 16121861;
    public static final int JAVA_PLUGIN_JAVASCRIPT_REQUEST = 0xF60006;
    public static final int JAVA_PLUGIN_GET_HTTPS = 16121863;
    public static final int JAVA_PLUGIN_POST_HTTPS = 16121864;
    private static String requestName;
    private static final int REQUEST_IDLE = 1;
    private static final int REQUEST_IN_PROGRESS = 2;
    private static final int RESPONSE_IS_READY = 3;
    private static final int REQUEST_ABRUPTLY_TERMINATED = 4;
    private static int requestStatus;
    static /* synthetic */ Class class$sun$plugin$navig$motif$Worker;

    static {
        cookieString = null;
        cacheFile = null;
        httpsReply = null;
        httpsPostReply = null;
        requestStatus = 1;
    }

    Worker(DataInputStream dataInputStream, DataOutputStream dataOutputStream) {
        in = dataInputStream;
        out = dataOutputStream;
        this.sendAck();
    }

    static synchronized void addProxyMapping(String string, String string2) {
        try {
            URL uRL = new URL(string);
            String string3 = String.valueOf(uRL.getProtocol()) + ":" + uRL.getHost() + ":" + uRL.getPort();
            proxmap.put(string3, string2);
            Worker.responseIsReady("Proxy");
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL in getting proxy: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static synchronized void clearRequest() {
        requestStatus = 1;
    }

    static synchronized void enterRequest(String string) {
        try {
            while (requestStatus != 1) {
                (class$sun$plugin$navig$motif$Worker != null ? class$sun$plugin$navig$motif$Worker : Worker.class$("sun.plugin.navig.motif.Worker")).wait();
            }
            requestName = string;
            requestStatus = 2;
            Plugin.trace("Entering request for:" + string);
        }
        catch (InterruptedException interruptedException) {
            Plugin.trace("Request was interrupted when entering");
        }
    }

    static synchronized String findCookieForURL(String string) {
        Plugin.trace("Worker.findCookieForURL: " + string);
        try {
            Worker.enterRequest("Cookie");
            cookieString = null;
            out.writeInt(16121860);
            out.writeShort(-1);
            Worker.writeString(string);
            Worker.pushRequest("FindCookie");
            Worker.waitForResponse("Cookie");
            String string2 = cookieString;
            Worker.clearRequest();
            Plugin.trace(" Got cookie string:" + string2);
            return string2;
        }
        catch (IOException iOException) {
            System.err.println("IOException in findCookieURL");
            System.err.println("Bad termination of cookie request!");
            Worker.clearRequest();
            return null;
        }
    }

    static synchronized String getCacheFileForURL(String string) {
        Plugin.trace("Worker.getCacheFileForURL:" + string);
        try {
            Worker.enterRequest("Cache");
            cacheFile = null;
            out.writeInt(16121861);
            out.writeShort(-1);
            Worker.writeString(string);
            Worker.pushRequest("getCache");
            Worker.waitForResponse("Cache");
            String string2 = cacheFile;
            Worker.clearRequest();
            if (string2 == null) {
                Plugin.trace(" No cache file");
            } else {
                Plugin.trace(" Got cache file:" + cacheFile);
            }
            return string2;
        }
        catch (IOException iOException) {
            Plugin.trace("sendCacheRequest: io error in plugin " + iOException);
            System.err.println("Error in getting cache file");
            Worker.clearRequest();
            return null;
        }
    }

    static synchronized byte[] getHttps(String string) {
        Plugin.debugStdErr("entering get https");
        try {
            if (!Plugin.isPluginAlive()) {
                return null;
            }
            Worker.enterRequest("getHttps");
            out.writeInt(16121863);
            out.writeShort(-1);
            Worker.writeString(string);
            Worker.pushRequest("getHttps:" + string);
            Worker.waitForResponse("getHttps");
            byte[] byArray = httpsReply;
            Worker.clearRequest();
            return byArray;
        }
        catch (IOException iOException) {
            System.err.println("getHttps: IO Error on plugin");
            iOException.printStackTrace();
            Worker.clearRequest();
            return null;
        }
    }

    static synchronized String getProxySettings(String string) {
        try {
            URL uRL = new URL(string);
            while (proxmap == null) {
                Plugin.trace("getProxySettings. Looking for proxmap.");
                (class$sun$plugin$navig$motif$Worker != null ? class$sun$plugin$navig$motif$Worker : Worker.class$("sun.plugin.navig.motif.Worker")).wait();
            }
            String string2 = String.valueOf(uRL.getProtocol()) + ":" + uRL.getHost() + ":" + uRL.getPort();
            Plugin.trace("getProxySettings. Using key:" + string2);
            String string3 = (String)proxmap.get(string2);
            if (string3 != null) {
                Plugin.trace("Retrieving cached proxy:" + string3);
                return string3;
            }
            Worker.enterRequest("Proxy");
            out.writeInt(16121859);
            out.writeShort(-1);
            Worker.writeString(string);
            Worker.writeString(uRL.getHost());
            Plugin.trace("FindProxy for:" + string.toString() + " host:" + uRL.getHost());
            Worker.pushRequest("FindProxy");
            Worker.waitForResponse("Proxy");
            string3 = (String)proxmap.get(string2);
            Worker.clearRequest();
            return string3;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Bad URL in getProxySettings: " + string);
        }
        catch (IOException iOException) {
            System.err.println("getProxySettings: IO error on plugin");
        }
        catch (InterruptedException interruptedException) {
            System.err.println("getProxySettings interrupted");
        }
        Worker.clearRequest();
        return null;
    }

    static synchronized byte[] postHttps(URLConnection uRLConnection, String string, byte[] byArray, int n) {
        Plugin.debugStdErr("entering post https\n");
        try {
            if (!Plugin.isPluginAlive()) {
                return null;
            }
            out.writeInt(16121864);
            out.writeShort(-1);
            Worker.writeString(string);
            Plugin.trace("https:" + string);
            String string2 = new String(byArray);
            Plugin.trace("https:" + string2);
            Plugin.debugStdErr("https:" + string2 + "\n");
            Plugin.trace("https:" + n);
            Worker.writeByteArray(byArray);
            out.writeInt(n);
            Worker.pushRequest("postHttps");
            Worker.waitForResponse("postHttps");
            byte[] byArray2 = httpsPostReply;
            Worker.clearRequest();
            return byArray2;
        }
        catch (IOException iOException) {
            System.err.println("An IOException in posting https\n");
            iOException.printStackTrace();
            return null;
        }
    }

    static synchronized void proxmapReady() {
        proxmap = new Hashtable();
        (class$sun$plugin$navig$motif$Worker != null ? class$sun$plugin$navig$motif$Worker : (class$sun$plugin$navig$motif$Worker = Worker.class$("sun.plugin.navig.motif.Worker"))).notifyAll();
    }

    private static synchronized void pushRequest(String string) throws IOException {
        Plugin.trace("Worker pushRequest" + string);
        out.flush();
        Worker.setX11Property(eventWindowID, "java_plugin_work", String.valueOf(++count));
    }

    static synchronized void responseIsReady(String string) {
        requestStatus = 3;
        Plugin.trace("Response is ready:" + string);
        (class$sun$plugin$navig$motif$Worker != null ? class$sun$plugin$navig$motif$Worker : (class$sun$plugin$navig$motif$Worker = Worker.class$("sun.plugin.navig.motif.Worker"))).notifyAll();
    }

    private void sendAck() {
        try {
            int n = 15;
            out.write(n);
            out.flush();
        }
        catch (IOException iOException) {
            System.err.println("IO Exception in sending ack!");
        }
    }

    static synchronized void sendJSRequest(int n, String string) {
        try {
            out.writeInt(0xF60006);
            out.writeShort((short)n);
            Worker.writeString(string);
            Worker.pushRequest("JS Request");
        }
        catch (IOException iOException) {
            System.err.println("sendJSRequest: io error in Plugin " + iOException);
        }
    }

    static synchronized void setCacheFile(String string) {
        cacheFile = string;
        Worker.responseIsReady("Cache");
    }

    static synchronized void setCookieString(String string) {
        cookieString = string;
        Worker.responseIsReady("Cookie");
    }

    void setEventWindowID(int n) {
        eventWindowID = n;
    }

    public static synchronized void setHttpsPostReply(byte[] byArray) {
        httpsPostReply = byArray;
        Worker.responseIsReady("postHttps");
    }

    public static synchronized void setHttpsReply(byte[] byArray) {
        httpsReply = byArray;
        Worker.responseIsReady("getHttps");
    }

    private static native void setX11Property(int var0, String var1, String var2);

    static synchronized void showDocument(int n, URL uRL, String string) {
        try {
            out.writeInt(16121858);
            out.writeShort(n);
            Worker.writeString(String.valueOf(String.valueOf(uRL)));
            Worker.writeString(string);
            Worker.pushRequest("showDocument");
        }
        catch (IOException iOException) {
            System.err.println("java process: write to parent failed");
        }
    }

    static synchronized void showStatus(int n, String string) {
        try {
            if (!Plugin.isPluginAlive()) {
                return;
            }
            out.writeInt(16121857);
            out.writeShort(n);
            Plugin.trace("Status:" + string);
            Worker.writeString(string);
            Worker.pushRequest("showStatus");
        }
        catch (IOException iOException) {
            System.err.println("java process: write to parent failed");
        }
    }

    static synchronized void terminateAbruptly() {
        Plugin.trace("Request was abruptly terminated");
        if (requestStatus != 1) {
            requestStatus = 4;
        }
        (class$sun$plugin$navig$motif$Worker != null ? class$sun$plugin$navig$motif$Worker : (class$sun$plugin$navig$motif$Worker = Worker.class$("sun.plugin.navig.motif.Worker"))).notifyAll();
    }

    static synchronized void terminateRequestAbruptly() {
        Worker.terminateAbruptly();
    }

    static synchronized boolean waitForResponse(String string) {
        try {
            while (requestStatus != 3) {
                (class$sun$plugin$navig$motif$Worker != null ? class$sun$plugin$navig$motif$Worker : Worker.class$("sun.plugin.navig.motif.Worker")).wait();
                Plugin.trace("Woke up in request for:" + string);
                if (requestStatus != 4) continue;
                Worker.clearRequest();
                return false;
            }
            Plugin.trace("Got response for request:" + string);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Plugin.trace("Request was interrupted before response");
            return false;
        }
    }

    private static synchronized void writeByteArray(byte[] byArray) throws IOException {
        out.writeInt(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            out.writeByte(byArray[n]);
            ++n;
        }
    }

    private static synchronized void writeString(String string) throws IOException {
        out.writeShort(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            out.writeByte((byte)c);
            ++n;
        }
    }
}

