/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import sun.plugin.ConsoleWindow;

public class DebugOutputStream
extends OutputStream {
    private FileOutputStream traceFile;
    private int count;
    private byte[] buf = new byte[80];
    private ConsoleWindow console = null;

    DebugOutputStream(ConsoleWindow consoleWindow) {
        this.console = consoleWindow;
        String string = System.getProperty("user.home");
        try {
            File file = new File(string, "plugin.trace");
            if (file.exists()) {
                file.delete();
            }
            this.traceFile = new FileOutputStream(file);
        }
        catch (Exception exception) {
            System.err.println("File tracing disabled due to the following exception");
            exception.printStackTrace();
        }
        this.count = 0;
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            if (this.console != null) {
                this.trace(this.buf, 0, this.count);
            }
            this.count = 0;
        }
    }

    protected void printDebug(String string) {
    }

    private void trace(byte[] byArray, int n, int n2) {
        if (this.console != null) {
            this.console.append(new String(byArray, n, n2));
        }
        try {
            if (this.traceFile != null) {
                this.traceFile.write(byArray, n, n2);
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized void write(int n) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)n;
        if (n == 10 || n == 13) {
            this.flushBuffer();
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.buf.length) {
            this.flushBuffer();
            this.trace(byArray, n, n2);
            return;
        }
        if (n2 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
        if (byArray[n2 - 1] == 10 || byArray[n2 - 1] == 13) {
            this.flushBuffer();
        }
    }
}

