  /*
        Copyright 06/11/99 Sun Microsystems, Inc. All Rights Reserved
  */
  
#ifndef _STDIO_ISO_SUNWCC_H
#define	_STDIO_ISO_SUNWCC_H

#pragma ident "@(#)stdio_iso_SUNWCC.h	1.3  06/11/99 C++5.0"

// needed for 2.5.1
#ifndef _FILE_OFFSET_BITS
    #define _FILE_OFFSET_BITS 32
#endif
#if _FILE_OFFSET_BITS - 0 != 32 && _FILE_OFFSET_BITS - 0 != 64
    #error "invalid _FILE_OFFSET_BITS value specified"
#endif

#include <sys/va_list.h>
#if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
#include <stdio_tag.h>
#include <stdio_impl.h>
#endif

extern "C" {

#if !defined(_LP64) && (_FILE_OFFSET_BITS == 64 || defined(_LARGEFILE64_SOURCE))
  #if !defined(_NO_LONGLONG)
    typedef long long __longlong_t;
  #else
    typedef union {
      double	_d;
      #if defined(__SunOS_5_5_1) && defined(__SunOS_5_6)
	long _l[2];
      #else
	int  _l[2];
      #endif
    } __longlong_t;
  #endif
#endif

#if #machine(i386) || defined(__i386)
  #define _NFILE 60
#else
  #define _NFILE 20
#endif

#ifndef NULL
#define NULL    0
#endif

#define	BUFSIZ	1024
#define	_SBFSIZ	8	/* compatibility with shared libs */

#define	_IOFBF		0000	/* full buffered */
#define	_IOLBF		0100	/* line buffered */
#define	_IONBF		0004	/* not buffered */
#define	_IOEOF		0020	/* EOF reached on read */
#define	_IOERR		0040	/* I/O error from system */

#define	_IOREAD		0001	/* currently reading */
#define	_IOWRT		0002	/* currently writing */
#define	_IORW		0200	/* opened for reading and writing */
#define	_IOMYBUF	0010	/* stdio malloc()'d buffer */

#ifndef EOF
#define	EOF	(-1)
#endif

#define	FOPEN_MAX	_NFILE
#define	FILENAME_MAX    1024	/* max # of characters in a path name */

#define	SEEK_SET	0
#define	SEEK_CUR	1
#define	SEEK_END	2
#define	TMP_MAX		17576	/* 26 * 26 * 26 */

#define	L_tmpnam	25	/* (sizeof(P_tmpdir) + 15) */

namespace std {

#if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
  typedef struct {
  #ifdef _STDIO_REVERSE
      unsigned char* _ptr;	 /* next character from/to here in buffer */
      int	           _cnt; /* number of available characters in buffer */
  #else
      int	           _cnt; /* number of available characters in buffer */
      unsigned char* _ptr;	 /* next character from/to here in buffer */
  #endif
      unsigned char* _base;	 /* the buffer */
      unsigned char _flag;	 /* the state of the stream */
      unsigned char _file;	 /* UNIX System file descriptor */
  } FILE;
#else
  #ifndef	_FILEDEFED
  #define	_FILEDEFED
  typedef	__FILE FILE;
  #endif
#endif /* __SunOS_5_5_1 && __SunOS_5_6 */

} /* end of namespace std */

#ifndef _LP64
  extern unsigned char* _bufendtab[];
  extern std::FILE*     _lastbuf;
  extern int            __filbuf(std::FILE *);
  extern int            __flsbuf(int, std::FILE *);
#endif

extern std::FILE __iob[_NFILE];
#define	stdin	(&__iob[0])
#define	stdout	(&__iob[1])
#define	stderr	(&__iob[2])

/* large file compilation environment setup */
#if !defined(_LP64) && _FILE_OFFSET_BITS == 64
  #ifdef __PRAGMA_REDEFINE_EXTNAME
    #pragma redefine_extname	fopen	fopen64
    #pragma redefine_extname	freopen	freopen64
    #pragma redefine_extname	tmpfile	tmpfile64
    #pragma redefine_extname	fgetpos	fgetpos64
    #pragma redefine_extname	fsetpos	fsetpos64
  #else
    #define	fopen			fopen64
    #define	freopen			freopen64
    #define	tmpfile			tmpfile64
    #define	fgetpos			fgetpos64
    #define	fsetpos			fsetpos64
  #endif
#endif

namespace std {

#if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
  #ifndef _STD_FILEDEFED
    #define _STD_FILEDEFED
    typedef __FILE FILE;
  #endif
#endif

#if defined(_LP64) || defined(_I32LPx)
  typedef unsigned long size_t;
#else
  typedef unsigned int  size_t;
#endif

#if defined(_LP64) || _FILE_OFFSET_BITS == 32
  typedef long		fpos_t;
#else
  typedef __longlong_t	fpos_t;
#endif

#if !defined(_REENTRANT) && !defined(_LP64)
  inline int getc(FILE* _p)
    { return --_p->_cnt < 0 ? __filbuf(_p) : (int)*_p->_ptr++; }
  inline int putc(int _x, FILE *_p)
    { return --_p->_cnt < 0 ? __flsbuf(_x, _p) :
			     (int)(*_p->_ptr++ = (unsigned char) _x);
    }
  inline void clearerr(FILE* _p) { _p->_flag &= ~(_IOERR | _IOEOF); }
  inline int  feof(FILE* _p)     { return _p->_flag & _IOEOF; }
  inline int  ferror(FILE* _p)   { return _p->_flag & _IOERR; }
#else
  int  getc(FILE *);
  int  putc(int, FILE *);
  void clearerr(FILE *);
  int  feof(FILE *);
  int  ferror(FILE *);
#endif

int	remove(const char *);
int	rename(const char *, const char *);
FILE	*tmpfile(void);
char	*tmpnam(char *);
int	fclose(FILE *);
int	fflush(FILE *);
FILE*	fopen(const char *, const char *);
FILE*	freopen(const char *, const char *, FILE *);
void	setbuf(FILE *, char *);
int	setvbuf(FILE *, char *, int, size_t);
int	fprintf(FILE *, const char *, ...);
int	fscanf(FILE *, const char *, ...);
int	printf(const char *, ...);
int	scanf(const char *, ...);
int	sprintf(char *, const char *, ...);
int	sscanf(const char *, const char *, ...);
int	vfprintf(FILE *, const char *, __va_list);
int	vprintf(const char *, __va_list);
int	vsprintf(char *, const char *, __va_list);
int	fgetc(FILE *);
char*	fgets(char *, int, FILE *);
int	fputc(int, FILE *);
int	fputs(const char *, FILE *);
inline int getchar() { return getc(stdin); }
char*	gets(char *);
inline int putchar(int _x) { return putc(_x, stdout); }
int	puts(const char *);
int	ungetc(int, FILE *);
size_t	fread(void *, size_t, size_t, FILE *);
size_t	fwrite(const void *, size_t, size_t, FILE *);
int	fgetpos(FILE *, fpos_t *);
int	fseek(FILE *, long, int);
int	fsetpos(FILE *, const fpos_t *);
long	ftell(FILE *);
void	rewind(FILE *);
void	perror(const char *);

} /* end of namespace std */

} /* end of extern "C" */

#endif /* _STDIO_ISO_SUNWCC_H */
