/*
	Copyright 06/21/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef	_WCTYPE_H
#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "wctype.h"
#else

  #define _WCTYPE_H
  #pragma ident "@(#)wctype.h	1.11  06/21/99 C++5.0"

  #include <wctype_iso_SUNWCC.h>

  #if ((!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE) && \
  	!defined(_POSIX_SOURCE) ) || defined(__EXTENSIONS__))
  #include <ctype.h>
  #include <wchar.h>
  #endif

  extern "C" {

  #if !defined(__SunOS_5_5_1) && !defined(__SunOS_5_6)
  extern	unsigned _iswctype(wchar_t, int);
  extern	wchar_t _trwctype(wchar_t, int);
  #endif

  } /* end of extern "C" */

  using std::wint_t;
  #if !defined(__SunOS_5_5_1)
    using std::wctrans_t;
    using std::wctrans;
    using std::towctrans;
  #endif
  using std::wctype_t;
  using std::iswctype;
  using std::wctype;
  using std::iswalnum;
  using std::iswalpha;
  using std::iswcntrl;
  using std::iswdigit;
  using std::iswgraph;
  using std::iswlower;
  using std::iswprint;
  using std::iswpunct;
  using std::iswspace;
  using std::iswupper;
  using std::iswxdigit;
  using std::towlower;
  using std::towupper;

  extern "C" {

  #if ((!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE) && \
  	!defined(_POSIX_SOURCE)) || defined(__EXTENSIONS__))

    struct _wctype {
	  wchar_t	tmin;	/* minimum code for wctype */
	  wchar_t	tmax;	/* maximum code for wctype */
	  unsigned char*index;	/* class index */
	  unsigned int* type;	/* class type */
	  wchar_t	cmin;	/* minimum code for conversion */
	  wchar_t	cmax;	/* maximum code for conversion */
	  wchar_t*	code;	/* conversion code */
    };

    int iswalpha(wint_t c);
    int iswupper(wint_t c);
    int iswlower(wint_t c);
    int iswdigit(wint_t c);
    int iswxdigit(wint_t c);
    int iswalnum(wint_t c);
    int iswspace(wint_t c);
    int iswpunct(wint_t c);
    int iswprint(wint_t c);
    int iswgraph(wint_t c);
    int iswcntrl(wint_t c);
    #define iswascii(c)	isascii(c)

    int isphonogram(wint_t);
    int isideogram(wint_t);
    int isenglish(wint_t);
    int isnumber(wint_t);
    int isspecial(wint_t);

    #define iscodeset0(c)	isascii(c)
    #define iscodeset1(c)	(((c) & WCHAR_CSMASK) == WCHAR_CS1)
    #define iscodeset2(c)	(((c) & WCHAR_CSMASK) == WCHAR_CS2)
    #define iscodeset3(c)	(((c) & WCHAR_CSMASK) == WCHAR_CS3)

  #endif

  } /* end of extern "C" */

#endif /* _ISO_CPP_14882_1998 */
#endif	/* _WCTYPE_H */
