/*
	Copyright 06/21/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _STDLIB_H
#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "stdlib.h"
#else

  #define _STDLIB_H
  #pragma ident "@(#)stdlib.h	1.10  06/21/99 C++5.0"   /* SVr4.0 2.34.1.2 */

  #include <stdlib_iso_SUNWCC.h>

  using std::div_t;
  using std::ldiv_t;
  using std::size_t;
  using std::abort;
  using std::abs;
  using std::atexit;
  using std::atof;
  using std::atoi;
  using std::atol;
  using std::bsearch;
  using std::calloc;
  using std::div;
  using std::exit;
  using std::free;
  using std::getenv;
  using std::labs;
  using std::ldiv;
  using std::malloc;
  using std::mblen;
  using std::mbstowcs;
  using std::mbtowc;
  using std::qsort;
  using std::rand;
  using std::realloc;
  using std::srand;
  using std::strtod;
  using std::strtol;
  using std::strtoul;
  using std::system;
  using std::wcstombs;
  using std::wctomb;

  #if defined(__EXTENSIONS__) || \
  	(defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 >= 4))
  #include <sys/wait.h>
  #endif

  extern "C" {

  /* large file compilation environment setup */
  #if !defined(_LP64) && _FILE_OFFSET_BITS == 64
    #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
	  (_POSIX_C_SOURCE > 2) || defined(__EXTENSIONS__)
      #ifdef __PRAGMA_REDEFINE_EXTNAME
	#pragma redefine_extname mkstemp mkstemp64
      #else
	#define	mkstemp mkstemp64
      #endif
    #endif
  #endif

  /* In the LP64 compilation environment, all APIs are already large file */
  #if defined(_LP64) && defined(_LARGEFILE64_SOURCE)
    #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
	  (_POSIX_C_SOURCE > 2) || defined(__EXTENSIONS__)
      #ifdef	__PRAGMA_REDEFINE_EXTNAME
	#pragma redefine_extname mkstemp64 mkstemp
      #else
	#define	mkstemp64 mkstemp
      #endif
    #endif
  #endif

  #ifndef _UID_T
  #define _UID_T
    #if defined(_LP64) || defined(_I32LPx)
      typedef	int	uid_t;
    #else
      typedef long	uid_t;
    #endif
  #endif

  void _exithandle(void);

  #if defined(__EXTENSIONS__) || defined(_REENTRANT) || \
  	(_POSIX_C_SOURCE - 0 >= 199506L)
    extern int rand_r(unsigned int *);
  #endif

  #if defined(__EXTENSIONS__) || !defined(_POSIX_C_SOURCE) || \
  	(defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 >= 4))
    double drand48(void);
    double erand48(unsigned short *);
    long   jrand48(unsigned short *);
    void   lcong48(unsigned short *);
    long   lrand48(void);
    long   mrand48(void);
    long   nrand48(unsigned short *);
    unsigned short *seed48(unsigned short *);
    void   srand48(long);
    #if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
      extern int putenv(const char *);
    #else
      extern int putenv(char *);
    #endif
    extern void setkey(const char *);
  #endif

  #if (defined(__EXTENSIONS__) || !defined(_POSIX_C_SOURCE)) && \
  	((_XOPEN_VERSION - 0 < 4) && (_XOPEN_SOURCE_EXTENDED - 0 < 1))
    void swab(const char *, char *, int);
  #endif

  #if (!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE)) || \
  	defined(_XPG4_2) || defined(__EXTENSIONS__)
    #if !defined(__Sun_OS_5_5_1)
      int mkstemp(char *);
      #if defined(_LARGEFILE64_SOURCE) && !((_FILE_OFFSET_BITS == 64) && \
	  !defined(__PRAGMA_REDEFINE_EXTNAME))
	int mkstemp64(char *);
      #endif
    #endif
  #endif

  #if defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && \
  	!defined(_XOPEN_SOURCE)) || defined(_XPG4_2)
    long  a64l(const char *);
    char* ecvt(double, int, int *, int *);
    char* fcvt(double, int, int *, int *);
    char* gcvt(double, int, char *);
    int   getsubopt(char **, char *const *, char **);
    int   grantpt(int);
    char* initstate(unsigned, char *, size_t);
    char* l64a(long);
    char* mktemp(char *);
    char* ptsname(int);
    long  random(void);
    char* realpath(const char *, char *);
    char* setstate(const char *);
    void  srandom(unsigned);
    int   ttyslot(void);
    int   unlockpt(int);
    void* valloc(size_t);
  #endif /* defined(__EXTENSIONS__) || ... || defined(_XPG4_2) */

  #if defined(__EXTENSIONS__) || \
  	(!defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE))
    int   dup2(int, int);
    char* qecvt(long double, int, int *, int *);
    char* qfcvt(long double, int, int *, int *);
    char* qgcvt(long double, int, char *);
    char* getcwd(char *, size_t);
    #if !defined(__Sun_OS_5_5_1)
      const char *getexecname(void);
      char *getpassphrase(const char *);
    #endif
    extern char* optarg;
    extern int   optind, opterr, optopt;
    char* getlogin(void);
    int   getopt(int, char *const *, const char *);
    char* getpass(const char *);
    int   getpw(uid_t, char *);
    int   isatty(int);
    void* memalign(size_t, size_t);
    char* ttyname(int);
    #if !defined(_NO_LONGLONG)
      typedef struct {
	    long long quot;
	    long long rem;
      } lldiv_t;
      long long atoll(const char *);
      long long llabs(long long);
      lldiv_t lldiv(long long, long long);
      char *lltostr(long long, char *);
      long long strtoll(const char *, char **, int);
      unsigned long long strtoull(const char *, char **, int);
      char *ulltostr(unsigned long long, char *);
    #endif
  #endif

  } /* end of extern "C" */

#endif /* _ISO_CPP_14882_1998 */
#endif	/* _STDLIB_H */
