  /*
        Copyright 06/21/99 Sun Microsystems, Inc. All Rights Reserved
  */
  
#ifndef _STDIO_H

#include <sys/feature_tests.h>

#ifdef _ISO_CPP_14882_1998
    #include "stdio.h"
#else
  #define _STDIO_H
  #pragma ident "@(#)stdio.h	1.12  06/21/99 C++5.0"

  #include <stdio_iso_SUNWCC.h>

  using std::FILE;
  using std::fpos_t;
  using std::size_t;
  using std::clearerr;
  using std::fclose;
  using std::feof;
  using std::ferror;
  using std::fflush;
  using std::fgetc;
  using std::fgetpos;
  using std::fgets;
  using std::fopen;
  using std::fprintf;
  using std::fputc;
  using std::fputs;
  using std::fread;
  using std::freopen;
  using std::fscanf;
  using std::fseek;
  using std::fsetpos;
  using std::ftell;
  using std::fwrite;
  using std::getc;
  using std::getchar;
  using std::gets;
  using std::perror;
  using std::printf;
  using std::putc;
  using std::putchar;
  using std::puts;
  using std::remove;
  using std::rename;
  using std::rewind;
  using std::scanf;
  using std::setbuf;
  using std::setvbuf;
  using std::sprintf;
  using std::sscanf;
  using std::tmpfile;
  using std::tmpnam;
  using std::ungetc;
  using std::vfprintf;
  using std::vprintf;
  using std::vsprintf;
  
  #pragma override_linkname
  typedef FILE __FILE;
  #pragma no_override_linkname
  
  extern "C" {
  
  #define	L_ctermid	9
  #define	L_cuserid	9
  
  #if defined(__EXTENSIONS__) || \
		!defined(_POSIX_C_SOURCE) || defined(_XOPEN_SOURCE)
    #define	P_tmpdir	"/var/tmp/"
  #endif
  
  #ifndef _STDIO_ALLOCATE
    extern unsigned char	 _sibuf[], _sobuf[];
  #endif
  
  /* large file compilation environment setup */
  #if !defined(_LP64) && _FILE_OFFSET_BITS == 64 && defined(_LARGEFILE_SOURCE)
    #ifdef __PRAGMA_REDEFINE_EXTNAME
      #pragma redefine_extname	fseeko	fseeko64
      #pragma redefine_extname	ftello	ftello64
    #else
      #define	fseeko			fseeko64
      #define	ftello			ftello64
    #endif
  #endif
  
  #if defined(_LARGEFILE_SOURCE) || defined(_XPG5)
    #if defined(_LP64) || _FILE_OFFSET_BITS == 32
      typedef long         off_t;
    #else
      typedef __longlong_t off_t;
    #endif
    #ifdef	_LARGEFILE64_SOURCE
      #ifdef _LP64
	typedef	off_t		off64_t;
      #else
	typedef __longlong_t	off64_t;
      #endif
    #endif
  #endif
  
  #ifdef _LARGEFILE64_SOURCE
    #ifdef _LP64
      typedef fpos_t		fpos64_t;
    #else
      typedef __longlong_t	fpos64_t;
  #endif
  #endif /* _LARGEFILE64_SOURCE */
  
  /*
   * XPG4 requires that va_list be defined in <stdio.h> "as described in
   * <stdarg.h>".  ANSI-C and POSIX require that the namespace of <stdio.h>
   * not be polluted with this name.
   */
  #if defined(_XOPEN_SOURCE) && (_XOPEN_VERSION - 0 >= 4) && !defined(_VA_LIST)
    #define	_VA_LIST
    typedef	__va_list va_list;
  #endif
  
  #if	defined(__EXTENSIONS__) || defined(_REENTRANT)
    extern char	*tmpnam_r(char *);
  #endif
  
  #if defined(__EXTENSIONS__) || \
      (!defined(_XOPEN_SOURCE) && !defined(_POSIX_C_SOURCE))
    void setbuffer(FILE *, char *, size_t);
    int setlinebuf(FILE *);
  #endif
  
  #if defined(__EXTENSIONS__) || \
      (!defined(_XOPEN_SOURCE) && !defined(_POSIX_C_SOURCE)) || defined(_XPG5)
    /* PRINTFLIKE3 */
    int	snprintf(char *, size_t, const char *, ...);
    int	vsnprintf(char *, size_t, const char *, __va_list);
  #endif
  
  FILE* fdopen(int, const char *);
  char* ctermid(char *);
  #if defined(__SunOS_5_5_1) || defined(__SunOS_5_6)
    inline int fileno(FILE* _p) { return _p->_file; }
  #else
    int fileno(FILE *);
  #endif
  
  /*
   * The following are known to POSIX.1c, but not to ANSI-C or XOPEN.
   */
  #if	defined(__EXTENSIONS__) || defined(_REENTRANT) || \
	  (_POSIX_C_SOURCE - 0 >= 199506L)
    void flockfile(FILE *);
    int	 ftrylockfile(FILE *);
    void funlockfile(FILE *);
    int	 getc_unlocked(FILE *);
    int	 getchar_unlocked(void);
    int	 putc_unlocked(int, FILE *);
    int	 putchar_unlocked(int);
  #endif
  
  FILE* popen(const char *, const char *);
  char* cuserid(char *);
  char* tempnam(const char *, const char *);
  int	getopt(int, char *const *, const char *);
  #if !defined(_XOPEN_SOURCE)
    int getsubopt(char **, char *const *, char **);
  #endif
  extern char	*optarg;
  extern int	optind, opterr, optopt;
  int	getw(FILE *);
  int	putw(int, FILE *);
  int	pclose(FILE *);
  
  /*
   * The following are defined as part of the Large File Summit interfaces.
   */
  #if defined(_LARGEFILE_SOURCE) || defined(_XPG5)
    int	fseeko(FILE *, off_t, int);
    off_t	ftello(FILE *);
  #endif
  
  /*
   * The following are defined as part of the transitional Large File Summit
   * interfaces.
   */
  #if	defined(_LARGEFILE64_SOURCE) && !((_FILE_OFFSET_BITS == 64) && \
	  !defined(__PRAGMA_REDEFINE_EXTNAME))
    FILE*   fopen64(const char *, const char *);
    FILE*   freopen64(const char *, const char *, FILE *);
    FILE*   tmpfile64(void);
    int	    fgetpos64(FILE *, fpos64_t *);
    int	    fsetpos64(FILE *, const fpos64_t *);
    int	    fseeko64(FILE *, off64_t, int);
    off64_t ftello64(FILE *);
  #endif
  
  #if !defined(lint) && !defined(__lint)
  
  #if	defined(__EXTENSIONS__) || defined(_REENTRANT) || \
	  (_POSIX_C_SOURCE - 0 >= 199506L)
    #ifndef	_LP64
      #define	getc_unlocked(p)	(--(p)->_cnt < 0 \
					  ? __filbuf(p) \
					  : (int)*(p)->_ptr++)
      #define	putc_unlocked(x, p)	(--(p)->_cnt < 0 \
					  ? __flsbuf((x), (p)) \
					  : (int)(*(p)->_ptr++ = \
					  (unsigned char) (x)))
    #endif
    #define	getchar_unlocked()	getc_unlocked(stdin)
    #define	putchar_unlocked(x)	putc_unlocked((x), stdout)
  #endif

  #endif /* lint */
  
  } /* end of extern "C" */
  
#endif /* _ISO_CPP_14882_1998 */
#endif	/* _STDIO_H */
