/*
	Copyright 06/29/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _SETJMP_H

#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "setjmp.h"
#else
  
  #define _SETJMP_H
  #pragma ident "@(#)setjmp.h	1.8  06/29/99 C++5.0"

  #include <setjmp_iso_SUNWCC.h>

  using std::jmp_buf;
  using std::longjmp;

  #if !defined(__SunOS_5_5_1)
    extern int _setjmp(jmp_buf);
    #pragma unknown_control_flow(_setjmp)
    extern void _longjmp(jmp_buf, int);
  #endif
  
  extern "C" {

  #if defined(_LP64) || defined(_I32LPx)
    typedef long sigjmp_buf[_SIGJBLEN];
  #else
    typedef int sigjmp_buf[_SIGJBLEN];
  #endif
  
  extern int sigsetjmp(sigjmp_buf, int);
  #pragma unknown_control_flow(sigsetjmp)
  extern void siglongjmp(sigjmp_buf, int);
  
  } /* end of extern "C" */
  
#endif	/* _ISO_CPP_14882_1998 */
#endif	/* _SETJMP_H */
