/*      Copyright (c) 1988 AT&T */
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*
 * Copyright (c) 1999, by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_MEMORY_H

#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "memory.h"
#else

  #define _MEMORY_H
  #pragma ident	"@(#)memory.h	1.4	99/06/30 SMI"	/* SVr4.0 1.4.1.2 */

  #include <sys/types.h>

  namespace std {
    // must cooperate with <string.h> on declarations of memchr
    extern "C" const void* memchr(const void *, int, size_t);
    #ifndef _MEMCHR_INLINE
    #define _MEMCHR_INLINE
    extern "C++" {
      inline void* memchr(void* _c, int _i, size_t _d) {
	 return (void*)memchr((const void *)_c, _i, _d);
      }
    }
    #endif /* _MEMCHR_INLINE */
  }
  using std::memchr;

  extern "C" {
    void* memccpy(void *, const void *, int, size_t);
    void* memcpy(void *, const void *, size_t);
    void* memset(void *, int, size_t);
    int   memcmp(const void *, const void *, size_t);
  }

#endif /* _ISO_CPP_14882_1998 */

#endif /* _MEMORY_H */
