/*
	Copyright 08/02/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _MATH_H

#include <sys/feature_tests.h>
#ifdef _ISO_CPP_14882_1998
  #include "math.h"
#else
  
  #define _MATH_H
  #pragma ident "@(#)math.h	1.10  08/02/99 C++5.0"

  #include <math_iso_SUNWCC.h>
  
  #if defined(_POSIX_SOURCE) && !defined(_POSIX_C_SOURCE)
  #define	_POSIX_C_SOURCE	1
  #endif
  
  using std::acos;
  using std::asin;
  using std::atan2;
  using std::atan;
  using std::ceil;
  using std::cos;
  using std::cosh;
  using std::exp;
  using std::fabs;
  using std::floor;
  using std::fmod;
  using std::frexp;
  using std::ldexp;
  using std::log10;
  using std::log;
  using std::modf;
  using std::pow;
  using std::sin;
  using std::sinh;
  using std::sqrt;
  using std::tan;
  using std::tanh;
  
  #define	__P(p)	p

  extern "C" {
    
  #if defined(__EXTENSIONS__) || \
  	!defined(_POSIX_C_SOURCE) || defined(_XOPEN_SOURCE)
  /*
   * SVID & X/Open
   */
  #define	M_E		2.7182818284590452354
  #define	M_LOG2E		1.4426950408889634074
  #define	M_LOG10E	0.43429448190325182765
  #define	M_LN2		0.69314718055994530942
  #define	M_LN10		2.30258509299404568402
  #define	M_PI		3.14159265358979323846
  #define	M_PI_2		1.57079632679489661923
  #define	M_PI_4		0.78539816339744830962
  #define	M_1_PI		0.31830988618379067154
  #define	M_2_PI		0.63661977236758134308
  #define	M_2_SQRTPI	1.12837916709551257390
  #define	M_SQRT2		1.41421356237309504880
  #define	M_SQRT1_2	0.70710678118654752440
  
  extern int signgam;
  
  #define	MAXFLOAT	((float)3.40282346638528860e+38)
  
  #if defined(__EXTENSIONS__) || !defined(_XOPEN_SOURCE)
  enum version {libm_ieee = -1, c_issue_4, ansi_1, strict_ansi};
  extern const enum version _lib_version;
  
  struct exception {
  	int type;
  	char *name;
  	double arg1;
  	double arg2;
  	double retval;
  };
  
  #define	HUGE		MAXFLOAT
  
  #define	_ABS(x)		((x) < 0 ? -(x) : (x))
  
  #define	_REDUCE(TYPE, X, XN, C1, C2)	{ \
  	double x1 = (double)(TYPE)X, x2 = X - x1; \
  	X = x1 - (XN) * (C1); X += x2; X -= (XN) * (C2); }
  
  #define	DOMAIN		1
  #define	SING		2
  #define	OVERFLOW	3
  #define	UNDERFLOW	4
  #define	TLOSS		5
  #define	PLOSS		6
  
  #define	_POLY1(x, c)	((c)[0] * (x) + (c)[1])
  #define	_POLY2(x, c)	(_POLY1((x), (c)) * (x) + (c)[2])
  #define	_POLY3(x, c)	(_POLY2((x), (c)) * (x) + (c)[3])
  #define	_POLY4(x, c)	(_POLY3((x), (c)) * (x) + (c)[4])
  #define	_POLY5(x, c)	(_POLY4((x), (c)) * (x) + (c)[5])
  #define	_POLY6(x, c)	(_POLY5((x), (c)) * (x) + (c)[6])
  #define	_POLY7(x, c)	(_POLY6((x), (c)) * (x) + (c)[7])
  #define	_POLY8(x, c)	(_POLY7((x), (c)) * (x) + (c)[8])
  #define	_POLY9(x, c)	(_POLY8((x), (c)) * (x) + (c)[9])
  #endif	/* defined(__EXTENSIONS__) || !defined(_XOPEN_SOURCE) */
  #endif	/* defined(__EXTENSIONS__) || ... */
  
  #if defined(__EXTENSIONS__) || \
  	!defined(_POSIX_C_SOURCE) || defined(_XOPEN_SOURCE)
  /*
   * SVID & X/Open
   */
  extern double erf __P((double));
  extern double erfc __P((double));
  extern double gamma __P((double));
  extern double hypot __P((double, double));
  extern int isnan __P((double));
  extern double j0 __P((double));
  extern double j1 __P((double));
  extern double jn __P((int, double));
  extern double lgamma __P((double));
  extern double y0 __P((double));
  extern double y1 __P((double));
  extern double yn __P((int, double));
  
  #if defined(__EXTENSIONS__) || !defined(_XOPEN_SOURCE) || \
  	_XOPEN_SOURCE - 0 == 500 || \
  	defined(_XOPEN_SOURCE) && _XOPEN_SOURCE_EXTENDED - 0 == 1
  /*
   * SVID & XPG 4.2/5
   */
  extern double acosh __P((double));
  extern double asinh __P((double));
  extern double atanh __P((double));
  extern double cbrt __P((double));
  extern double logb __P((double));
  extern double nextafter __P((double, double));
  extern double remainder __P((double, double));
  extern double scalb __P((double, double));
  
  /*
   * XPG 4.2/5
   */
  extern double expm1 __P((double));
  extern int ilogb __P((double));
  extern double log1p __P((double));
  extern double rint __P((double));
  #endif	/* defined(__EXTENSIONS__) || !defined(_XOPEN_SOURCE) || ... */
  
  #if defined(__EXTENSIONS__) || !defined(_XOPEN_SOURCE)
  /*
   * SVID
   */
  extern int matherr __P((struct exception *));
  
  /*
   * IEEE Test Vector
   */
  extern double significand __P((double));
  
  /*
   * Functions callable from C, intended to support IEEE arithmetic.
   */
  extern double copysign __P((double, double));
  extern double scalbn __P((double, int));
  
  /*
   * Reentrant version of gamma & lgamma; passes signgam back by reference
   * as the second argument; user must allocate space for signgam.
   */
  #ifdef _REENTRANT
  extern double gamma_r __P((double, int *));
  extern double lgamma_r __P((double, int *));
  #endif
  
  /*
   * Orphan(s); frexp, ldexp, modf and modff are part of libc nowadays.
   */
  extern float modff __P((float, float *));
  
  #include <floatingpoint.h>
  #endif	/* defined(__EXTENSIONS__) || !defined(_XOPEN_SOURCE) */
  #endif	/* defined(__EXTENSIONS__) || ... */
  
  } /* extern C */
  
#endif /* _ISO_CPP_14882_1998 */

#endif	/* _MATH_H */
