/*
	Copyright 06/16/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _MATH_ISO_SUNWCC_H
#define _MATH_ISO_SUNWCC_H
  
#pragma ident "@(#)math_iso_SUNWCC.h	1.3  06/16/99 C++5.0"

typedef union _h_val {
      #if defined(__SunOS_5_5_1)
	unsigned long _i[2];
      #else
	unsigned long _i[sizeof(double) / sizeof(unsigned long)];
      #endif /* __SunOS_5_5_1 */
      double _d;
} _h_val;
extern "C" const _h_val __huge_val;

#define	HUGE_VAL __huge_val._d

namespace std {

extern "C" {
double acos(double);
double asin(double);
double atan(double);
double atan2(double, double);
double cos(double);
double sin(double);
double tan(double);

double cosh(double);
double sinh(double);
double tanh(double);

double exp(double);
double frexp(double, int *);
double ldexp(double, int);
double log(double);
double log10(double);
double modf(double, double *);

double pow(double, double);
double sqrt(double);

double ceil(double);
double fabs(double);
double floor(double);
double fmod(double, double);
} /* extern C */

extern "C++" {
  inline double abs(double _d) { return fabs(_d); }
}

} /* end of namespace std */

#endif	/* _MATH_ISO_SUNWCC_H */
