/*
	Copyright 06/10/99 Sun Microsystems, Inc. All Rights Reserved
*/

#ifndef _LOCALE_ISO_SUNWCC_H
#define _LOCALE_ISO_SUNWCC_H
  
#pragma ident "@(#)locale_iso_SUNWCC.h	1.2  06/10/99 C++5.0"

extern "C" {
  
#define	LC_CTYPE	0	/* locale's ctype handline */
#define	LC_NUMERIC	1	/* locale's decimal handling */
#define	LC_TIME		2	/* locale's time handling */
#define	LC_COLLATE	3	/* locale's collation data */
#define	LC_MONETARY	4	/* locale's monetary handling */
#define	LC_MESSAGES	5	/* locale's messages handling */
#define	LC_ALL		6	/* name of locale's category name */

#define	_LastCategory	LC_MESSAGES	/* This must be last category */

#define	_ValidCategory(c) \
    (((int)(c) >= LC_CTYPE) && ((int)(c) <= _LastCategory) || \
    ((int)c == LC_ALL))

#ifndef NULL
#define NULL    0
#endif

namespace std {

  struct lconv {
      char* decimal_point;	/* decimal point character */
      char* thousands_sep;	/* thousands separator */
      char* grouping;		/* digit grouping */
      char* int_curr_symbol;	/* international currency symbol */
      char* currency_symbol;	/* national currency symbol */
      char* mon_decimal_point;	/* currency decimal point */
      char* mon_thousands_sep;	/* currency thousands separator */
      char* mon_grouping;	/* currency digits grouping */
      char* positive_sign;	/* currency plus sign */
      char* negative_sign;	/* currency minus sign */
      char  int_frac_digits;	/* internat currency fractional digits */
      char  frac_digits;	/* currency fractional digits */
      char  p_cs_precedes;	/* currency plus location */
      char  p_sep_by_space;	/* currency plus space ind. */
      char  n_cs_precedes;	/* currency minus location */
      char  n_sep_by_space;	/* currency minus space ind. */
      char  p_sign_posn;	/* currency plus position */
      char  n_sign_posn;	/* currency minus position */
  };

  extern char         *setlocale(int, const char *);
  extern struct lconv *localeconv(void);

} /* end of namespace std */

} /* end of extern "C" */


#endif	/* _LOCALE_ISO_SUNWCC_H */
