/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.CommaParse;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.LimitInputDocument;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;

public class AdminGroupDialog
extends AdminDialog {
    AdminDialog adminGroupDialog = this;
    JPanel groupPanel;
    JButton okButton;
    JButton cancelButton;
    JTextField groupTextField;
    JLabel gNameLabel;
    JTextArea groupMemTextArea;
    String[] members;
    URL url;
    GenInfoPanel infoPanel;
    JPanel blankPanel;
    String userType;
    GroupObj groupObj;
    boolean notValidGroupName = false;
    AdminMainPanel adminMainPanel;
    UserMgrClient userMgrClient;

    public AdminGroupDialog(JFrame jFrame, GroupObj groupObj) {
        super(jFrame, "Group Properties", false);
        Cloneable cloneable;
        this.adminGroupDialog.setTitle(UMgrResourceStrings.getString("group_props"));
        this.userMgrClient = UserMgrClient.instance();
        groupObj = this.userMgrClient.getGroupAttributes(groupObj);
        this.setGroupObj(groupObj);
        this.adminMainPanel = AdminMainPanel.sharedInstance();
        this.infoPanel = this.getInfoPanel();
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createGroupPanel());
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new OKCancelButtonListener());
        this.okButton.setEnabled(false);
        try {
            cloneable = this.userMgrClient.getUserRights();
            if (cloneable.contains("solaris.admin.usermgr.write")) {
                this.okButton.setEnabled(true);
            }
        }
        catch (AdminException adminException) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, adminException.getLocalizedMessage());
        }
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new OKCancelButtonListener());
        this.pack();
        cloneable = this.getSize();
        this.setMySize((Dimension)cloneable);
        this.setDefaultFocusListener(new UMgrContextHelpListener(this.infoPanel, "groups_prop"), true);
        if (!this.notValidGroupName) {
            this.groupTextField.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "groups_prop_name"));
        }
        this.groupMemTextArea.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "groups_prop_members"));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        1 var5_6 = new 1();
        this.adminGroupDialog.addWindowListener(var5_6);
    }

    private JPanel createGroupPanel() {
        Serializable serializable;
        this.groupPanel = new JPanel();
        this.groupPanel.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("group_id"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain(this.groupPanel, jPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.3, 20, 16, 0, 16);
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("group_mem"));
        jPanel2.setBorder(titledBorder2);
        jPanel2.setLayout(new GridBagLayout());
        Constraints.constrain(this.groupPanel, jPanel2, 0, 1, 1, 1, 1, 10, 0.0, 0.7, 12, 16, 5, 16);
        JLabel jLabel = new JLabel(UMgrResourceStrings.getString("group_name"));
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 24, 4, 0);
        String string = this.getGroupObj().getGroupName();
        if (CheckSyntax.isNameOK(string)) {
            this.notValidGroupName = false;
            serializable = new LimitInputDocument();
            this.groupTextField = new JTextField((Document)((Object)serializable), string, 10);
            this.groupTextField.setMinimumSize(this.groupTextField.getPreferredSize());
            Constraints.constrain(jPanel, this.groupTextField, 1, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 16, 4, 0);
        } else {
            this.notValidGroupName = true;
            this.gNameLabel = new JLabel(string);
            this.gNameLabel.setMinimumSize(this.gNameLabel.getPreferredSize());
            this.gNameLabel.setForeground(Color.black);
            Constraints.constrain(jPanel, this.gNameLabel, 1, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 16, 4, 0);
        }
        serializable = new JLabel(UMgrResourceStrings.getString("group_id_num"));
        ((JComponent)serializable).setForeground(Constants.PROPS_LABEL_COLOR);
        ((JComponent)serializable).setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, (Component)serializable, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 24, 0, 0);
        JLabel jLabel2 = new JLabel(this.getGroupObj().getGroupID());
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel2.setFont(Constants.PROPS_RO_VALUE_FONT);
        Constraints.constrain(jPanel, jLabel2, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 16, 0, 0);
        this.groupMemTextArea = new JTextArea(CommaParse.parseStrArrayToString(this.getGroupObj().getGroupUsers()), 9, 33);
        this.groupMemTextArea.setLineWrap(true);
        this.groupMemTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.groupMemTextArea);
        Constraints.constrain(jPanel2, jScrollPane, 0, 0, 1, 1, 1, 17, 1.0, 0.9, 10, 10, 10, 10);
        return this.groupPanel;
    }

    public void onEnterKey() {
    }

    public void setGroupObj(GroupObj groupObj) {
        this.groupObj = groupObj;
    }

    public GroupObj getGroupObj() {
        AdminCommonTools.CMN_HandleOutput("This is the user" + this.groupObj.getGroupName());
        return this.groupObj;
    }

    public boolean isModifyOK() {
        block17: {
            int n;
            String string;
            JFrame jFrame = AdminMainPanel.sharedInstance().jFrame;
            String string2 = "";
            GroupObj groupObj = this.getGroupObj();
            GroupObj groupObj2 = (GroupObj)groupObj.clone();
            String string3 = this.notValidGroupName ? this.gNameLabel.getText() : this.groupTextField.getText();
            String[] stringArray = CommaParse.parseStringToStrArray(this.groupMemTextArea.getText());
            String[] stringArray2 = new String[]{"0", ",", " ", "\t", "\n"};
            if (groupObj.getGroupName().equals(string3) && groupObj.getGroupUsers() == stringArray) break block17;
            AdminCommonTools.CMN_HandleOutput("Do Modify");
            if (groupObj.getGroupUsers() != stringArray) {
                AdminCommonTools.CMN_HandleOutput("The two string arrays are not equal");
            }
            if (!this.notValidGroupName) {
                if (!CheckSyntax.isNameOK(string3)) {
                    string2 = UMgrResourceStrings.getString("er_group_name_syntax");
                    new ErrorDialog(jFrame, string2);
                    return false;
                }
                groupObj2.setGroupName(string3);
            }
            if (!CheckSyntax.isStringOK(string = this.groupMemTextArea.getText(), stringArray2)) {
                string2 = UMgrResourceStrings.getString("er_group_members_syntax");
                new ErrorDialog(jFrame, string2);
                return false;
            }
            Object object = CommaParse.parseStringToStrArray(string);
            int n2 = ((String[])object).length;
            int n3 = 0;
            while (n3 < n2) {
                String string4 = object[n3];
                while (string4.startsWith(" ") || string4.startsWith("\t") || string4.startsWith("\n")) {
                    object[n3] = string4 = string4.substring(1);
                }
                while (string4.endsWith(" ") || string4.endsWith("\t") || string4.endsWith("\n")) {
                    n = string4.length();
                    string4 = string4.substring(0, n);
                    object[n3] = string4;
                }
                if (!string4.equals("")) {
                    if (!CheckSyntax.isNameOK(string4)) {
                        string2 = UMgrResourceStrings.getString("er_group_members_name");
                        new ErrorDialog(jFrame, string2);
                        return false;
                    }
                } else {
                    string2 = UMgrResourceStrings.getString("er_group_members_emp");
                    new ErrorDialog(jFrame, string2);
                    return false;
                }
                ++n3;
            }
            int n4 = 0;
            n = 1;
            while (n < n2) {
                int n5 = n4 + 1;
                while (n5 < n2) {
                    if (object[n4].equals(object[n5])) {
                        string2 = UMgrResourceStrings.getString("er_group_members_dup");
                        new ErrorDialog(jFrame, string2);
                        return false;
                    }
                    ++n5;
                }
                ++n4;
                ++n;
            }
            AdminCommonTools.CMN_HandleOutput("SUCCESS");
            groupObj2.setGroupUsers((String[])object);
            try {
                if (!groupObj2.equals(groupObj)) {
                    object = UserMgrClient.instance().modifyGroup(groupObj2, groupObj);
                    AdminViews.instance().modifyGroupObjInViews(groupObj, (GroupObj)object);
                    if (!groupObj.getGroupName().equals(((GroupObj)object).getGroupName())) {
                        AdminViews.instance().refreshGroupViews();
                        AdminViews.instance().setCurrentViewWithoutProgress(AdminViews.instance().getAncestorViewName(), AdminViews.instance().getCurrentViewName());
                    }
                }
            }
            catch (Exception exception) {
                new ErrorDialog(jFrame, exception.getLocalizedMessage());
            }
        }
        return true;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            AdminGroupDialog.this.adminGroupDialog.dispose();
        }

        /* synthetic */ 1() {
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == AdminGroupDialog.this.okButton) {
                    if (AdminGroupDialog.this.isModifyOK()) {
                        AdminGroupDialog.this.adminGroupDialog.dispose();
                        return;
                    }
                } else {
                    AdminGroupDialog.this.adminGroupDialog.dispose();
                }
                return;
            }
            catch (Exception exception) {
                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
                return;
            }
        }

        OKCancelButtonListener() {
            AdminGroupDialog.this = AdminGroupDialog.this;
        }
    }
}

