/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.common;

import com.sun.admin.hostmgr.common.HostException;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class NetworkData
implements Serializable {
    private static final int CLASS_A_MAX = 127;
    private static final int CLASS_B_MAX = 191;
    private static final int CLASS_C_MAX = 223;
    private static final int CLASS_D_MAX = 239;
    private static final int MAXDESCRIPTIONLEN = 256;
    private static final int MAXNETWORKNAMELEN = 256;
    private static final int IP_ADDRESS_OCTETS = 4;
    private static final int NETMASK_SIZE = 32;
    private String networkName = "";
    private String aliases = "";
    private String netmask = "";
    private String networkAddress = "";
    private String comment = "";
    private String netId = "";
    private String networkNetmask = "";
    private boolean equalsNetwork = false;
    private long netAddrLong;
    private long netIdLong;
    private long netmaskLong;
    private int netmaskShiftCount;
    private long networkNetmaskLong;
    private int networkNetmaskShiftCount;

    public NetworkData() {
    }

    public NetworkData(String string) {
        this.setNetworkAddress(string);
    }

    public String getNetworkName() {
        return this.networkName;
    }

    public void setNetworkName(String string) {
        this.networkName = string;
    }

    public String getAliases() {
        return this.aliases;
    }

    public void setAliases(String string) {
        this.aliases = string;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public long getNetmaskLong() {
        return this.netmaskLong;
    }

    public void setNetmask(String string) {
        long l;
        this.netmaskLong = 0L;
        if (string.equals("")) {
            return;
        }
        this.netmask = string;
        try {
            NetworkData.validateIPAddress(string);
        }
        catch (Exception exception) {
            return;
        }
        this.netmaskLong = l = this.convertAddressToLong(string);
        this.netmaskShiftCount = 0;
        while (l % 2L == 0L) {
            l >>= 1;
            ++this.netmaskShiftCount;
        }
    }

    public int getNetmaskShiftCount() {
        return this.netmaskShiftCount;
    }

    public void setNetmaskForSubnet(String string) {
        long l;
        this.networkNetmaskLong = 0L;
        if (string.equals("")) {
            return;
        }
        this.networkNetmask = string;
        try {
            NetworkData.validateIPAddress(string);
        }
        catch (Exception exception) {
            return;
        }
        this.networkNetmaskLong = l = this.convertAddressToLong(string);
        this.networkNetmaskShiftCount = 0;
        while (l % 2L == 0L) {
            l >>= 1;
            ++this.networkNetmaskShiftCount;
        }
    }

    public String getNetworkAddress() {
        return this.networkAddress;
    }

    public long getNetworkAddressLong() {
        return this.netAddrLong;
    }

    public void setNetworkAddress(String string) {
        String string2;
        this.networkAddress = string;
        this.equalsNetwork = true;
        try {
            NetworkData.validateIPAddress(string);
        }
        catch (Exception exception) {
            this.netAddrLong = 0L;
            this.netIdLong = 0L;
            return;
        }
        int n = 0;
        int n2 = 3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        this.netId = string2 = stringTokenizer.nextToken();
        int n3 = new Integer(string2);
        this.netAddrLong = n3;
        this.netIdLong = n3;
        if (n3 > 127) {
            n = n3 <= 191 ? 1 : 2;
        }
        while (stringTokenizer.hasMoreTokens()) {
            this.netAddrLong <<= 8;
            this.netIdLong <<= 8;
            --n2;
            string2 = stringTokenizer.nextToken();
            n3 = new Integer(string2);
            this.netAddrLong |= (long)n3;
            if (n <= 0) continue;
            this.netIdLong |= (long)n3;
            this.netId = String.valueOf(this.netId) + "." + string2;
            --n;
        }
        this.netAddrLong <<= n2 * 8;
        this.netIdLong <<= n2 * 8;
        if (this.netAddrLong != this.netIdLong) {
            this.equalsNetwork = false;
        }
    }

    public String getDescription() {
        return this.comment;
    }

    public void setDescription(String string) {
        this.comment = string;
    }

    public long getNetIdLong() {
        return this.netIdLong;
    }

    public String getNetId() {
        return this.netId;
    }

    public int netAddrCompare(NetworkData networkData) {
        int n = 0;
        long l = networkData.getNetworkAddressLong();
        if (this.netAddrLong < l) {
            n = -1;
        } else if (this.netAddrLong > l) {
            n = 1;
        }
        return n;
    }

    public int netIdCompare(NetworkData networkData) {
        int n = 0;
        long l = networkData.getNetIdLong();
        if (this.netIdLong < l) {
            n = -1;
        } else if (this.netIdLong > l) {
            n = 1;
        }
        return n;
    }

    public boolean belongsNetwork(String string) {
        boolean bl = false;
        long l = this.convertAddressToLong(string);
        if (this.isNetwork()) {
            String string2 = this.convertLongToAddress(l);
            if (string2.startsWith(String.valueOf(this.netId) + ".")) {
                bl = true;
            }
        } else if ((l & this.networkNetmaskLong) == this.netAddrLong) {
            bl = true;
        }
        return bl;
    }

    public static final void validateNetworkName(String string) throws HostException {
        if (string.length() == 0) {
            return;
        }
        if (string.length() == 1 || string.length() > 256) {
            throw new HostException("EXM_HST_CMN7");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        if (!Character.isLetterOrDigit(c)) {
            throw new HostException("EXM_HST_CMN7");
        }
        int n = 1;
        while (n < stringBuffer.length()) {
            c = stringBuffer.charAt(n);
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '-' && c != '.') {
                throw new HostException("EXM_HST_CMN7");
            }
            ++n;
        }
        if (c == '_' || c == '-' || c == '.') {
            throw new HostException("EXM_HST_CMN7");
        }
    }

    public static final void validateAliasNames(String string) throws HostException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                NetworkData.validateNetworkName(string2);
            }
            catch (HostException hostException) {
                throw new HostException("EXM_HST_CMN6");
            }
        }
    }

    public static final void validateIPAddress(String string) throws HostException {
        int n = 0;
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            String string2 = stringTokenizer.nextToken();
            try {
                n2 = new Integer(string2);
            }
            catch (Exception exception) {
                throw new HostException("EXM_HST_CMN1");
            }
            if (n2 >= 0 && n2 <= 255) continue;
            throw new HostException("EXM_HST_CMN1");
        }
    }

    public static final void validateNetmask(String string) throws HostException {
        boolean bl = false;
        int n = 0;
        int[] nArray = new int[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                nArray[n] = new Integer(string2);
            }
            catch (Exception exception) {
                throw new HostException("EXM_HST_CMN4");
            }
            if (nArray[n] < 0 || nArray[n] > 255) {
                throw new HostException("EXM_HST_CMN4");
            }
            ++n;
        }
        if (nArray[3] == 255) {
            throw new HostException("EXM_HST_CMN4");
        }
        long l = nArray[0] << 24 | nArray[1] << 16 | nArray[2] << 8 | nArray[3];
        long l2 = 1L;
        l2 <<= 31;
        while (l2 != 0L) {
            long l3 = l & l2;
            if (l3 == 0L) {
                bl = true;
            } else if (bl) {
                throw new HostException("EXM_HST_CMN4");
            }
            l2 >>= 1;
        }
    }

    public static final void validateDescription(String string) throws HostException {
        if (string.length() == 0) {
            return;
        }
        if (string.length() > 256) {
            throw new HostException("EXM_HST_CMN8");
        }
    }

    public long convertAddressToLong(String string) {
        int n = 3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        String string2 = stringTokenizer.nextToken();
        long l = new Integer(string2).intValue();
        while (stringTokenizer.hasMoreTokens()) {
            l <<= 8;
            --n;
            string2 = stringTokenizer.nextToken();
            l |= (long)new Integer(string2).intValue();
        }
        return l <<= n * 8;
    }

    public String convertLongToAddress(long l) {
        String[] stringArray = new String[4];
        stringArray[3] = String.valueOf(l & 0xFFL);
        int n = 3;
        while (n > 0) {
            stringArray[n - 1] = String.valueOf((l >>= 8) & 0xFFL);
            --n;
        }
        String string = stringArray[0];
        n = 1;
        while (n < 4) {
            if (stringArray[n].equals("0")) break;
            string = String.valueOf(string) + "." + stringArray[n];
            ++n;
        }
        return string;
    }

    public Vector tokenizeNetworkAddress(String string) {
        Vector<String> vector = new Vector<String>(4);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        return vector;
    }

    public boolean isNetwork() {
        return this.equalsNetwork;
    }

    public boolean isStaticNetwork() {
        return this.networkName.length() != 0 || this.netmask.length() != 0;
    }

    public boolean equals(NetworkData networkData) {
        if (networkData == null) {
            return false;
        }
        return this.getNetworkName().equals(networkData.getNetworkName()) && this.getNetworkAddress().equals(networkData.getNetworkAddress()) && this.getAliases().equals(networkData.getAliases()) && this.getDescription().equals(networkData.getDescription()) && this.getNetmask().equals(networkData.getNetmask());
    }

    public void print() {
        System.out.println("*************************************");
        if (this.isStaticNetwork()) {
            System.out.println("--Statically defined network--");
        } else {
            System.out.println("--Dynamically defined network--");
        }
        System.out.println("Network name: " + this.networkName);
        System.out.println("Network address: " + this.networkAddress);
        System.out.println("Netmask: " + this.netmask);
        System.out.println("Aliases: " + this.aliases);
        System.out.println("Description: " + this.comment);
        if (!this.isNetwork()) {
            System.out.println("Subnet's parent network netmask: " + this.networkNetmask);
        }
        System.out.println("*************************************");
    }
}

