/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.HostRenameDialog;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class HostRenameDialog
extends AdminDialog {
    private HostData originalHostObj;
    private JLabel oldNameLabel;
    private JLabel newNameLabel;
    private JLabel ipAddressLabel;
    private JLabel ipAddress;
    private JLabel descriptionLabel;
    private JTextArea description;
    private JTextField hostName;
    private ResourceBundle bundle = Main.getApp().getResourceBundle();

    public HostRenameDialog(JFrame jFrame, HostData hostData) {
        super(jFrame, "", true);
        this.setTitle(ResourceStrings.getString(this.bundle, "RenameHost"));
        GenInfoPanel genInfoPanel = this.getInfoPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(this.bundle, "OldHostName");
        this.oldNameLabel = new JLabel(actionString.getString());
        Constraints.constrain(jPanel, this.oldNameLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 20, 5, 10, 5);
        this.oldNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.oldNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        JLabel jLabel = new JLabel(hostData.getHostName());
        Constraints.constrain(jPanel, jLabel, 1, -1, 1, 1, 0, 17, 0.0, 0.0, 20, 0, 10, 5);
        jLabel.setForeground(Constants.PROPS_RO_VALUE_COLOR);
        jLabel.setFont(Constants.PROPS_RO_VALUE_FONT);
        actionString = new ActionString(this.bundle, "NewHostName");
        this.newNameLabel = new JLabel(actionString.getString());
        Constraints.constrain(jPanel, this.newNameLabel, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.newNameLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.newNameLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.hostName = new JTextField(16);
        Constraints.constrain(jPanel, this.hostName, 1, -1, 1, 1, 2, 17, 0.0, 0.0, 0, 0, 10, 5);
        this.hostName.setFont(Constants.PROPS_RW_VALUE_FONT);
        this.hostName.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_rename_name"));
        this.hostName.requestFocus();
        this.newNameLabel.setLabelFor(this.hostName);
        this.newNameLabel.setDisplayedMnemonic(actionString.getMnemonic());
        actionString = new ActionString(this.bundle, "GenPropsNetAddr");
        this.ipAddressLabel = new JLabel(actionString.getString());
        Constraints.constrain(jPanel, this.ipAddressLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        this.ipAddressLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.ipAddressLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.ipAddressLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.ipAddress = new JLabel(hostData.getNetworkAddress());
        Constraints.constrain(jPanel, this.ipAddress, 1, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 10, 5);
        this.ipAddress.setFont(Constants.PROPS_RO_VALUE_FONT);
        this.ipAddress.setForeground(Constants.PROPS_RO_VALUE_COLOR);
        this.ipAddressLabel.setLabelFor(this.ipAddress);
        actionString = new ActionString(this.bundle, "GenPropsDescription");
        this.descriptionLabel = new JLabel(actionString.getString());
        Constraints.constrain(jPanel, this.descriptionLabel, 0, -1, 1, 1, 0, 18, 0.0, 0.0, 0, 5, 10, 5);
        this.descriptionLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        this.descriptionLabel.setFont(Constants.PROPS_LABEL_FONT);
        this.descriptionLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.description = new JTextArea(hostData.getDescription(), 3, 24);
        this.description.setLineWrap(true);
        this.description.setEditable(false);
        this.description.setFont(Constants.PROPS_RO_VALUE_FONT);
        this.description.setForeground(Constants.PROPS_RO_VALUE_COLOR);
        this.description.setBackground(((Component)this).getBackground());
        this.descriptionLabel.setLabelFor(this.description);
        JScrollPane jScrollPane = new JScrollPane(this.description, 20, 31);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Constraints.constrain(jPanel, jScrollPane, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        Font font = jPanel.getFont();
        Toolkit.getDefaultToolkit().getFontMetrics(font).getHeight();
        this.getRightPanel().add("Center", jPanel);
        JButton jButton = this.getOKBtn();
        jButton.addActionListener(new 1());
        JButton jButton2 = this.getCancelBtn();
        jButton2.addActionListener(new 3());
        this.getbuttonPanel().remove(this.getApplyBtn());
        this.pack();
        this.setMySize(this.getSize());
        this.setDefaultFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_rename_overview"), true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.originalHostObj = hostData;
    }

    public void onApply() throws HostException {
        HostData hostData = new HostData();
        hostData.setHostName(this.hostName.getText());
        hostData.setDescription(this.originalHostObj.getDescription());
        hostData.setNetworkAddress(this.originalHostObj.getNetworkAddress());
        hostData.setAliases(this.originalHostObj.getAliases());
        hostData.setEthernetAddress(this.originalHostObj.getEthernetAddress());
        Vector vector = Main.getApp().getTree().getCurrentContentPanel().getDataCache();
        ProgressPanel progressPanel = new ProgressPanel(Main.getApp().getFrame(), 3, 30, false);
        if (hostData.getHostName().length() == 0) {
            this.hostName.requestFocus();
            HostException hostException = new HostException("EXM_HST_GUI_MISSING_PROPS_VALUE", this.newNameLabel.getText().substring(0, this.newNameLabel.getText().length() - 1));
            Main.getApp().reportErrorException(hostException);
            throw hostException;
        }
        try {
            HostData.validateHostName(this.hostName.getText());
        }
        catch (HostException hostException) {
            this.hostName.requestFocus();
            Main.getApp().reportErrorException(hostException);
            throw hostException;
        }
        try {
            Object object;
            Object object2;
            progressPanel.setTitle(ResourceStrings.getString(this.bundle, "RenameHostTitle"));
            ((Component)progressPanel).setVisible(true);
            String string = ResourceStrings.getString(this.bundle, "RenamingHost");
            Object[] objectArray = new Object[]{hostData.getHostName()};
            progressPanel.setText(MessageFormat.format(string, objectArray));
            int n = Main.getApp().getHostMgr().renameHost(this.originalHostObj, hostData.getHostName(), new Integer(0));
            if (n > 1) {
                object2 = new Object[]{ResourceStrings.getString(this.bundle, "OptionRenameYes"), ResourceStrings.getString(this.bundle, "OptionRenameNo"), ResourceStrings.getString(this.bundle, "Cancel")};
                String string2 = "\n";
                string2 = String.valueOf(string2) + ResourceStrings.getString(this.bundle, "OptionRenameMessage");
                int n2 = JOptionPane.showOptionDialog(null, string2 = String.valueOf(string2) + "\n\n", (String)(object = ResourceStrings.getString(this.bundle, "OptionRenameTitle")), -1, 3, null, (Object[])object2, object2[0]);
                if (n2 == 2) {
                    throw new HostException("");
                }
                if (n2 == 0) {
                    Main.getApp().getHostMgr().renameHost(this.originalHostObj, hostData.getHostName(), new Integer(n));
                }
                if (n2 == 1) {
                    Main.getApp().getHostMgr().renameHost(this.originalHostObj, hostData.getHostName(), new Integer(1));
                    n = 1;
                }
            }
            progressPanel.appendText(ResourceStrings.getString(this.bundle, "UpdatingOtherViews"));
            ContentPanel.broadcastUpdate(this.originalHostObj, hostData, false);
            if (n > 1) {
                object2 = new Vector();
                int n3 = 0;
                while (n3 < vector.size()) {
                    object = (HostData)vector.elementAt(n3);
                    if (((HostData)object).getHostName().compareTo(this.originalHostObj.getHostName()) == 0) {
                        ((Vector)object2).addElement(object);
                    }
                    ++n3;
                }
                int n4 = 0;
                while (n4 < ((Vector)object2).size()) {
                    HostData hostData2 = (HostData)((Vector)object2).elementAt(n4);
                    HostData hostData3 = (HostData)hostData2.clone();
                    hostData3.setHostName(hostData.getHostName());
                    ContentPanel.broadcastUpdate(hostData2, hostData3, false);
                    ++n4;
                }
            }
            progressPanel.appendText(ResourceStrings.getString(this.bundle, "RepaintingCurrentView"));
            Main.getApp().getTree().getCurrentContentPanel().repaintView();
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            return;
        }
        catch (HostException hostException) {
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            this.hostName.requestFocus();
            if (hostException.getLocalizedMessage().length() > 0) {
                Main.getApp().reportErrorException(hostException);
            }
            throw hostException;
        }
        catch (Exception exception) {
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            this.hostName.requestFocus();
            Main.getApp().reportErrorException(exception);
            throw new HostException(exception.getMessage());
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            2 var2_2 = new 2(HostRenameDialog.this);
            var2_2.start();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            HostRenameDialog.this.dispose();
        }

        /* synthetic */ 3() {
        }
    }
}

