/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.DeleteAction;
import com.sun.admin.fsmgr.client.mount.FsMgrAddMountWizard;
import com.sun.admin.fsmgr.client.mount.FsMgrMountData;
import com.sun.admin.fsmgr.client.mount.FsMgrMountPropDlg;
import com.sun.admin.fsmgr.client.mount.Mount;
import com.sun.admin.fsmgr.client.mount.MountCacheEntry;
import com.sun.admin.fsmgr.client.mount.MountListView;
import com.sun.admin.fsmgr.client.mount.MountPropSelectDlg;
import com.sun.admin.fsmgr.client.mount.MountResolveDlg;
import com.sun.admin.fsmgr.client.mount.UnmountAction;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.fsmgr.common.FsMgrMountDataException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;

public class MountActionsListener
implements ActionListener {
    public static final String NEW_MOUNT = "NewMount";
    public static final String UNMOUNT_NOW = "UnmountNow";
    public static final String UNMOUNT_BOOT = "UnmountBoot";
    public static final String UNMOUNT_BOTH = "UnmountBoth";
    public static final String MOUNT_NOW = "MountNow";
    public static final String MOUNT_BOOT = "MountBoot";
    public static final String DELETE_MOUNT = "DeleteMount";
    public static final String RESOLVE = "ResolveConflicts";
    public static final String REFRESH = "Refresh";
    public static final String SORT_ASCENDING = "SortAscending";
    public static final String SORT_DESCENDING = "SortDescending";
    public static final String SORT_RESOURCE = MountListView.RESOURCE_SORT;
    public static final String SORT_MOUNTPOINT = MountListView.MOUNTPOINT_SORT;
    public static final String SORT_TYPE = MountListView.TYPE_SORT;
    public static final String SORT_STATUS = MountListView.STATUS_SORT;
    public static final String SORT_ACCESS = MountListView.ACCESS_SORT;
    public static final String VIEW_MOUNT = "ViewMount";
    public static final String EDIT_NOW = "EditNow";
    public static final String EDIT_BOOT = "EditBoot";
    public static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(UNMOUNT_NOW) || string.equals(UNMOUNT_BOOT) || string.equals(UNMOUNT_BOTH)) {
            this.unmountSelectedMount(string);
            return;
        }
        if (string.equals(MOUNT_NOW) || string.equals(MOUNT_BOOT)) {
            this.mountSelectedMount(string);
            return;
        }
        if (string.equals(NEW_MOUNT)) {
            FsMgrAddMountWizard fsMgrAddMountWizard = FsMgrAddMountWizard.instance();
            fsMgrAddMountWizard.pack();
            ((Component)fsMgrAddMountWizard).setLocation(MountActionsListener.screenSize.width / 2 - fsMgrAddMountWizard.getSize().width / 2, MountActionsListener.screenSize.height / 2 - fsMgrAddMountWizard.getSize().height / 2);
            fsMgrAddMountWizard.setVisible(true);
            return;
        }
        if (string.equals(DELETE_MOUNT)) {
            this.delete_mount();
            return;
        }
        if (string.equals(RESOLVE)) {
            MountListView mountListView = Mount.getInstance().getContentPanel().getCurrentView();
            MountCacheEntry mountCacheEntry = (MountCacheEntry)mountListView.getSelectedItem();
            MountResolveDlg mountResolveDlg = new MountResolveDlg(mountCacheEntry);
            ((Component)mountResolveDlg).setLocation(MountActionsListener.screenSize.width / 2 - mountResolveDlg.getSize().width / 2, MountActionsListener.screenSize.height / 2 - mountResolveDlg.getSize().height / 2);
            ((Component)mountResolveDlg).setVisible(true);
            return;
        }
        if (string.equals(EDIT_NOW)) {
            MountCacheEntry mountCacheEntry = ((MountPropSelectDlg)actionEvent.getSource()).getCacheEntry();
            this.editMountProperties(mountCacheEntry, MountCacheEntry.NOW);
            return;
        }
        if (string.equals(EDIT_BOOT)) {
            MountCacheEntry mountCacheEntry = ((MountPropSelectDlg)actionEvent.getSource()).getCacheEntry();
            this.editMountProperties(mountCacheEntry, MountCacheEntry.ATBOOT);
            return;
        }
        if (string.equals(REFRESH)) {
            Mount.getInstance().update();
            return;
        }
        if (string.equals(SORT_ASCENDING)) {
            Mount.getInstance().getContentPanel().getCurrentView().sortAscending();
            return;
        }
        if (string.equals(SORT_DESCENDING)) {
            Mount.getInstance().getContentPanel().getCurrentView().sortDescending();
            return;
        }
        if (string.compareTo(SORT_RESOURCE) == 0 || string.compareTo(SORT_MOUNTPOINT) == 0 || string.compareTo(SORT_TYPE) == 0 || string.compareTo(SORT_STATUS) == 0 || string.compareTo(SORT_ACCESS) == 0) {
            Mount.getInstance().getContentPanel().getCurrentView().sortByAttribute(string);
            return;
        }
        if (string.equals(VIEW_MOUNT)) {
            this.viewSelectedMount();
            return;
        }
        AdminCommonTools.CMN_HandleOutput("Unimplemented feature:" + string);
    }

    private void viewSelectedMount() {
        MountListView mountListView = Mount.getInstance().getContentPanel().getCurrentView();
        MountCacheEntry mountCacheEntry = (MountCacheEntry)mountListView.getSelectedItem();
        if (mountCacheEntry == null) {
            return;
        }
        if (mountCacheEntry.isConflict()) {
            MountPropSelectDlg mountPropSelectDlg = new MountPropSelectDlg(mountCacheEntry);
            ((Component)mountPropSelectDlg).setLocation(MountActionsListener.screenSize.width / 2 - mountPropSelectDlg.getSize().width / 2, MountActionsListener.screenSize.height / 2 - mountPropSelectDlg.getSize().height / 2);
            ((Component)mountPropSelectDlg).setVisible(true);
            return;
        }
        String string = mountCacheEntry.getStatus();
        this.editMountProperties(mountCacheEntry, string);
    }

    private void editMountProperties(MountCacheEntry mountCacheEntry, String string) {
        FsMgrMountPropDlg fsMgrMountPropDlg = new FsMgrMountPropDlg(mountCacheEntry, string, false);
        ((Component)fsMgrMountPropDlg).setLocation(MountActionsListener.screenSize.width / 2 - fsMgrMountPropDlg.getSize().width / 2, MountActionsListener.screenSize.height / 2 - fsMgrMountPropDlg.getSize().height / 2);
        ((Component)fsMgrMountPropDlg).setVisible(true);
    }

    private void unmountSelectedMount(String string) {
        String string2 = string;
        1 var3_3 = new 1(string2);
        var3_3.start();
    }

    private void mountSelectedMount(String string) {
        String string2 = string;
        2 var3_3 = new 2(string2, this);
        var3_3.start();
    }

    private void delete_mount() {
        3 var1_1 = new 3();
        var1_1.start();
    }

    private void refresh(String string, String string2) {
        Mount.getInstance().refresh(string, string2);
    }

    private static final class 1
    extends Thread {
        private final /* synthetic */ String val$cmd;

        public void run() {
            FsMgr.getFsMgr().getClientComm().waitOn();
            MountListView mountListView = Mount.getInstance().getContentPanel().getCurrentView();
            MountCacheEntry mountCacheEntry = (MountCacheEntry)mountListView.getSelectedItem();
            if (mountCacheEntry == null) {
                return;
            }
            UnmountAction unmountAction = new UnmountAction(mountCacheEntry, this.val$cmd);
            unmountAction.unmount();
            FsMgr.getFsMgr().getClientComm().waitOff();
        }

        /* synthetic */ 1(String string) {
            this.val$cmd = string;
        }
    }

    private static final class 2
    extends Thread {
        private final /* synthetic */ MountActionsListener this$0;
        private final /* synthetic */ String val$cmd;

        public void run() {
            ProgressPanel progressPanel;
            block15: {
                FsMgr.getFsMgr().getClientComm().waitOn();
                MountListView mountListView = Mount.getInstance().getContentPanel().getCurrentView();
                MountCacheEntry mountCacheEntry = (MountCacheEntry)mountListView.getSelectedItem();
                if (mountCacheEntry == null) {
                    return;
                }
                String string = FsMgrResourceStrings.getString("PerformingMountTitle");
                String string2 = FsMgrResourceStrings.getString("PerformingMountMessage");
                Object[] objectArray = new Object[]{mountCacheEntry.getResource()};
                String string3 = MessageFormat.format(string2, objectArray);
                progressPanel = new ProgressPanel(FsMgr.getFsMgr().getFrame(), 1, 30, false, false);
                progressPanel.setTitle(string);
                progressPanel.setText(string3);
                ((Component)progressPanel).setVisible(true);
                progressPanel.show();
                try {
                    if (this.val$cmd.equals(MountActionsListener.MOUNT_NOW)) {
                        FsMgrMountData fsMgrMountData = mountCacheEntry.getBootData();
                        if (fsMgrMountData.isSpecial()) {
                            return;
                        }
                        if (fsMgrMountData.getFsType().equals(FsMgrMountData.NFS)) {
                            fsMgrMountData = (FsMgrMountData)fsMgrMountData.clone();
                            try {
                                fsMgrMountData.setOption(FsMgrMountData.RETRY, 0);
                                fsMgrMountData.setOption(FsMgrMountData.FG, true);
                            }
                            catch (FsMgrMountDataException fsMgrMountDataException) {
                                AdminCommonTools.CMN_HandleOutput("Invalid option!");
                            }
                        }
                        FsMgrMount fsMgrMount = fsMgrMountData.toFsMgrMount();
                        FsMgrClient fsMgrClient = FsMgrClient.instance();
                        fsMgrClient.addMount(fsMgrMount, FsMgrMountData.MOUNTTAB_ARRAY);
                        this.this$0.refresh(fsMgrMount.getResource(), fsMgrMount.getMountPoint());
                        break block15;
                    }
                    if (this.val$cmd.equals(MountActionsListener.MOUNT_BOOT)) {
                        String string4 = mountCacheEntry.getTable(MountCacheEntry.ATBOOT);
                        FsMgrMountData fsMgrMountData = mountCacheEntry.getBootData();
                        if (fsMgrMountData == null) {
                            fsMgrMountData = mountCacheEntry.getNowData();
                        }
                        if (fsMgrMountData.isSpecial()) {
                            return;
                        }
                        FsMgrMount fsMgrMount = fsMgrMountData.toFsMgrMount();
                        fsMgrMount.setBootMount(FsMgrMountData.YES);
                        FsMgrClient fsMgrClient = FsMgrClient.instance();
                        if (mountCacheEntry.getBootData() != null) {
                            FsMgrMount fsMgrMount2 = mountCacheEntry.getBootData().toFsMgrMount();
                            fsMgrClient.modifyMount(fsMgrMount2, fsMgrMount, string4);
                        } else {
                            fsMgrClient.addMount(fsMgrMount, string4);
                        }
                        this.this$0.refresh(fsMgrMount.getResource(), fsMgrMount.getMountPoint());
                    }
                }
                catch (FsMgrException fsMgrException) {
                    new ErrorDialog(FsMgr.getFsMgr().getFrame(), fsMgrException.getLocalizedMessage());
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(1500L);
            }
            catch (Exception exception) {}
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            FsMgr.getFsMgr().getClientComm().waitOff();
        }

        /* synthetic */ 2(String string, MountActionsListener mountActionsListener) {
            this.val$cmd = string;
            this.this$0 = mountActionsListener;
        }
    }

    private final class 3
    extends Thread {
        public void run() {
            FsMgr.getFsMgr().getClientComm().waitOn();
            MountListView mountListView = Mount.getInstance().getContentPanel().getCurrentView();
            MountCacheEntry mountCacheEntry = (MountCacheEntry)mountListView.getSelectedItem();
            if (mountCacheEntry == null) {
                return;
            }
            DeleteAction deleteAction = new DeleteAction(mountCacheEntry);
            deleteAction.delete();
            FsMgr.getFsMgr().getClientComm().waitOff();
        }

        /* synthetic */ 3() {
        }
    }
}

