/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.logging;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.server.AdminFactoryImpl;
import com.sun.admin.cis.server.AdminServerImpl;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.logging.AdminLogException;
import com.sun.admin.cis.service.logging.Buffer;
import com.sun.admin.cis.service.logging.CorruptDataException;
import com.sun.admin.cis.service.logging.DataRecord;
import com.sun.admin.cis.service.logging.DataStore;
import com.sun.admin.cis.service.logging.FilterThread;
import com.sun.admin.cis.service.logging.InvalidRecordException;
import com.sun.admin.cis.service.logging.LogFileNotFoundException;
import com.sun.admin.cis.service.logging.LogFilter;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogRecordNotFoundException;
import com.sun.admin.cis.service.logging.LogServiceFactory;
import com.sun.admin.cis.service.logging.ReadThread;
import com.sun.admin.cis.service.security.SecurityToken;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LogServiceFactoryImpl
extends AdminFactoryImpl
implements LogServiceFactory {
    private Hashtable logFilesHash = new Hashtable();
    private DataStore storage;
    private AdminServerImpl admin_server;
    private long fileSize;
    private int numOfLogFiles;
    private String dirName = "";
    private String fileName = "";
    private String logFileName = "";
    private long currentFileSize;
    private String currentViewerFileName = "";
    private boolean serverSyslogSwitch = true;
    private static final String[] rights = new String[]{"solaris.admin.logsvc.write", "solaris.admin.logsvc.purge"};
    public static final String LOGSVC_APPNAME = "Log Viewer";

    public LogServiceFactoryImpl(AdminServerImpl adminServerImpl) throws RemoteException, AdminException {
        super(adminServerImpl);
        File file;
        this.admin_server = adminServerImpl;
        this.setSingleton();
        super.setAppName(LOGSVC_APPNAME);
        this.dirName = adminServerImpl.getServerProperty("admin.logging.file.dir");
        if (this.dirName == null) {
            this.dirName = "/var/opt/SUNWseam/3_0/log";
        }
        this.fileName = adminServerImpl.getServerProperty("admin.logging.file.name");
        if (this.fileName == null) {
            this.fileName = "admswt_log";
        }
        if (!(file = new File(this.dirName)).exists() && !file.mkdirs()) {
            throw new LogFileNotFoundException("EXLOG_DIR", this.dirName);
        }
        this.logFileName = String.valueOf(this.dirName) + File.separator + this.fileName;
        String string = adminServerImpl.getServerProperty("admin.logging.file.size");
        this.fileSize = string == null ? 5L : Long.parseLong(string);
        this.fileSize = this.fileSize * 1024L * 1024L;
        string = null;
        string = adminServerImpl.getServerProperty("admin.logging.file.num");
        this.numOfLogFiles = string == null ? 5 : Integer.parseInt(string);
        this.initHash();
        String string2 = adminServerImpl.getServerProperty("admin.logging.syslog");
        if (string2 == null) {
            string2 = "on";
        }
        if (string2.equalsIgnoreCase("on")) {
            this.serverSyslogSwitch = true;
            return;
        }
        this.serverSyslogSwitch = false;
    }

    public synchronized void writeRecord(LogRecord logRecord, boolean bl) throws AdminLogException {
        try {
            this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
        }
        catch (InvalidRecordException invalidRecordException) {
            AdminCommonTools.CMN_Trace1("Log service: error writing record: " + invalidRecordException.getMessage());
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
        if (this.currentFileSize < 0L) {
            try {
                this.synchronizedClearLog(this.currentViewerFileName);
            }
            catch (AdminLogException adminLogException) {
                throw new AdminLogException("EXLOG_WR", this.logFileName);
            }
            try {
                this.currentFileSize = this.storage.writeRecord(logRecord.formatRecord(), this.fileSize);
            }
            catch (InvalidRecordException invalidRecordException) {
                AdminCommonTools.CMN_Trace1("Log service: error writing record: " + invalidRecordException.getMessage());
            }
            catch (IOException iOException) {
                throw new AdminLogException("EXLOG_IO", this.logFileName);
            }
        }
        if (this.currentFileSize == this.fileSize) {
            try {
                this.synchronizedClearLog(this.currentViewerFileName);
            }
            catch (AdminLogException adminLogException) {
                throw new AdminLogException("EXLOG_WR", this.logFileName);
            }
        }
        if (bl && this.serverSyslogSwitch) {
            int n;
            String string = logRecord.getDetailedMesg(true);
            if (string == null) {
                string = logRecord.getSummaryMesg(true);
            }
            if ((n = logRecord.getSeverity()) == -1) {
                n = 0;
            }
            try {
                AdminServerLibrary.writeToSyslog(string, "AdminSuite", n);
                return;
            }
            catch (AdminException adminException) {
                return;
            }
        }
    }

    public LogRecord readRecord(SecurityToken securityToken, long l, int n, String string) throws RemoteException, AdminLogException {
        try {
            this.admin_server.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_Trace1("Log service: verify error in readRecord");
            throw new AdminLogException("EXLOG_VERF");
        }
        return this.synchronizedReadRecord(l, n, string);
    }

    public long getNumRecords(SecurityToken securityToken, String string) throws RemoteException, AdminLogException {
        try {
            this.admin_server.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            throw new AdminLogException("EXLOG_VERF");
        }
        return this.synchronizedGetNumRecords(string);
    }

    public Vector getList(SecurityToken securityToken, int n, LogFilter logFilter, long l, String string) throws RemoteException, LogFileNotFoundException, AdminLogException {
        try {
            this.admin_server.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            throw new AdminLogException("EXLOG_VERF");
        }
        if (logFilter.getScopeFilter() == 0) {
            AdminMgmtScope adminMgmtScope = null;
            try {
                adminMgmtScope = this.admin_server.getMgmtScope(securityToken);
            }
            catch (Exception exception) {
                logFilter.setScopeFilter(1);
            }
            if (adminMgmtScope != null) {
                logFilter.setScope(adminMgmtScope.toDirectoryTableURL());
            }
        }
        return this.synchronizedGetList(n, logFilter, l, string);
    }

    public void clearLog(SecurityToken securityToken, String string) throws RemoteException, AdminLogException, AdminException {
        Object object;
        try {
            object = new Object[]{string};
            this.admin_server.checkVerifier(securityToken, (Object[])object);
        }
        catch (AdminException adminException) {
            throw new AdminLogException("EXLOG_VERF");
        }
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if (!this.admin_server.checkRights(securityToken, "solaris.admin.logsvc.purge")) {
            object = new LogRecord();
            ((LogRecord)object).setBasicLogInfo("LM_LOGSVC_APP_NAME", 0, 1, this.admin_server.getUserName(securityToken), this.admin_server.getClientHost(securityToken), this.admin_server.getHostName(), "LM_1402", this.admin_server.getMgmtScope(securityToken));
            ((LogRecord)object).setDetailedMesgId("LM_1403");
            ((LogRecord)object).addSubstArg(this.admin_server.getUserName(securityToken), this.admin_server.getClientHost(securityToken), string);
            ((LogRecord)object).addData("LM_LABEL_LOG_FILE_NAME", this.logFileName);
            try {
                this.writeRecord((LogRecord)object, false);
            }
            catch (Exception exception) {}
            throw new AdminLogException("EXLOG_AUTH", this.admin_server.getUserName(securityToken));
        }
        this.synchronizedClearLog(string);
    }

    public String[] listLogFiles(SecurityToken securityToken) throws RemoteException, AdminLogException {
        try {
            this.admin_server.checkVerifier(securityToken, null);
        }
        catch (AdminException adminException) {
            throw new AdminLogException("EXLOG_VERF");
        }
        return this.synchronizedListLogFiles();
    }

    public String getCurrentLogFileName(SecurityToken securityToken) throws RemoteException {
        return this.synchronizedGetCurrentLogFileName();
    }

    public int getNumLogFiles(SecurityToken securityToken) throws RemoteException {
        return this.synchronizedGetNumLogFiles();
    }

    public int getLogFileSize(SecurityToken securityToken) throws RemoteException {
        return this.synchronizedGetLogFileSize();
    }

    public String getSyslogSwitch(SecurityToken securityToken) throws RemoteException {
        return this.synchronizedGetSyslogSwitch();
    }

    public String getLogStorageName(SecurityToken securityToken) throws RemoteException {
        return this.synchronizedGetLogStorageName();
    }

    public String getLogFileDir(SecurityToken securityToken) throws RemoteException {
        return this.synchronizedGetLogFileDir();
    }

    public void setProperties(SecurityToken securityToken, int n, int n2, String string, String string2) throws RemoteException, AdminLogException, AdminException {
        Object object;
        try {
            object = new Object[]{new Integer(n), new Integer(n2), string, string2};
            this.admin_server.checkVerifier(securityToken, (Object[])object);
        }
        catch (AdminException adminException) {
            throw new AdminLogException("EXLOG_VERF");
        }
        if (!this.admin_server.checkRights(securityToken, "solaris.admin.logsvc.write")) {
            object = new LogRecord();
            ((LogRecord)object).setBasicLogInfo("LM_LOGSVC_APP_NAME", 0, 1, this.admin_server.getUserName(securityToken), this.admin_server.getClientHost(securityToken), this.admin_server.getHostName(), "LM_1404", this.admin_server.getMgmtScope(securityToken));
            ((LogRecord)object).setDetailedMesgId("LM_1405");
            ((LogRecord)object).addSubstArg(this.admin_server.getUserName(securityToken), this.admin_server.getClientHost(securityToken));
            try {
                this.writeRecord((LogRecord)object, false);
            }
            catch (Exception exception) {}
            throw new AdminLogException("EXLOG_AUTH", this.admin_server.getUserName(securityToken));
        }
        this.synchronizedSetProperties(n, n2, string, string2);
    }

    private synchronized void do_cascaded_backup() throws AdminLogException {
        File file;
        File file2;
        int n = 0;
        Enumeration enumeration = this.logFilesHash.elements();
        while (enumeration.hasMoreElements()) {
            DataStore dataStore;
            Vector vector = (Vector)enumeration.nextElement();
            if (vector == null || (dataStore = (DataStore)vector.elementAt(1)) == null) continue;
            dataStore.close();
        }
        n = this.numOfLogFiles;
        while (n > 1) {
            file2 = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n));
            file = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n - 1));
            try {
                if (file.exists()) {
                    file.renameTo(file2);
                }
            }
            catch (SecurityException securityException) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
            --n;
        }
        file2 = new File(this.logFileName);
        file = new File(String.valueOf(this.logFileName) + ".1");
        try {
            if (file2.exists()) {
                file2.renameTo(file);
            }
        }
        catch (SecurityException securityException) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        this.initHash();
    }

    private void initHash() throws AdminLogException {
        Object object;
        Vector<Object> vector = new Vector<Object>();
        this.logFilesHash.clear();
        try {
            this.storage = new DataStore(this.logFileName);
        }
        catch (EOFException eOFException) {
            AdminCommonTools.CMN_Trace1("Log service: end of file reached!! - corrupted!");
            object = new File(this.logFileName);
            try {
                if (((File)object).exists()) {
                    ((File)object).renameTo(new File(String.valueOf(this.logFileName) + ".corrupted"));
                }
                this.storage = new DataStore(this.logFileName);
            }
            catch (Exception exception) {
                throw new AdminLogException("EXLOG_FPM", this.dirName);
            }
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", this.logFileName);
        }
        long l = this.storage.getFileDate();
        if (l <= 0L) {
            object = new File(this.logFileName);
            try {
                if (((File)object).exists()) {
                    ((File)object).renameTo(new File(String.valueOf(this.logFileName) + ".corrupted"));
                }
                this.storage = new DataStore(this.logFileName);
            }
            catch (Exception exception) {}
            throw new AdminLogException("EXLOG_COR", this.logFileName);
        }
        object = String.valueOf(l);
        vector.addElement(this.logFileName);
        vector.addElement(this.storage);
        this.currentViewerFileName = "Log." + (String)object;
        this.logFilesHash.put(this.currentViewerFileName, vector.clone());
        vector.removeAllElements();
        int n = 0;
        DataStore dataStore = null;
        n = 1;
        while (n <= this.numOfLogFiles) {
            block23: {
                block22: {
                    File file = new File(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                    try {
                        if (file.exists()) {
                            try {
                                dataStore = new DataStore(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                            }
                            catch (EOFException eOFException) {
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    catch (Exception exception) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    if (dataStore == null) break block22;
                    l = dataStore.getFileDate();
                    if (l <= 0L) break block23;
                    object = String.valueOf(l);
                    vector.addElement(String.valueOf(this.logFileName) + "." + String.valueOf(n));
                    vector.addElement(dataStore);
                    this.logFilesHash.put("Log." + (String)object, vector.clone());
                }
                dataStore = null;
                vector.removeAllElements();
            }
            ++n;
        }
    }

    private synchronized LogRecord synchronizedReadRecord(long l, int n, String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        DataRecord dataRecord = null;
        Vector vector = (Vector)this.logFilesHash.get(string);
        if (vector == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        try {
            dataRecord = dataStore.readSpecificRecordAsStr(l, n);
        }
        catch (InvalidRecordException invalidRecordException) {
            AdminCommonTools.CMN_Trace1("Log service: error reading record: " + invalidRecordException.getMessage());
            throw new LogRecordNotFoundException(invalidRecordException.getMessage());
        }
        catch (EOFException eOFException) {
            AdminCommonTools.CMN_Trace1("Log service: eof reached reading record: " + eOFException.getMessage());
            throw new CorruptDataException(eOFException.getMessage());
        }
        catch (IOException iOException) {
            throw new AdminLogException("EXLOG_IO", string);
        }
        if (dataRecord == null) {
            throw new CorruptDataException("EXLOG_DAT");
        }
        LogRecord logRecord = (LogRecord)dataRecord.getRecord();
        logRecord.setRecordId(dataRecord.getOffset());
        logRecord.setHashCode(dataRecord.getHash());
        return logRecord;
    }

    private synchronized Vector synchronizedGetList(int n, LogFilter logFilter, long l, String string) throws LogFileNotFoundException, AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        Buffer buffer = new Buffer();
        FilterThread filterThread = new FilterThread(buffer, logFilter, n);
        ReadThread readThread = new ReadThread(buffer, l, n, logFilter.getDirection(), dataStore);
        Thread thread = new Thread(filterThread);
        Thread thread2 = new Thread(readThread);
        thread2.start();
        thread.start();
        try {
            thread2.join();
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
        AdminLogException adminLogException = buffer.getException();
        if (adminLogException != null) {
            throw adminLogException;
        }
        return buffer.getVect();
    }

    private synchronized long synchronizedGetNumRecords(String string) throws AdminLogException {
        Vector vector;
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if ((vector = (Vector)this.logFilesHash.get(string)) == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        DataStore dataStore = (DataStore)vector.elementAt(1);
        if (dataStore == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        File file = new File(string2);
        try {
            if (!file.exists()) {
                throw new LogFileNotFoundException("EXLOG_DEL", string);
            }
        }
        catch (Exception exception) {
            throw new AdminLogException("EXLOG_FPM", this.dirName);
        }
        return dataStore.getNumRecords();
    }

    private synchronized void synchronizedClearLog(String string) throws AdminLogException {
        if (string == null) {
            string = this.currentViewerFileName;
        }
        if (!this.logFilesHash.containsKey(string)) {
            throw new LogFileNotFoundException("EXLOG_FNF", string);
        }
        Vector vector = (Vector)this.logFilesHash.get(string);
        String string2 = (String)vector.elementAt(0);
        if (string2 == null) {
            throw new AdminLogException("EXLOG_ACT", (Object)string2, string);
        }
        if (string2.compareTo(this.logFileName) == 0) {
            this.do_cascaded_backup();
            return;
        }
        try {
            File file = new File(string2);
            if (file.exists()) {
                vector = (Vector)this.logFilesHash.get(string);
                if (vector == null) {
                    throw new LogFileNotFoundException("EXLOG_FNF", string);
                }
                DataStore dataStore = (DataStore)vector.elementAt(1);
                if (dataStore != null) {
                    dataStore.close();
                }
                this.logFilesHash.remove(string);
                file.delete();
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    private synchronized String[] synchronizedListLogFiles() {
        String[] stringArray = new String[this.logFilesHash.size()];
        Enumeration enumeration = this.logFilesHash.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    private String synchronizedGetCurrentLogFileName() {
        return this.currentViewerFileName;
    }

    private int synchronizedGetNumLogFiles() {
        return this.numOfLogFiles;
    }

    private int synchronizedGetLogFileSize() {
        return (int)(this.fileSize / 0x100000L);
    }

    private String synchronizedGetSyslogSwitch() {
        if (this.serverSyslogSwitch) {
            return "on";
        }
        return "off";
    }

    private String synchronizedGetLogStorageName() {
        return this.fileName;
    }

    private String synchronizedGetLogFileDir() {
        return this.dirName;
    }

    /*
     * Unable to fully structure code
     */
    private void synchronizedSetProperties(int var1_1, int var2_2, String var3_3, String var4_4) throws AdminLogException {
        var5_5 = false;
        if (var3_3 == null) {
            var3_3 = "on";
        } else if (var3_3.equalsIgnoreCase("on")) {
            this.serverSyslogSwitch = true;
        } else if (var3_3.equalsIgnoreCase("off")) {
            this.serverSyslogSwitch = false;
        } else {
            var3_3 = "on";
        }
        if (var4_4 != null) {
            var6_6 = new File(var4_4);
            if (!var6_6.exists() && !var6_6.mkdirs()) {
                var5_5 = true;
            }
            if (var6_6.isDirectory()) {
                var9_7 = this.logFilesHash.elements();
                while (var9_7.hasMoreElements()) {
                    var7_8 = (Vector)var9_7.nextElement();
                    if (var7_8 == null || (var8_9 = (DataStore)var7_8.elementAt(1)) == null) continue;
                    var8_9.close();
                }
                var10_10 = 1;
                while (var10_10 <= this.numOfLogFiles) {
                    var11_11 = String.valueOf(var4_4) + File.separator + this.fileName;
                    var12_12 = this.logFileName;
                    var13_13 = new File(String.valueOf(var11_11) + "." + String.valueOf(var10_10));
                    var14_14 = new File(String.valueOf(var12_12) + "." + String.valueOf(var10_10));
                    try {
                        if (var14_14.exists() && !var14_14.renameTo(var13_13) && !this.do_copy(var14_14, var13_13)) {
                            this.flush_dir((String)var11_11, var10_10);
                            var5_5 = true;
                        }
                    }
                    catch (SecurityException v0) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                    ++var10_10;
                }
                if (!var5_5) {
                    var11_11 = new File(this.logFileName);
                    var12_12 = String.valueOf(var4_4) + File.separator + this.fileName;
                    var13_13 = new File(var12_12);
                    try {
                        if (!var11_11.exists()) ** GOTO lbl60
                        if (!var11_11.renameTo(var13_13)) {
                            if (!this.do_copy((File)var11_11, var13_13)) {
                                this.flush_dir(var12_12, 0);
                                var5_5 = true;
                            }
                            this.flush_dir(this.logFileName, -1);
                            this.logFileName = String.valueOf(var4_4) + File.separator + this.fileName;
                            this.dirName = var4_4;
                        }
                        this.logFileName = String.valueOf(var4_4) + File.separator + this.fileName;
                        this.dirName = var4_4;
                    }
                    catch (SecurityException v1) {
                        throw new AdminLogException("EXLOG_FPM", this.dirName);
                    }
                }
            } else {
                var5_5 = true;
            }
        }
lbl60:
        // 8 sources

        if (var1_1 > 0) {
            this.fileSize = var1_1 * 1024 * 1024;
        }
        if (var2_2 > 0) {
            this.numOfLogFiles = var2_2;
        }
        if (var4_4 != null) {
            this.initHash();
        }
        try {
            if (var1_1 > 0) {
                this.admin_server.setServerProperty("admin.logging.file.size", String.valueOf(var1_1));
            }
            this.admin_server.setServerProperty("admin.logging.file.num", String.valueOf(this.numOfLogFiles));
            this.admin_server.setServerProperty("admin.logging.syslog", var3_3);
            this.admin_server.setServerProperty("admin.logging.file.dir", this.dirName);
            this.admin_server.saveServerProperties();
        }
        catch (AdminException v2) {
            throw new AdminLogException("EXLOG_PROP");
        }
        if (var5_5) {
            throw new AdminLogException("EXLOG_PROP_DIR", (Object)this.dirName, var4_4);
        }
    }

    private boolean do_copy(File file, File file2) {
        BufferedInputStream bufferedInputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        byte[] byArray = new byte[8192];
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file), 8192);
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        }
        catch (Exception exception) {
            return false;
        }
        try {
            int n;
            while ((n = bufferedInputStream.read(byArray, 0, 8192)) >= 0) {
                bufferedOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void flush_dir(String string, int n) {
        File file = null;
        int n2 = 0;
        int n3 = this.numOfLogFiles;
        if (n == -1) {
            file = new File(string);
        } else if (n == 0) {
            file = new File(String.valueOf(string) + "." + String.valueOf(1));
        } else {
            file = new File(String.valueOf(string) + "." + String.valueOf(1));
            n3 = n - 1;
        }
        while (n2 <= n3) {
            try {
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {}
            file = new File(String.valueOf(string) + "." + String.valueOf(++n2));
        }
    }

    protected String[] myAuthRights() {
        return rights;
    }
}

