/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.service.directorytable.DirectoryFilter;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableInvalidParameterException;
import com.sun.admin.cis.service.directorytable.TableDefinitions;

public class DirectoryTableFactory {
    public static DirectoryTable getDirectoryTableInstance(String string) throws DirectoryTableException {
        int n = 0;
        n = string.indexOf(":/");
        if (n == -1 || n < 2) {
            throw new DirectoryTableInvalidParameterException("EXM_INVALID");
        }
        String string2 = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, n).toLowerCase();
        String string3 = string.length() > n + 2 ? string.substring(n + 2) : "";
        String string4 = "com.sun.admin.cis.service.directorytable." + string2 + "DirectoryTable";
        try {
            DirectoryTable directoryTable = (DirectoryTable)Class.forName(string4).newInstance();
            if (directoryTable != null) {
                directoryTable.setContext(string3);
            }
            return directoryTable;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", string2);
        }
        catch (InstantiationException instantiationException) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DirectoryTableInvalidParameterException("EXM_NODIRECTORY", string2);
        }
    }

    public static DirectoryTable getDirectoryTableInstance(String string, String string2, String string3) {
        try {
            return DirectoryTableFactory.getDirectoryTableInstance(String.valueOf(string) + ":/" + string3 + "/" + string2);
        }
        catch (DirectoryTableException directoryTableException) {
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            System.out.println("Instantiate a table object for a given nameservice");
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance("File", "", "");
            System.out.println("Open the networks table");
            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions("networks");
            try {
                directoryTable.open(tableDefinitions);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                directoryTable.create(tableDefinitions);
            }
            System.out.println("Build a new row to add");
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(tableDefinitions.getColumnNumber("cname"), "network1");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("addr"), "100.100.100");
            System.out.println("Add the new row we built");
            directoryTable.addRow(directoryRow);
            System.out.println("Now delete the row we added before");
            directoryTable.deleteRow(directoryRow);
            System.out.println("Build a different new row to add");
            directoryRow = directoryTable.getRowInstance();
            directoryRow.putColumn(tableDefinitions.getColumnNumber("cname"), "network2");
            directoryRow.putColumn(tableDefinitions.getColumnNumber("addr"), "100.100.200");
            System.out.println("Add the new row we built");
            directoryTable.addRow(directoryRow);
            System.out.println("Build a modify template");
            DirectoryRow directoryRow2 = directoryTable.getRowInstance();
            directoryRow2.putColumn(tableDefinitions.getColumnNumber("cname"), "network2");
            directoryRow2.putColumn(tableDefinitions.getColumnNumber("addr"), "100.100.201");
            directoryRow2.putColumn(tableDefinitions.getColumnNumber("comment"), "my network");
            System.out.println("Modify the last row we added");
            directoryTable.modifyRow(directoryRow, directoryRow2);
            System.out.println("Now enumerate all the filtered rows with getFirst/getNext");
            DirectoryFilter directoryFilter = new DirectoryFilter(4);
            directoryFilter.add(tableDefinitions.getColumnNumber("cname"), 1, 1, "net");
            directoryFilter.add(tableDefinitions.getColumnNumber("cname"), 2, 2, "arpa");
            directoryFilter.add(tableDefinitions.getColumnNumber("addr"), 3, 8, "192.9.150");
            directoryFilter.add(tableDefinitions.getColumnNumber("addr"), 2, 7, "190.9.250");
            DirectoryRow directoryRow3 = directoryTable.getFirstRow(directoryFilter);
            int n2 = 0;
            while (directoryRow3 != null) {
                System.out.print("Row " + n2 + ": ");
                n = 1;
                while (n <= directoryRow3.getNumberOfColumns()) {
                    System.out.print(String.valueOf(tableDefinitions.getColumnName(n)) + "=" + directoryRow3.getColumn(n) + " ");
                    ++n;
                }
                System.out.println("");
                directoryRow3 = directoryTable.getNextRow(directoryFilter);
                ++n2;
            }
            System.out.println("Now delete the row we modified");
            directoryTable.deleteRow(directoryRow2);
            System.out.println("Now enumerate all the rows using getAll() sorted by cname");
            directoryRow3 = directoryTable.getAll();
            if (directoryRow3 != null) {
                directoryRow3.sortByColumn(tableDefinitions.getColumnNumber("cname"), tableDefinitions);
                n = 1;
                while (n <= directoryRow3.getNumberOfRows()) {
                    System.out.print("Row " + n + ": ");
                    int n3 = 1;
                    while (n3 <= directoryRow3.getNumberOfColumns()) {
                        System.out.print(String.valueOf(tableDefinitions.getColumnName(n3)) + "=" + directoryRow3.getColumn(n3, n) + " ");
                        ++n3;
                    }
                    System.out.println("");
                    ++n;
                }
            }
            System.out.println("Close the table");
            directoryTable.close();
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            System.out.println(directoryTableException.getMessage());
            return;
        }
    }
}

