/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.authorization;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.service.authorization.AuthAttrObj;
import com.sun.admin.cis.service.authorization.AuthServiceImpl;
import com.sun.admin.cis.service.authorization.AuthorizationException;
import com.sun.admin.cis.service.authorization.CheckUser;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotFoundException;
import com.sun.admin.cis.service.directorytable.DirectoryTableSetup;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import java.net.InetAddress;
import java.util.Vector;

public class AuthSetup {
    private static final String ROOT_USERNAME = "root";
    private static final String pswd_table = "shadow";
    private static final String namecol = "name";
    private static final String pswdcol = "passwd";
    private String host_name;
    private AdminMgmtScope scope;
    private String scope_type;
    private String scope_url;
    private DirectoryTable pwt;
    private AuthServiceImpl asvc;

    public AuthSetup(AdminMgmtScope adminMgmtScope) throws AdminException {
        this.scope = adminMgmtScope;
        try {
            this.host_name = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SET1", exception);
        }
        if (!this.host_name.equals(this.scope.getMgmtServerName())) {
            throw new AuthorizationException("EXAS_SET2", (Object)this.scope.getMgmtServerName(), this.host_name);
        }
        this.scope_type = this.scope.getMgmtScopeType();
        this.scope_url = this.scope.toDirectoryTableURL();
        try {
            this.pwt = DirectoryTableFactory.getDirectoryTableInstance(this.scope_url);
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SET3", exception);
        }
        this.asvc = new AuthServiceImpl(this.scope);
    }

    public void setupData(String string) throws AdminException {
        AuthAttrObj[] authAttrObjArray = this.asvc.parseAuthPropertyFile(string);
        this.asvc.createAuthAttrTable();
        this.asvc.createUserAttrTable();
        this.asvc.addAuthorizations(authAttrObjArray);
        if (this.scope_type.equals("file")) {
            this.asvc.addPrimaryAdmin(ROOT_USERNAME);
        }
    }

    public void setupAdmin(String string) throws AdminException {
        TableDefinitions tableDefinitions = null;
        DirectoryRow directoryRow = null;
        if (!CheckUser.checkUser(string)) {
            throw new AuthorizationException("EXAS_SET5", (Object)string, this.scope_url);
        }
        if (!this.scope_type.equals("file") && !this.scope_type.equals("dns")) {
            try {
                this.pwt.open(pswd_table);
                tableDefinitions = this.pwt.getCurrentTableDefinitions();
                directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            }
            catch (Exception exception) {
                throw new AuthorizationException("EXAS_SET4", (Object)pswd_table, exception);
            }
            try {
                directoryRow.putColumn(tableDefinitions.getColumnNumber(namecol), string);
                directoryRow = this.pwt.getFirstRow(directoryRow);
            }
            catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
                directoryRow = null;
            }
            catch (DirectoryTableException directoryTableException) {
                directoryRow = null;
            }
            catch (Exception exception) {
                throw new AuthorizationException("EXAS_SET13", (Object)this.scope_url, exception);
            }
            if (directoryRow != null) {
                String string2 = null;
                try {
                    string2 = directoryRow.getColumn(tableDefinitions.getColumnNumber(pswdcol));
                }
                catch (DirectoryTableException directoryTableException) {
                    string2 = null;
                }
                catch (Exception exception) {
                    throw new AuthorizationException("EXAS_SET13", (Object)this.scope_url, exception);
                }
                if (string2 == null || string2.trim().length() == 0) {
                    directoryRow = null;
                }
            }
            if (directoryRow == null) {
                throw new AuthorizationException("EXAS_SET5", (Object)string, this.scope_url);
            }
        }
        this.asvc.addPrimaryAdmin(string);
    }

    public static void main(String[] stringArray) {
        AuthorizationException authorizationException;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length >= 2) {
            string3 = stringArray[0];
            string = stringArray[1];
        } else {
            authorizationException = new AuthorizationException("EXAS_SET6");
            System.out.println(authorizationException.getLocalizedMessage());
            System.exit(1);
        }
        if (stringArray.length >= 3) {
            string2 = stringArray[2];
        }
        DirectoryTableSetup directoryTableSetup = null;
        if (!(string.equals("file") || string.equals("nis") || string.equals("nisplus") || string.equals("all"))) {
            authorizationException = new AuthorizationException("EXAS_SET7", string);
            System.out.println(authorizationException.getLocalizedMessage());
            System.exit(1);
        }
        Vector vector = null;
        directoryTableSetup = new DirectoryTableSetup();
        try {
            vector = string.equals("all") ? directoryTableSetup.getScopes(2) : directoryTableSetup.getScopes(string, 2);
        }
        catch (Exception exception) {
            vector = null;
        }
        if (vector == null || vector.size() == 0) {
            authorizationException = new AuthorizationException("EXAS_SET8");
            System.out.println(authorizationException.getLocalizedMessage());
            System.exit(1);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            block21: {
                String string4 = (String)vector.elementAt(n2);
                AdminMgmtScope adminMgmtScope = null;
                String string5 = "scope" + n2;
                try {
                    adminMgmtScope = new AdminMgmtScope(string5, string4);
                }
                catch (Exception exception) {
                    authorizationException = new AuthorizationException("EXAS_SET9", string4);
                    System.out.println(authorizationException.getLocalizedMessage());
                    System.out.println(exception.getLocalizedMessage());
                    n = 1;
                    break block21;
                }
                String string6 = adminMgmtScope.getMgmtScopeType();
                if (!string6.equals("dns")) {
                    Exception exception;
                    AuthSetup authSetup = null;
                    try {
                        authSetup = new AuthSetup(adminMgmtScope);
                    }
                    catch (AdminException adminException) {
                        authorizationException = new AuthorizationException("EXAS_SET10", string4);
                        System.out.println(authorizationException.getLocalizedMessage());
                        System.out.println(adminException.getLocalizedMessage());
                        if (adminException.isImbeddedException()) {
                            exception = adminException.getImbeddedException();
                            System.out.println(exception.getLocalizedMessage());
                        }
                        n = 1;
                        break block21;
                    }
                    try {
                        authSetup.setupData(string3);
                    }
                    catch (AdminException adminException) {
                        authorizationException = new AuthorizationException("EXAS_SET11", string4);
                        System.out.println(authorizationException.getLocalizedMessage());
                        System.out.println(adminException.getLocalizedMessage());
                        if (adminException.isImbeddedException()) {
                            exception = adminException.getImbeddedException();
                            System.out.println(exception.getLocalizedMessage());
                        }
                        n = 1;
                        break block21;
                    }
                    authorizationException = new AuthorizationException("EXAS_SET12", string4);
                    System.out.println(authorizationException.getLocalizedMessage());
                    if (string2 != null) {
                        try {
                            authSetup.setupAdmin(string2);
                        }
                        catch (AdminException adminException) {
                            System.out.println(adminException.getLocalizedMessage());
                            if (adminException.isImbeddedException()) {
                                exception = adminException.getImbeddedException();
                                System.out.println(exception.getLocalizedMessage());
                            }
                            n = 1;
                            break block21;
                        }
                        authorizationException = new AuthorizationException("EXAS_SET14", (Object)string2, string4);
                        System.out.println(authorizationException.getLocalizedMessage());
                    }
                }
            }
            ++n2;
        }
        System.exit(n);
    }
}

