/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.authorization;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.AdminProps;
import com.sun.admin.cis.service.authorization.AuthAttrObj;
import com.sun.admin.cis.service.authorization.AuthorizationException;
import com.sun.admin.cis.service.authorization.SolarisAuthAttrTable;
import com.sun.admin.cis.service.authorization.SolarisUserAttrTable;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotFoundException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AuthServiceImpl {
    public static final String SUN_PREFIX = "solaris.";
    public static final String PRIMARY_RIGHT = "solaris.*";
    public static final String GRANT_RIGHT = "solaris.grant";
    public static final String ALL_SUFFIX = "*";
    public static final String GRANT_SUFFIX = "grant";
    public static final String AUTH_POLICY_LOCAL = "files";
    public static final String AUTH_POLICY_DOMAIN = "domain";
    public static final String AUTH_POLICY_DEFAULT = "files domain";
    private String scope;
    private SolarisAuthAttrTable aat;
    private SolarisUserAttrTable uat;

    public AuthServiceImpl(AdminMgmtScope adminMgmtScope) {
        this.scope = adminMgmtScope.toDirectoryTableURL();
        this.aat = new SolarisAuthAttrTable(this.scope);
        this.uat = new SolarisUserAttrTable(this.scope);
    }

    public boolean matchScope(AdminMgmtScope adminMgmtScope) {
        String string = adminMgmtScope.toDirectoryTableURL();
        return this.scope.equals(string);
    }

    public AuthAttrObj readAuthAttrObj(String string) throws AdminException {
        AuthAttrObj authAttrObj = null;
        try {
            authAttrObj = this.aat.readAuthAttrObj(string);
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC1", (Object)string, exception);
        }
        return authAttrObj;
    }

    public AuthAttrObj[] readAuthAttrObjList(String string) throws AdminException {
        AuthAttrObj[] authAttrObjArray = null;
        try {
            authAttrObjArray = this.aat.readAuthAttrObjList(string);
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC2", (Object)string, exception);
        }
        return authAttrObjArray;
    }

    public UserAttrObj readUserAttr(String string) throws AdminException {
        UserAttrObj userAttrObj = null;
        try {
            userAttrObj = this.uat.readUserAttr(string);
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC3", (Object)string, exception);
        }
        return userAttrObj;
    }

    public UserAttrObj readUserAttr(String string, String string2) throws AdminException {
        UserAttrObj userAttrObj = null;
        try {
            userAttrObj = this.uat.readUserAttr(string, string2);
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC3", (Object)string, exception);
        }
        return userAttrObj;
    }

    public void addPrimaryAdmin(String string) throws AdminException {
        UserAttrObj userAttrObj = null;
        try {
            userAttrObj = this.uat.readUserAttr(string);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            userAttrObj = null;
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC3", (Object)string, exception);
        }
        if (userAttrObj == null) {
            userAttrObj = new UserAttrObj(string);
        }
        String[] stringArray = userAttrObj.getAuthNames();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(PRIMARY_RIGHT)) {
                bl = true;
            }
            if (stringArray[n].equals(GRANT_RIGHT)) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl) {
            userAttrObj.addAuthNames(PRIMARY_RIGHT);
        }
        if (!bl2) {
            userAttrObj.addAuthNames(GRANT_RIGHT);
        }
        if (!(bl & bl2)) {
            try {
                this.uat.writeUserAttr(userAttrObj);
                return;
            }
            catch (DirectoryTableException directoryTableException) {
                throw new AuthorizationException("EXAS_SVC4", (Object)string, directoryTableException);
            }
        }
    }

    public void removePrimaryAdmin(String string) throws AdminException {
        UserAttrObj userAttrObj = null;
        try {
            userAttrObj = this.uat.readUserAttr(string);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            userAttrObj = null;
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC3", (Object)string, exception);
        }
        if (userAttrObj != null) {
            String[] stringArray = userAttrObj.getAuthNames();
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(PRIMARY_RIGHT)) {
                    bl = true;
                }
                if (stringArray[n].equals(GRANT_RIGHT)) {
                    bl2 = true;
                }
                ++n;
            }
            if (bl) {
                userAttrObj.delAuthNames(PRIMARY_RIGHT);
            }
            if (bl2) {
                userAttrObj.delAuthNames(GRANT_RIGHT);
            }
            if (bl | bl2) {
                try {
                    this.uat.writeUserAttr(userAttrObj);
                    return;
                }
                catch (DirectoryTableException directoryTableException) {
                    throw new AuthorizationException("EXAS_SVC4", (Object)string, directoryTableException);
                }
            }
        }
    }

    public boolean isPrimaryAdmin(String string) throws AdminException {
        UserAttrObj userAttrObj = null;
        try {
            userAttrObj = this.uat.readUserAttr(string);
        }
        catch (DirectoryTableRowNotFoundException directoryTableRowNotFoundException) {
            userAttrObj = null;
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC3", (Object)string, exception);
        }
        boolean bl = false;
        if (userAttrObj != null) {
            String[] stringArray = userAttrObj.getAuthNames();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(PRIMARY_RIGHT)) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public void addAuthorizations(AuthAttrObj[] authAttrObjArray) throws AdminException {
        if (authAttrObjArray != null) {
            int n = 0;
            try {
                n = 0;
                while (n < authAttrObjArray.length) {
                    this.aat.writeAuthAttrObj(authAttrObjArray[n]);
                    ++n;
                }
                return;
            }
            catch (Exception exception) {
                throw new AuthorizationException("EXAS_SVC5", (Object)authAttrObjArray[n].getAuthName(), exception);
            }
        }
    }

    public void createAuthAttrTable() throws AdminException {
        try {
            this.aat.createAuthAttrTable();
            return;
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC6", exception);
        }
    }

    public void createUserAttrTable() throws AdminException {
        try {
            this.uat.createUserAttrTable();
            return;
        }
        catch (Exception exception) {
            throw new AuthorizationException("EXAS_SVC7", exception);
        }
    }

    public AuthAttrObj[] parseAuthPropertyFile(String string) throws AdminException {
        AdminProps adminProps;
        AuthAttrObj[] authAttrObjArray = null;
        try {
            adminProps = new AdminProps(string, 0);
        }
        catch (AdminException adminException) {
            throw new AuthorizationException("EXAS_SVC8", (Object)string, adminException);
        }
        Vector vector = adminProps.getAdminPropNames();
        authAttrObjArray = new AuthAttrObj[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            String string2;
            String string3;
            String string4 = (String)vector.elementAt(n);
            String string5 = adminProps.getAdminProp(string4);
            if (string5 == null) {
                throw new AuthorizationException("EXAS_SVC9", string4);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ":");
            try {
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new AuthorizationException("EXAS_SVC9", string4);
            }
            AuthAttrObj authAttrObj = new AuthAttrObj(string4);
            authAttrObj.setShortDesc(string3);
            authAttrObj.setLongDescId(string2);
            authAttrObj.setLongDesc("");
            authAttrObjArray[n] = authAttrObj;
            ++n;
        }
        return authAttrObjArray;
    }
}

