/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminPropertyNotFoundException;
import com.sun.admin.cis.common.UnexpectedErrorException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class AdminProps {
    public static final String ADMIN_CLIENT_PROP_PATH = "admin.client.properties";
    public static final String ADMIN_CLIENT_PROP_FILE = "AdminClient.properties";
    public static final String ADMIN_SERVER_PROP_PATH = "admin.server.properties";
    public static final String ADMIN_SERVER_PROP_FILE = "AdminServer.properties";
    public static final String ADMIN_AGENT_PROP_PATH = "admin.agent.properties";
    public static final String ADMIN_AGENT_PROP_FILE = "AdminAgent.properties";
    public static final String ADMIN_CONF_PROP_FILE = "admin.conf";
    public static final int ADMIN_PROP_MODE_READ = 0;
    public static final int ADMIN_PROP_MODE_WRITE = 1;
    public static final int ADMIN_PROP_MODE_CREATE = 2;
    public static final String ADMIN_PROP_ON_VALUE = "on";
    public static final String ADMIN_PROP_OFF_VALUE = "off";
    public static final String ADMIN_PROP_BASE_DIR = "admin.base.dir";
    public static final String ADMIN_PROP_SERVER_NAME = "admin.server.name";
    public static final String ADMIN_PROP_SERVER_PORT = "admin.server.port";
    public static final String ADMIN_PROP_TRACE_LEVEL = "admin.trace.level";
    public static final String ADMIN_PROP_TRACE_DEVICE = "admin.trace.device";
    public static final String ADMIN_PROP_WIN_TEMPDIR = "admin.client.win.temp_dir";
    public static final String ADMIN_PROP_APP_CLASSNAME = "admin.app";
    public static final String ADMIN_PROP_SEC_AUTH_FLAVOR = "admin.security.auth.flavor";
    public static final String ADMIN_PROP_SEC_PROVIDER = "admin.security.provider";
    public static final String ADMIN_PROP_SEC_DIGEST = "admin.security.digest.algo";
    public static final String ADMIN_PROP_SEC_SIGN = "admin.security.sign.algo";
    public static final String ADMIN_PROP_SEC_KEYGEN = "admin.security.key.algo";
    public static final String ADMIN_PROP_SEC_KEYSTRENGTH = "admin.security.key.strength";
    public static final String ADMIN_PROP_SEC_MSG_VERIFY = "admin.security.msg.verify";
    public static final String ADMIN_PROP_SEC_MSG_INTEGRITY = "admin.security.msg.integrity";
    public static final String ADMIN_PROP_SEC_MSG_ENCRYPT = "admin.security.msg.encrypt";
    public static final String ADMIN_PROP_SERVER_HDR = "Management Server Properties - Do Not Edit";
    public static final String ADMIN_PROP_SERVICE_CLASSNAME = "admin.service";
    public static final String ADMIN_PROP_AUTH_POLICY = "admin.authorization.policy";
    public static final String LOG_SERVICE_FILE_DIR = "admin.logging.file.dir";
    public static final String LOG_SERVICE_FILE_NAME = "admin.logging.file.name";
    public static final String LOG_SERVICE_FILE_SIZE = "admin.logging.file.size";
    public static final String LOG_SERVICE_FILE_NUM = "admin.logging.file.num";
    public static final String LOG_SERVICE_SYSLOG = "admin.logging.syslog";
    public static final String DIRECTORY_TABLE_NIS_ISMASTER = "admin.directorytable.nis.ismaster";
    public static final String DIRECTORY_TABLE_NIS_PWDIR = "admin.directorytable.nis.pwdir";
    public static final String DIRECTORY_TABLE_NIS_ALIASES = "admin.directorytable.nis.aliases";
    public static final String DIRECTORY_TABLE_NIS_DIR = "admin.directorytable.nis.dir";
    public static final String DIRECTORY_TABLE_NIS_MAKEPATH = "admin.directorytable.nis.makepath";
    public static final String DIRECTORY_TABLE_NIS_MAKEFILE = "admin.directorytable.nis.makefile";
    public static final String DIRECTORY_TABLE_NIS_UPDATESCHEDULE = "admin.directorytable.nis.updateschedule";
    public static final String ADMIN_PROP_SERVER_DEFAULT = "admin.server.default";
    public static final String ADMIN_PROP_IMAGES_BADEDIR = "admin.images.basedir";
    public static final String ADMIN_PROP_CLIENT_WORKDIR = "admin.client.workdir";
    public static final String ADMIN_PROP_SCOPE_HDR = "Management Scopes - Do Not Edit";
    public static final String ADMIN_PROP_MGMT_SCOPE = "admin.scope";
    public static final String ADMIN_PROP_AGENT_RMI_PORT = "admin.agent.rmi.port";
    public static final String ADMIN_PROP_AGENT_HTML_PORT = "admin.agent.html.port";
    public static final String PDC_AGENT_NET_CLI_PATH = "admin.server.net_cli.path";
    public static final String PDC_AGENT_PACKAGE = "admin.server.net_cli.package";
    public static final String USERMGR_MANAGE_CRED_TABLE = "admin.server.usermgr.manage.cred.table";
    public static final String USERMGR_SOURCE_DIRECTORY = "admin.server.usermgr.source.directory";
    public static final String SERIALPORT_PMADM_PATH = "admin.server.serialmgr.pmadm.path";
    public static final String SERIALPORT_SACADM_PATH = "admin.server.serialmgr.sacadm.path";
    public static final String SERIALPORT_TTYADM_PATH = "admin.server.serialmgr.ttyadm.path";
    public static final String SERIALPORT_DEVTERM_DIR = "admin.server.serialmgr.devterm.dir";
    public static final String SERIALPORT_ALT_DEV_DIR = "admin.server.serialmgr.alternate_dev.dir";
    public static final String SERIALPORT_TTYDEFS_FILE = "admin.server.serialmgr.ttydefs_file";
    private String propfile;
    private int propmode;
    private Properties props = null;

    public AdminProps(String string, String string2, int n) throws AdminException {
        String string3 = null;
        if (string == null || string.trim().length() == 0) {
            throw new UnexpectedErrorException("EXM_NPF");
        }
        try {
            string3 = System.getProperty(string);
        }
        catch (Exception exception) {
            string3 = null;
        }
        if (string3 == null) {
            throw new UnexpectedErrorException("EXM_NPF");
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new UnexpectedErrorException("EXM_NPF");
        }
        this.propmode = n;
        string3 = string3.concat(File.separator);
        this.propfile = string3.concat(string2);
    }

    public AdminProps(String string, int n) throws AdminException {
        this.propfile = string;
        this.propmode = n;
    }

    public String getAdminProp(String string) throws AdminException {
        String string2;
        if (this.props == null) {
            this.loadProperties();
        }
        try {
            string2 = this.props.getProperty(string);
        }
        catch (Exception exception) {
            throw new AdminPropertyNotFoundException(string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public Vector getAdminPropList(String string) throws AdminException {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        if (this.props == null) {
            this.loadProperties();
        }
        int n = 1;
        String string2 = string.concat(".");
        while (bl) {
            string2 = String.valueOf(string) + "." + n;
            try {
                String string3 = this.props.getProperty(string2);
                if (string3 == null) {
                    bl = false;
                } else {
                    vector.addElement(string3);
                }
            }
            catch (Exception exception) {
                bl = false;
            }
            ++n;
        }
        return vector;
    }

    public Vector getAdminPropNames() throws AdminException {
        Vector<String> vector = new Vector<String>();
        if (this.props == null) {
            this.loadProperties();
        }
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = new String((String)enumeration.nextElement());
            vector.addElement(string);
        }
        return vector;
    }

    public void putAdminProp(String string, String string2) throws AdminException {
        if (this.props == null) {
            this.loadProperties();
        }
        String string3 = string2 == null ? "" : string2.trim();
        try {
            ((Hashtable)this.props).put(string, string3);
            return;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException("EXM_PNS", string);
        }
    }

    public void delAdminProp(String string) throws AdminException {
        if (this.props == null) {
            this.loadProperties();
        }
        try {
            String string2 = (String)((Hashtable)this.props).remove(string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void saveAdminProps(String string) throws AdminException {
        this.saveAdminProps(this.propfile, string);
    }

    public void saveAdminProps(String string, String string2) throws AdminException {
        if (this.props != null) {
            if (string2 == null) {
                this.saveProperties(string, "*** DO NOT EDIT THIS FILE ***");
                return;
            }
            this.saveProperties(string, string2);
        }
    }

    private void loadProperties() throws AdminException {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.propfile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = true;
        }
        if (bl && (this.propmode ^ 2) == 0) {
            throw new UnexpectedErrorException("EXM_BPF", this.propfile);
        }
        this.props = new Properties();
        if (!bl) {
            try {
                this.props.load(bufferedInputStream);
            }
            catch (IOException iOException) {
                throw new UnexpectedErrorException("EXM_LPF", (Object)this.propfile, iOException);
            }
        }
        try {
            fileInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void saveProperties(String string, String string2) throws AdminException {
        BufferedOutputStream bufferedOutputStream;
        FileOutputStream fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(string);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        }
        catch (SecurityException securityException) {
            throw new UnexpectedErrorException("EXM_NAP", string);
        }
        catch (IOException iOException) {
            throw new UnexpectedErrorException("EXM_NWP", string);
        }
        try {
            this.props.save(bufferedOutputStream, string2);
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException("EXM_NWP", (Object)string, exception);
        }
        try {
            bufferedOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            throw new UnexpectedErrorException("EXM_NWP", (Object)string, exception);
        }
    }
}

