/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.common;

import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.diskmgr.common.FdiskData;
import com.sun.admin.diskmgr.common.SliceData;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class DiskData
implements Serializable,
Cloneable {
    private static final int MAX_VOLUMELABEL = 8;
    private static final short MAX_SPARC_SLICE = 7;
    public static final short MAX_X86_SLICE = 9;
    public static final short BYTES_PER_SECTOR = 512;
    private static final long MB = 0x100000L;
    private String diskName = "";
    private String diskType = "";
    private String diskLabel = "";
    private int solarisCylinders = 0;
    private int totalCylinders = 0;
    private int headsACylinder = 0;
    private int sectorsATrack = 0;
    private boolean bX86 = false;
    private Vector vSlices = null;
    private Vector vPartitions = null;

    public DiskData() {
    }

    public DiskData(String string, String string2, String string3, int n, int n2, int n3, int n4) {
        this.diskName = string;
        this.diskType = string2;
        this.diskLabel = string3;
        this.solarisCylinders = n;
        this.totalCylinders = n2;
        this.headsACylinder = n3;
        this.sectorsATrack = n4;
    }

    public Object clone() {
        DiskData diskData = new DiskData(this.diskName, this.diskType, this.diskLabel, this.solarisCylinders, this.totalCylinders, this.headsACylinder, this.sectorsATrack);
        Vector<Cloneable> vector = new Vector<Cloneable>();
        Enumeration enumeration = this.vSlices.elements();
        while (enumeration.hasMoreElements()) {
            SliceData sliceData = (SliceData)enumeration.nextElement();
            SliceData sliceData2 = new SliceData(diskData, sliceData.getPartition(), sliceData.getTag(), sliceData.getFlag(), sliceData.getStartCylinder(), sliceData.getNumSectors(), sliceData.getFS());
            vector.addElement(sliceData2);
        }
        diskData.setVSlices(vector);
        if (this.bX86) {
            vector = new Vector();
            Enumeration enumeration2 = this.vPartitions.elements();
            while (enumeration2.hasMoreElements()) {
                FdiskData fdiskData = (FdiskData)enumeration2.nextElement();
                FdiskData fdiskData2 = new FdiskData(diskData, fdiskData.getPartition(), fdiskData.getUsedFor(), fdiskData.getStartCylinder(), fdiskData.getNumSectors(), fdiskData.getActive());
                vector.addElement(fdiskData2);
            }
            diskData.setVPartitions(vector);
        }
        return diskData;
    }

    public long computeDiskCapacity() {
        long l = (long)this.getSolarisCylinders() * (long)this.headsACylinder * (long)this.sectorsATrack * 512L;
        return l;
    }

    public int computeDiskFree() {
        return this.getTotalCylinders() - this.computeDiskUsed();
    }

    public float computeDiskPercentFree() {
        float f = this.getTotalCylinders();
        float f2 = this.computeDiskFree();
        float f3 = 100.0f * (f2 / f);
        int n = (int)(f3 * 100.0f);
        f3 = n;
        return f3 /= 100.0f;
    }

    public int computeDiskUsed() {
        int n = 0;
        if (this.vSlices != null) {
            Enumeration enumeration = this.vSlices.elements();
            while (enumeration.hasMoreElements()) {
                SliceData sliceData = (SliceData)enumeration.nextElement();
                int n2 = sliceData.getStartCylinder();
                int n3 = sliceData.getEndCylinder();
                if (sliceData.getTag() == 5 || n3 == 0) continue;
                n += n3 - n2;
            }
        }
        return n;
    }

    public int computeFdiskFree() {
        return this.getTotalCylinders() - this.computeFdiskUsed();
    }

    public float computeFdiskPercentFree() {
        float f = this.getTotalCylinders();
        float f2 = this.computeFdiskFree();
        float f3 = 100.0f * (f2 / f);
        int n = (int)(f3 * 100.0f);
        f3 = n;
        return f3 /= 100.0f;
    }

    public int computeFdiskUsed() {
        int n = 0;
        if (this.vPartitions != null) {
            Enumeration enumeration = this.vPartitions.elements();
            while (enumeration.hasMoreElements()) {
                FdiskData fdiskData = (FdiskData)enumeration.nextElement();
                int n2 = fdiskData.getStartCylinder();
                int n3 = fdiskData.getEndCylinder();
                if (n3 == 0) continue;
                n += n3 - n2;
            }
        }
        return n;
    }

    public float cylinderToMB(int n) {
        float f = 512.0f * (float)this.cylinderToSector(n) / 1048576.0f;
        int n2 = (int)(f * 100.0f);
        f = n2;
        return f /= 100.0f;
    }

    public int cylinderToSector(int n) {
        return n * this.headsACylinder * this.sectorsATrack;
    }

    public boolean equals(DiskData diskData) {
        if (diskData == null) {
            return false;
        }
        return this.getDiskName().equals(diskData.getDiskName()) && this.getDiskType().equals(diskData.getDiskType()) && this.getDiskLabel().equals(diskData.getDiskLabel());
    }

    public String getDiskCapacity() {
        return Float.toString(this.cylinderToMB(this.getTotalCylinders()));
    }

    public String getDiskFree() {
        return Float.toString(this.cylinderToMB(this.computeDiskFree()));
    }

    public String getDiskLabel() {
        return this.diskLabel;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public String getDiskPercentFree() {
        Float f = new Float(this.computeDiskPercentFree());
        return f.toString();
    }

    public String getDiskType() {
        return this.diskType;
    }

    public String getDiskUsed() {
        return Float.toString(this.cylinderToMB(this.computeDiskUsed()));
    }

    public Vector getFreeCylRanges() {
        Vector<int[]> vector = new Vector<int[]>();
        Vector<int[]> vector2 = new Vector<int[]>();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        this.sortSlicesByStartCyl();
        Enumeration enumeration = this.vSlices.elements();
        while (enumeration.hasMoreElements()) {
            SliceData sliceData = (SliceData)enumeration.nextElement();
            if (sliceData.getTag() == 5 || !(sliceData.computeSize() > 0.0f)) continue;
            nArray2 = new int[]{sliceData.getStartCylinder(), sliceData.getEndCylinder()};
            vector2.addElement(nArray2);
        }
        if (vector2.size() > 0) {
            int[] nArray4 = new int[2];
            int[] nArray5 = new int[2];
            nArray4 = (int[])vector2.firstElement();
            if (nArray4[0] > 1) {
                nArray = new int[]{0, nArray4[0] - 1};
                vector.addElement(nArray);
            }
            nArray3 = (int[])vector2.lastElement();
            if (vector2.size() > 1) {
                nArray5 = (int[])vector2.elementAt(1);
            }
            int n = 1;
            while (n < vector2.size()) {
                if (nArray5[0] - nArray4[1] > 1) {
                    nArray = new int[]{nArray4[1] + 1, nArray5[0] - 1};
                    vector.addElement(nArray);
                }
                if (nArray5[0] == nArray3[0] && nArray5[1] == nArray3[1]) break;
                nArray4 = (int[])vector2.elementAt(n);
                nArray5 = (int[])vector2.elementAt(n + 1);
                ++n;
            }
            if (nArray3[1] < this.getSolarisCylinders()) {
                nArray = new int[]{nArray3[1] + 1, this.getSolarisCylinders()};
                vector.addElement(nArray);
            }
        }
        return vector;
    }

    public int getHeadsACylinder() {
        return this.headsACylinder;
    }

    public int getSectorsATrack() {
        return this.sectorsATrack;
    }

    public int getSolarisCylinders() {
        return this.solarisCylinders;
    }

    public String getSolarisDiskCapacity() {
        return Float.toString(this.cylinderToMB(this.getSolarisCylinders()));
    }

    public int getTotalCylinders() {
        return this.totalCylinders;
    }

    public Vector getVPartitions() {
        return this.vPartitions;
    }

    public Vector getVSlices() {
        return this.vSlices;
    }

    public boolean hasBackup() {
        boolean bl = false;
        Enumeration enumeration = this.vSlices.elements();
        while (enumeration.hasMoreElements()) {
            SliceData sliceData = (SliceData)enumeration.nextElement();
            if (sliceData.getTag() != 5) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean hasSliceOverlap() {
        boolean bl = false;
        this.sortSlicesByPartition();
        Vector vector = (Vector)this.vSlices.clone();
        if (this.isX86()) {
            vector.removeElementAt(vector.size() - 1);
            vector.removeElementAt(vector.size() - 1);
        }
        Vector<SliceData> vector2 = new Vector<SliceData>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SliceData sliceData = (SliceData)enumeration.nextElement();
            if (sliceData.getTag() == 5 || !(sliceData.computeSize() > 0.0f)) continue;
            vector2.addElement(sliceData);
        }
        Sort.sort(vector2, (Compare)new SortSlicesByStartCyl());
        if (vector2.size() < 2) {
            return false;
        }
        SliceData sliceData = (SliceData)vector2.elementAt(0);
        SliceData sliceData2 = (SliceData)vector2.elementAt(1);
        if (vector2.size() == 2) {
            return sliceData2.getStartCylinder() - sliceData.getEndCylinder() < 1;
        }
        int n = 1;
        while (n < vector2.size() - 1) {
            int n2 = sliceData2.getStartCylinder() - sliceData.getEndCylinder();
            if (n2 < 1) {
                bl = true;
                break;
            }
            sliceData = (SliceData)vector2.elementAt(n);
            sliceData2 = (SliceData)vector2.elementAt(n + 1);
            ++n;
        }
        return bl;
    }

    public boolean hasSolarisPartitions() {
        if (!this.isX86() && this.vSlices.size() > 0) {
            return true;
        }
        if (this.isX86()) {
            Enumeration enumeration = this.vPartitions.elements();
            while (enumeration.hasMoreElements()) {
                FdiskData fdiskData = (FdiskData)enumeration.nextElement();
                if (fdiskData.getUsedFor() != 130) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isX86() {
        return this.bX86;
    }

    public void print() {
        Cloneable cloneable;
        Enumeration enumeration;
        System.out.println("*************************************");
        System.out.println("Disk Name:\t" + this.getDiskName());
        System.out.println("Disk Type:\t" + this.getDiskType());
        System.out.println("Volume Label:\t" + this.getDiskLabel());
        System.out.println("Disk Capacity:\t" + this.getDiskCapacity());
        System.out.println("Disk Used:\t" + this.getDiskUsed());
        System.out.println("Disk Free:\t" + this.getDiskFree());
        System.out.println("Disk Percent Free:  " + this.getDiskPercentFree());
        System.out.println("Solaris Cylinders: " + this.getSolarisCylinders());
        System.out.println("Total Cylinders: " + this.getTotalCylinders());
        System.out.println("Heads Per Cylinder: " + this.getHeadsACylinder());
        System.out.println("Sectors Per Track: " + this.getSectorsATrack());
        System.out.println("*************************************");
        System.out.println();
        if (this.vSlices != null) {
            enumeration = this.vSlices.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (SliceData)enumeration.nextElement();
                ((SliceData)cloneable).print();
            }
        }
        System.out.println();
        if (this.vPartitions != null) {
            enumeration = this.vPartitions.elements();
            while (enumeration.hasMoreElements()) {
                cloneable = (FdiskData)enumeration.nextElement();
                ((FdiskData)cloneable).print();
            }
        }
    }

    public int sectorToCylinder(int n) {
        return n / this.sectorsATrack / this.headsACylinder;
    }

    public void setDiskLabel(String string) {
        this.diskLabel = string;
    }

    public void setDiskName(String string) {
        this.diskName = string;
    }

    public void setVPartitions(Vector vector) {
        this.vPartitions = vector;
    }

    public void setVSlices(Vector vector) {
        this.vSlices = vector;
    }

    public void setX86(boolean bl) {
        this.bX86 = bl;
    }

    public void sortSlicesByPartition() {
        Sort.sort((Vector)this.vSlices, (Compare)new SortSlicesByPartition());
    }

    public void sortSlicesByStartCyl() {
        Sort.sort((Vector)this.vSlices, (Compare)new SortSlicesByStartCyl());
    }

    public int spaceToCylinders(int n) {
        double d = (double)this.computeDiskCapacity() / 1048576.0;
        double d2 = (double)n / d;
        return (int)(d2 * (double)this.getTotalCylinders());
    }

    private class SortSlicesByStartCyl
    implements Compare {
        SortSlicesByStartCyl() {
        }

        public final int doCompare(Object object, Object object2) {
            int n = 1;
            SliceData sliceData = (SliceData)object;
            SliceData sliceData2 = (SliceData)object2;
            int n2 = sliceData.getStartCylinder();
            int n3 = sliceData2.getStartCylinder();
            if (sliceData.getTag() == 5 && sliceData2.getTag() == 5) {
                n = 0;
            } else if (n2 == n3) {
                n = sliceData.getTag() == 5 ? 1 : (sliceData.computeSize() < sliceData2.computeSize() ? -1 : (sliceData.computeSize() == sliceData2.computeSize() ? (sliceData.getPartition() < sliceData2.getPartition() ? -1 : 1) : 1));
            } else if (n2 < n3) {
                n = -1;
            }
            return n;
        }
    }

    private class SortSlicesByPartition
    implements Compare {
        SortSlicesByPartition() {
        }

        public final int doCompare(Object object, Object object2) {
            short s;
            SliceData sliceData = (SliceData)object;
            SliceData sliceData2 = (SliceData)object2;
            short s2 = sliceData.getPartition();
            if (s2 < (s = sliceData2.getPartition())) {
                return -1;
            }
            return 1;
        }
    }
}

