
import java.rmi.*;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.security.UserPrincipal;
import com.sun.wbem.security.PasswordCredential;
import java.util.*;
import java.io.*;
import java.lang.*;
import java.util.Enumeration;

/** 
 * This example creates an instance of Solaris_LogRecord and sets this
 * instance.
 */

public class CreateLog {
    public static void main(String args[]) throws CIMException {
	
	if (args.length != 3) {
	    System.out.println("Usage: CreateLog host username password"); 
	    System.exit(1);
	}

	CIMClient cc = null;
	CIMObjectPath cop = null;
	BufferedReader d = new BufferedReader(new InputStreamReader(System.in));
	String input_line = "";
	System.out.print("How many log records do you want to write? ");
	int num_recs = 0;
	
	try {
		num_recs = Integer.parseInt(d.readLine());
	} catch (Exception ex) {
		ex.printStackTrace();
		System.exit(1);
	}
	try {
	    CIMNameSpace cns = new CIMNameSpace(args[0]);
	    UserPrincipal up = new UserPrincipal(args[1]);
	    PasswordCredential pc = new PasswordCredential(args[2]);
	    cc = new CIMClient(cns, up, pc);

		Vector keys = new Vector();

		CIMProperty logsvcKey = new CIMProperty("RecordID");
		logsvcKey.setValue(new CIMValue(new Integer(0)));
		keys.addElement(logsvcKey);
		logsvcKey = new CIMProperty("RecordHashCode");
		logsvcKey.setValue(new CIMValue(new Integer(0)));
		keys.addElement(logsvcKey);
		logsvcKey = new CIMProperty("Filename");
		logsvcKey.setValue(new CIMValue("bogus_file"));
		keys.addElement(logsvcKey);
		System.out.println("Please enter the record Category: ");
		System.out.println("\t(0)application, (1)security, (2)system");
		logsvcKey = new CIMProperty("category");
		input_line = d.readLine();
		logsvcKey.setValue(new CIMValue(Integer.valueOf(input_line)));
		keys.addElement(logsvcKey);
		System.out.println("Please enter the record Severity: ");
		System.out.println("\t(0)Informational, (1)Warning, (2)Error");
		logsvcKey = new CIMProperty("severity");
		input_line = d.readLine();
		logsvcKey.setValue(new CIMValue(Integer.valueOf(input_line)));
		keys.addElement(logsvcKey);
		logsvcKey = new CIMProperty("AppName");
		System.out.println("Please enter Application Name: ");
		logsvcKey.setValue(new CIMValue(d.readLine()));
		keys.addElement(logsvcKey);
		System.out.println("Please enter User Name: ");
		logsvcKey = new CIMProperty("UserName");
		logsvcKey.setValue(new CIMValue(d.readLine()));
		keys.addElement(logsvcKey);
		System.out.println("Please enter Client Machine Name: ");
		logsvcKey = new CIMProperty("ClientMachineName");
		logsvcKey.setValue(new CIMValue(d.readLine()));
		keys.addElement(logsvcKey);
		System.out.println("Please enter Server Machine Name: ");
		logsvcKey = new CIMProperty("ServerMachineName");
		logsvcKey.setValue(new CIMValue(d.readLine()));
		keys.addElement(logsvcKey);
		logsvcKey = new CIMProperty("SummaryMessage");
		logsvcKey.setValue(new CIMValue("I know this works"));
		keys.addElement(logsvcKey);
		logsvcKey = new CIMProperty("DetailedMessage");
		logsvcKey.setValue
		    (new CIMValue("I know this works very well!!!"));
		keys.addElement(logsvcKey);
		logsvcKey = new CIMProperty("data");
		logsvcKey.setValue(new CIMValue("0xfe 0x45 0xae 0xda"));
		keys.addElement(logsvcKey);
		logsvcKey = new CIMProperty("SyslogFlag");
		logsvcKey.setValue(new CIMValue(new Boolean(true)));
		keys.addElement(logsvcKey);
	 	CIMObjectPath logreccop = 
		        new CIMObjectPath("Solaris_LogRecord", keys);
		CIMInstance ci = new CIMInstance();
		ci.setClassName("Solaris_LogRecord");
		ci.setProperties(keys);
		// System.out.println(ci.toString());
		for (int i = 0; i < num_recs; i++)
			cc.createInstance(logreccop, ci);
	}
	catch (Exception e) {
	    System.out.println("Exception: "+e);
		e.printStackTrace();
	}

	// close session.
	if (cc != null) {
	    cc.close();
	}
    }
}
