/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.diskmgr.client;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.Compare;
import com.sun.admin.cis.common.sort.Sort;
import com.sun.admin.diskmgr.client.Content;
import com.sun.admin.diskmgr.client.VDiskMgr;
import com.sun.admin.diskmgr.common.DiskData;
import com.sun.admin.diskmgr.common.DiskMgrException;
import com.sun.admin.diskmgr.common.SliceData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class DiskGraphic
extends JPanel {
    public static final int NUM_SLICES = 8;
    private static final Dimension GRAPHIC_DIM = new Dimension(280, 80);
    ResourceBundle bundle;
    VDiskMgr theApp;
    boolean bShowPreviewText;
    JPanel diskPanel;
    TopPanel topPanel;
    FlowArea overlapFA;
    private Vector vPanels;
    private DiskData diskData;
    private SliceData sliceData;
    private float capacity;
    public GridBagConstraints gbc;

    public DiskGraphic(VDiskMgr vDiskMgr, DiskData diskData, SliceData sliceData, boolean bl) {
        this.theApp = vDiskMgr;
        this.bundle = vDiskMgr.getResourceBundle();
        this.diskData = diskData;
        this.sliceData = sliceData;
        this.capacity = diskData.computeDiskCapacity() / 1000000L;
        this.bShowPreviewText = bl;
        this.setBorder(new LineBorder(Color.darkGray));
        this.gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.layoutGraphic(diskData);
        this.setPreferredSize(this.getMaxGraphicSize());
    }

    protected Vector createSlicePanels(DiskData diskData) {
        Vector<SlicePanel> vector = new Vector<SlicePanel>();
        Vector vector2 = diskData.getVSlices();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            SliceData sliceData = (SliceData)enumeration.nextElement();
            if (sliceData.computeSize() == 0.0f && sliceData.getTag() != 5) continue;
            vector.addElement(new SlicePanel(sliceData));
        }
        Vector vector3 = diskData.getFreeCylRanges();
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            vector.addElement(new SlicePanel(nArray));
        }
        return vector;
    }

    private Dimension getMaxGraphicSize() {
        TopPanel topPanel = new TopPanel(this.bShowPreviewText);
        KeyPanel keyPanel = new KeyPanel();
        int n = DiskGraphic.GRAPHIC_DIM.width;
        n = Math.max(n, topPanel.getPreferredSize().width);
        n = Math.max(n, keyPanel.getPreferredSize().width);
        int n2 = this.overlapFA.getPreferredSize().width;
        int n3 = DiskGraphic.GRAPHIC_DIM.height;
        n3 += topPanel.getPreferredSize().height;
        n3 += keyPanel.getPreferredSize().height;
        int n4 = this.overlapFA.getPreferredSize().height;
        Dimension dimension = new Dimension(Math.max(n2, n), Math.max(n4, n3 += 24));
        return dimension;
    }

    public int getNextEndCylinder(SliceData sliceData) {
        SlicePanel slicePanel = this.getNextSlicePanel(sliceData);
        int n = -1;
        if (slicePanel != null && slicePanel.getSliceData() == null) {
            n = slicePanel.getEndCylinder();
        }
        return n;
    }

    protected SlicePanel getNextSlicePanel(SliceData sliceData) {
        int n = this.getSlicePanelIndex(sliceData) + 1;
        SlicePanel slicePanel = null;
        if (n < this.vPanels.size()) {
            slicePanel = (SlicePanel)this.vPanels.elementAt(n);
        }
        return slicePanel;
    }

    protected SlicePanel getPreviousSlicePanel(SliceData sliceData) {
        int n = this.getSlicePanelIndex(sliceData) - 1;
        SlicePanel slicePanel = null;
        if (n >= 0) {
            slicePanel = (SlicePanel)this.vPanels.elementAt(n);
        }
        return slicePanel;
    }

    public int getPreviousStartCylinder(SliceData sliceData) {
        SlicePanel slicePanel = this.getPreviousSlicePanel(sliceData);
        int n = -1;
        if (slicePanel != null && slicePanel.getSliceData() == null) {
            n = slicePanel.getStartCylinder();
        }
        return n;
    }

    private int getSlicePanelIndex(SliceData sliceData) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.vPanels.size()) {
            SlicePanel slicePanel = (SlicePanel)this.vPanels.elementAt(n2);
            SliceData sliceData2 = slicePanel.getSliceData();
            if (sliceData2 != null && sliceData2.equals(sliceData)) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    public void layoutGraphic(DiskData diskData) {
        this.removeAll();
        this.diskPanel = new JPanel();
        this.diskPanel.setBorder(LineBorder.createBlackLineBorder());
        this.diskPanel.setBackground(Color.black);
        this.diskPanel.setLayout(new GridBagLayout());
        this.vPanels = this.createSlicePanels(diskData);
        this.overlapFA = new FlowArea(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"NoGraphicFA"), 35);
        if (!diskData.hasSliceOverlap()) {
            this.topPanel = new TopPanel(this.bShowPreviewText);
            Constraints.constrain((Container)this, (Component)this.topPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)3, (int)12, (int)0, (int)12);
            this.layoutPanels(this.vPanels);
            this.diskPanel.setPreferredSize(GRAPHIC_DIM);
            Constraints.constrain((Container)this, (Component)this.diskPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)12);
            Constraints.constrain((Container)this, (Component)new KeyPanel(), (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)12);
        } else {
            Constraints.constrain((Container)this, (Component)this.overlapFA, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)12, (int)0, (int)12);
        }
    }

    public void layoutPanels(Vector vector) {
        Object object;
        SlicePanel slicePanel;
        this.sortSlicePanels(vector);
        this.diskPanel.removeAll();
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            slicePanel = (SlicePanel)enumeration.nextElement();
            if (!slicePanel.isBackup()) {
                Constraints.constrain((Container)this.diskPanel, (Component)slicePanel, (int)n, (int)0, (int)1, (int)1, (int)1, (int)17, (double)slicePanel.getWeight(), (double)1.0, (int)0, (int)0, (int)0, (int)0);
                ++n;
                bl = true;
                continue;
            }
            object = new Dimension(280, 12);
            slicePanel.setPreferredSize((Dimension)object);
            Constraints.constrain((Container)this.diskPanel, (Component)slicePanel, (int)0, (int)1, (int)vector.size(), (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        }
        if (!bl) {
            object = new int[]{0, this.diskData.getSolarisCylinders() - 1};
            slicePanel = new SlicePanel((int[])object);
            slicePanel.setMinimumSize(new Dimension(280, 20));
            Constraints.constrain((Container)this.diskPanel, (Component)slicePanel, (int)0, (int)0, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        }
    }

    public void preview(int n, int n2) {
        DiskData diskData = (DiskData)this.diskData.clone();
        diskData.sortSlicesByPartition();
        SliceData sliceData = (SliceData)diskData.getVSlices().elementAt(this.sliceData.getPartition());
        sliceData.setStartCylinder(n);
        sliceData.setEndCylinder(n2);
        if (!diskData.hasSliceOverlap()) {
            this.layoutGraphic(diskData);
            Vector vector = this.createSlicePanels(diskData);
            this.layoutPanels(vector);
            this.validate();
            this.repaint();
        }
    }

    public void reset() {
        this.layoutGraphic(this.diskData);
        this.layoutPanels(this.vPanels);
        this.validate();
        this.repaint();
    }

    protected void sortSlicePanels(Vector vector) {
        Sort.sort((Vector)vector, (Compare)new SortSlicePanelsByStartCyl());
    }

    private class SlicePanel
    extends JPanel {
        protected SliceData sliceData = null;
        protected JLabel label = new JLabel();
        protected float weight;
        protected int startCyl;
        protected int endCyl;

        public SlicePanel(SliceData sliceData) {
            this.sliceData = sliceData;
            this.startCyl = sliceData.getStartCylinder();
            this.endCyl = sliceData.getEndCylinder();
            this.computeWeight();
            this.setLayout(new GridBagLayout());
            this.setBorder(LineBorder.createBlackLineBorder());
            this.setBackground(Color.gray);
            this.label.setFont(Constants.PROPS_RO_VALUE_FONT);
            this.label.setForeground(Color.black);
            this.label.setText(Short.toString(sliceData.getPartition()));
            Constraints.constrain((Container)this, (Component)this.label, (int)0, (int)0, (int)1, (int)1, (int)0, (int)10, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
            this.setToolTipText(this.makeToolTip());
        }

        public SlicePanel(int[] nArray) {
            this.startCyl = nArray[0];
            this.endCyl = nArray[1];
            this.computeWeight();
            this.setLayout(new GridBagLayout());
            this.setBorder(LineBorder.createBlackLineBorder());
            this.setBackground(Color.white);
            this.setToolTipText(this.makeToolTip());
        }

        protected void computeWeight() {
            int n = this.endCyl - this.startCyl;
            if (n > 0) {
                ++n;
            }
            float f = DiskGraphic.this.diskData.cylinderToMB(n);
            this.weight = f / DiskGraphic.this.capacity;
        }

        public int getEndCylinder() {
            return this.endCyl;
        }

        public SliceData getSliceData() {
            return this.sliceData;
        }

        public int getStartCylinder() {
            return this.startCyl;
        }

        public float getWeight() {
            return this.weight;
        }

        public boolean isBackup() {
            return this.sliceData != null && this.sliceData.getTag() == 5;
        }

        protected String makeToolTip() {
            String string = ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"GraphicToolTip");
            Object[] objectArray = new Object[3];
            Integer n = new Integer(this.startCyl);
            objectArray[0] = n.toString();
            n = new Integer(this.endCyl);
            objectArray[1] = n.toString();
            float f = DiskGraphic.this.diskData.cylinderToMB(this.endCyl - this.startCyl);
            Float f2 = new Float(f);
            objectArray[2] = Content.formatSuffix(f2.toString(), ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"Megabytes"));
            return MessageFormat.format(string, objectArray);
        }

        public void setEndCylinder(int n) {
            this.endCyl = n;
            this.computeWeight();
        }

        public void setStartCylinder(int n) {
            this.startCyl = n;
            this.computeWeight();
        }
    }

    public class SortSlicePanelsByStartCyl
    implements Compare {
        public final int doCompare(Object object, Object object2) {
            int n = 0;
            SlicePanel slicePanel = (SlicePanel)object;
            SlicePanel slicePanel2 = (SlicePanel)object2;
            int n2 = slicePanel.startCyl;
            int n3 = slicePanel2.startCyl;
            if (slicePanel.isBackup() && slicePanel2.isBackup()) {
                n = 0;
            } else if (slicePanel.isBackup()) {
                n = 1;
            } else if (slicePanel2.isBackup()) {
                n = -1;
            } else if (n2 > n3) {
                n = 1;
            } else if (n2 < n3) {
                n = -1;
            } else {
                DiskMgrException diskMgrException = new DiskMgrException("EXM_DM_GUI_DISKGRAPHIC");
                DiskGraphic.this.theApp.reportErrorException((Exception)((Object)diskMgrException));
            }
            return n;
        }
    }

    private class TopPanel
    extends JPanel {
        public TopPanel(boolean bl) {
            JPanel jPanel;
            JLabel jLabel;
            this.setLayout(new GridBagLayout());
            String string = ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"GraphicLabel");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            if (bl) {
                jLabel = new JLabel(string);
                Constraints.constrain((Container)jPanel2, (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
                jPanel = new FlowArea(ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"GraphicFA"), 35);
                Constraints.constrain((Container)jPanel2, (Component)jPanel, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)6, (int)6, (int)6);
            }
            Constraints.constrain((Container)this, (Component)jPanel2, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jLabel = new JLabel(Content.formatSuffix("0", ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"CylinderNum")));
            Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)0, (int)1, (int)1, (int)0, (int)16, (double)0.0, (double)0.0, (int)6, (int)0, (int)0, (int)0);
            JPanel jPanel3 = new JPanel();
            Constraints.constrain((Container)jPanel, (Component)jPanel3, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            jLabel = new JLabel(Content.formatSuffix(Integer.toString(DiskGraphic.this.diskData.getSolarisCylinders() - 1), ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"CylinderNum")));
            Constraints.constrain((Container)jPanel, (Component)jLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)14, (double)0.0, (double)0.0, (int)6, (int)0, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"GraphicLine"));
            Constraints.constrain((Container)jPanel, (Component)jLabel, (int)0, (int)1, (int)1, (int)1, (int)0, (int)18, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"GraphicLine"));
            Constraints.constrain((Container)jPanel, (Component)jLabel, (int)2, (int)1, (int)1, (int)1, (int)0, (int)12, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        }
    }

    private class KeyPanel
    extends JPanel {
        public KeyPanel() {
            this.setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel();
            Constraints.constrain((Container)this, (Component)jPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            JPanel jPanel2 = this.getKey();
            Constraints.constrain((Container)this, (Component)jPanel2, (int)1, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)6, (int)6, (int)6);
            JLabel jLabel = new JLabel(ResourceStrings.getString((ResourceBundle)DiskGraphic.this.bundle, (String)"GraphicFree"));
            Constraints.constrain((Container)this, (Component)jLabel, (int)2, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)6, (int)0, (int)6, (int)6);
        }

        private JPanel getKey() {
            Dimension dimension = new Dimension(5, 5);
            JPanel jPanel = new JPanel();
            jPanel.setBorder(LineBorder.createBlackLineBorder());
            jPanel.setSize(dimension);
            jPanel.setBackground(Color.white);
            return jPanel;
        }
    }
}

