/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.logviewer.client.ServiceWrapper;
import com.sun.admin.logviewer.client.VLogViewer;
import com.sun.admin.logviewer.client.WbemServiceWrapper;
import com.sun.admin.logviewer.common.LogViewerException;
import com.sun.management.viper.ToolContext;
import com.sun.management.viper.ToolInfrastructure;
import com.sun.management.viper.client.ExternalClientList;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.client.CIMClient;
import java.util.ResourceBundle;

public class ApplicationContext {
    private VLogViewer theApp;
    private ToolContext toolContext;

    public ApplicationContext(VLogViewer vLogViewer, ToolContext toolContext) {
        this.theApp = vLogViewer;
        this.toolContext = toolContext;
    }

    private String getServiceType() {
        String string = "Wbem";
        try {
            String string2 = System.getProperty("logviewer.serviceType");
            if (string2 != null) {
                string = string2;
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public ServiceWrapper getServiceWrapper(ToolInfrastructure toolInfrastructure) throws AdminException {
        ResourceBundle resourceBundle = this.theApp.getResourceBundle();
        String string = this.getServiceType();
        String string2 = "com.sun.admin.logviewer.client." + string + "ServiceWrapper";
        ServiceWrapper serviceWrapper = null;
        try {
            serviceWrapper = (ServiceWrapper)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LogViewerException("EXM_LV_GUI_SERVICE_NOT_REACHABLE", (Object)string, (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
        }
        catch (Exception exception) {
            LogViewerException logViewerException = new LogViewerException("EXM_LV_GUI_CANT_GET_SERVICE_WRAPPER", (Object)string, (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), string2);
            logViewerException.addArg(exception.getMessage());
            throw logViewerException;
        }
        int n = 2;
        int n2 = 1;
        while (n2 <= n) {
            block8: {
                try {
                    if (serviceWrapper instanceof WbemServiceWrapper) {
                        String string3 = toolInfrastructure.getIdentity().getAuthenHost();
                        CIMNameSpace cIMNameSpace = new CIMNameSpace(string3, "root\\cimv2");
                        Object[] objectArray = new Object[]{cIMNameSpace, new Integer(1)};
                        CIMClient cIMClient = (CIMClient)toolInfrastructure.getExternalClient(ExternalClientList.CIMWBEM, objectArray);
                        serviceWrapper.init(cIMClient, toolInfrastructure);
                        break;
                    }
                }
                catch (Exception exception) {
                    if (exception.getMessage().equals("TIMED_OUT") && n2 <= n) break block8;
                    if (exception.getMessage().equals("NO_CIMOM")) {
                        throw new LogViewerException("EXM_LV_GUI_CANT_CONNECT_NO_CIMOM", ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"));
                    }
                    throw new LogViewerException("EXM_LV_GUI_CANT_CONNECT_TO_SERVER", (Object)ResourceStrings.getString((ResourceBundle)resourceBundle, (String)"BEANNAME"), exception.getMessage());
                }
            }
            ++n2;
        }
        return serviceWrapper;
    }
}

