/*
 * "@(#)Native_Example.java	1.2 1.2 SMI"
 *
 * Copyright 1998-1999 Sun Microsystems, Inc.,
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * For more on the Java Native Interface surf to :       
 * http://www.javasoft.com/docs/books/tutorial/native1.1/index.html
 *
 */

import com.sun.wbem.cim.*;
import com.sun.wbem.provider.CIMProvider;
import com.sun.wbem.provider.InstanceProvider;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.io.*;

    /**
     *
     *
     * @author	Sun Microsystems, Inc.
     * @version    1.2, 02/18/00
     * @since      WBEM 1.0
     */
public class Native_Example {

    public CIMInstance getInstance(CIMObjectPath op, CIMClass cc) {
	String pkgName = "";

	for (Enumeration e = op.getKeys().elements(); e.hasMoreElements(); ) {
	    CIMProperty cp = (CIMProperty)e.nextElement();
	    if (cp.getName().equalsIgnoreCase("name")) {
		pkgName = (String) ((CIMValue)(cp.getValue())).getValue();
	    }
	}

	CIMInstance ci = cc.newInstance();
	ci.setProperty("Hostname", new CIMValue(getHostname()));	
	ci.setProperty("SerialNumber", new CIMValue(getSerialnumber()));	
	ci.setProperty("OSRelease", new CIMValue(getRelease()));	
	ci.setProperty("MachineType", new CIMValue(getMachine()));	
	ci.setProperty("MachineArchitecture", new CIMValue(getArchitecture()));
	ci.setProperty("Manufacturer", new CIMValue(getManufacturer()));
	return ci;
    }

    public Vector enumerateInstances(CIMObjectPath op) 
    throws CIMException {

	Vector instances = new Vector();
        CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), 
                                                 op.getNameSpace());
        cop.addKey("Hostname", new CIMValue(getHostname()));
        instances.addElement(cop);
	return instances;
    }


    native String getHostname();
    native String getSerialnumber();
    native String getRelease();
    native String getMachine();
    native String getArchitecture();
    native String getManufacturer();
    native Boolean HelloWorld();

    static {
        System.loadLibrary("native");
   
    }

}



