/*
 * @(#)SystemInfo.java	1.10 00/09/19
 *
 * Copyright (c) 09/19/00 Sun Microsystems, Inc.  All Rights Reserved.
 */


import java.rmi.*;
import java.util.Vector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import javax.swing.JTabbedPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JFrame;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt16;


public class SystemInfo extends JPanel {

    public static void main(String args[]) {
        try {
	    // set up keys for solaris computer system

	    String hostName = InetAddress.getLocalHost().getHostName();

	    Vector computerSystemKeys = new Vector();
	    CIMProperty computerSystemKey = new CIMProperty
	                                        ("CreationClassName");
	    computerSystemKey.setValue(new CIMValue("Solaris_ComputerSystem"));
	    computerSystemKeys.addElement(computerSystemKey);
	    computerSystemKey = new CIMProperty("Name");

	    computerSystemKey.setValue(new CIMValue(hostName));
	    computerSystemKeys.addElement(computerSystemKey);
	    
	    // set up keys for solaris processor
	    Vector processorKeys = new Vector();
	    CIMProperty processorKey = new CIMProperty("CreationClassName");
	    processorKey.setValue(new CIMValue("Solaris_Processor"));
	    processorKeys.addElement(processorKey);
	    processorKey = new CIMProperty("SystemCreationClassName");
	    processorKey.setValue(new CIMValue("Solaris_ComputerSystem"));
	    processorKeys.addElement(processorKey);
	    processorKey = new CIMProperty("SystemName");
	    processorKey.setValue(new CIMValue(hostName));
	    processorKeys.addElement(processorKey);
	    processorKey = new CIMProperty("DeviceID");
	    processorKey.setValue(new CIMValue("0"));
	    processorKeys.addElement(processorKey);
	    CIMValue cVal;
	    CIMNameSpace cns = new CIMNameSpace("");
	    CIMClient cc = new CIMClient(cns);
	    // get handle to computer system
	    CIMObjectPath computerSystemCOP = new
                  CIMObjectPath("Solaris_ComputerSystem", computerSystemKeys);
	    CIMInstance computerSystemIE = 
	            cc.getInstance(computerSystemCOP, false);
	    // get handle to processor
	    CIMObjectPath processorCOP = new CIMObjectPath("Solaris_Processor", 
                                                               processorKeys);
	    CIMInstance processorIE = cc.getInstance(processorCOP, false);
	    // Solaris_ComputerSystem Info
	    String name = (String) 
                computerSystemIE.getProperty("Name").getValue().getValue();
	    String CCname = (String) 
	            computerSystemIE.getProperty
	                  ("CreationClassName").getValue().getValue();

	    // Solaris_Processor Info
	    String deviceid = (String) 
                   processorIE.getProperty("DeviceID").getValue().getValue();
	    UnsignedInt32 CPUSpeed =  (UnsignedInt32)
                   processorIE.getProperty
	                   ("CurrentClockSpeed").getValue().getValue();
	    UnsignedInt16 loadAve = (UnsignedInt16)
	                        processorIE.getProperty
	                        ("LoadPercentage").getValue().getValue();
	    String Status = (String) 
                     processorIE.getProperty("Status").getValue().getValue();
	    String generalInfo[] = {"Host Name : " + name, "Creation Class : " +
                                 CCname, "Device ID : " + deviceid, 
                                 "Clock Speed : "+ CPUSpeed + " MHz",
                                 "Processor Status : " + Status, "CPU load : " +
                                 loadAve + " %" };

	    JFrame frame = new JFrame("System Information Panel : " + name);

	    WindowListener l = new WindowAdapter() {
                public void windowClosing(WindowEvent event) { 
		    System.exit(0);
		}
	    };
	    frame.addWindowListener(l);
	    frame.getContentPane().add(new SystemInfo(generalInfo), 
                                               BorderLayout.CENTER);
	    frame.setSize(400, 400);
	    frame.setResizable(false);
	    frame.show();

	} catch (Exception e) {
	    System.out.println("Exception: "+e);
	}
       
    }

    public SystemInfo(String gi[]) {
        JTabbedPane tabbedPane = new JTabbedPane();
      
	Component panel1 = makePanel(gi);
	tabbedPane.addTab("General", null, panel1, "General Information");

	setLayout(new GridLayout(1, 1));
      
	add(tabbedPane);
    }

    protected Component makePanel(String info[]) {
        JPanel panel = new JPanel(false);
	JLabel text;
	panel.setLayout(new GridLayout(info.length, 1, 0, 0));
	for (int i = 0; i < info.length; i++) {
	    panel.add(new JLabel(info[i]));
	}
	return panel;
    }

}
















