/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.snmp;

import com.sun.jdmk.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.snmp.SnmpOidRecord;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;

public class SnmpOidTableSupport
implements SnmpOidTable {
    String dbgTag = "SnmpOidTableSupport";
    private Hashtable oidStore = new Hashtable();
    private String myName;

    public SnmpOidTableSupport(String string) {
        this.myName = string;
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 64, string, string2, string3);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SnmpOidTableSupport)) {
            return false;
        }
        SnmpOidTableSupport snmpOidTableSupport = (SnmpOidTableSupport)object;
        return this.myName.equals(snmpOidTableSupport.getName());
    }

    public Vector getAllEntries() {
        Vector vector = new Vector();
        Enumeration enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public String getName() {
        return this.myName;
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 64);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 64);
    }

    public synchronized void loadMib(SnmpOidRecord[] snmpOidRecordArray) {
        try {
            int n = 0;
            while (true) {
                SnmpOidRecord snmpOidRecord = snmpOidRecordArray[n];
                if (this.isTraceOn()) {
                    this.trace("loadMib", "load " + snmpOidRecord.getName());
                }
                this.oidStore.put(snmpOidRecord.getName(), snmpOidRecord);
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
    }

    public SnmpOidRecord resolveVarName(String string) throws SnmpStatusException {
        SnmpOidRecord snmpOidRecord = (SnmpOidRecord)this.oidStore.get(string);
        if (snmpOidRecord != null) {
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable name <" + string + "> not found in Oid repository");
    }

    public SnmpOidRecord resolveVarOid(String string) throws SnmpStatusException {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
        }
        if (n == 0) {
            string = string.substring(1, string.length());
        }
        Enumeration enumeration = this.oidStore.elements();
        while (enumeration.hasMoreElements()) {
            SnmpOidRecord snmpOidRecord = (SnmpOidRecord)enumeration.nextElement();
            if (!snmpOidRecord.getOid().equals(string)) continue;
            return snmpOidRecord;
        }
        throw new SnmpStatusException("Variable oid <" + string + "> not found in Oid repository");
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 64, string, string2, string3);
    }
}

