/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.mbox;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.mbox.MBoxObj;
import com.sun.wbem.solarisprovider.usermgr.users.SolServicesAttr;
import java.io.File;

public class MboxWrapper {
    private static String DEFAULT_MAILBOX_DIRECTORY = "/var/mail/";
    private static String DEFAULT_MAILBOX_PERMISSIONS = "660";
    private static String DEFAULT_MAILBOX_GROUP = "mail";
    private static String NEW_USER_NAME = "newUserName";
    ProviderUtility provUtil = null;
    private String mvCommand = "/usr/bin/mv";
    private String lsCommand = "/usr/bin/ls";
    private String chownCommand = "/usr/bin/chown";
    private String chmodCommand = "/usr/bin/chmod";
    private String chgrpCommand = "/usr/bin/chgrp";
    private String cpCommand = "/usr/bin/cp";
    private String mkdirCommand = "/usr/bin/mkdir";
    private String touchCommand = "/usr/bin/touch";
    private String rmdirCommand = "/usr/bin/rm -r ";

    public MboxWrapper(ProviderUtility providerUtility) {
        this.provUtil = providerUtility;
    }

    public synchronized void createMailbox(MBoxObj mBoxObj) throws Exception {
        String string = new String("/var/mail/" + mBoxObj.getUserName());
        String string2 = "";
        File file = new File(string);
        if (file.exists()) {
            string2 = this.provUtil.writeLog(2, "LM_2043", "LM_2231", string, null, null, null);
            throw new UserException(string2);
        }
        try {
            this.performCreateMailbox(mBoxObj);
        }
        catch (Exception exception) {
            string2 = this.provUtil.writeLog(2, "LM_2043", "LM_2230", exception.getLocalizedMessage(), null, null, null);
            throw new UserException(string2);
        }
        this.provUtil.writeLog(0, "LM_2045", "LM_2089", mBoxObj.getUserName(), null, null, null);
    }

    public synchronized void deleteMBox(String string) throws Exception {
        String string2 = new String(String.valueOf(DEFAULT_MAILBOX_DIRECTORY) + string);
        String string3 = "";
        String string4 = new String(String.valueOf(this.rmdirCommand) + string2);
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(string4);
            process.getInputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception exception) {
            string3 = this.provUtil.writeLog(2, "LM_2068", "LM_2230", exception.getLocalizedMessage(), null, null, null);
            throw new UserException(string3);
        }
        this.provUtil.writeLog(0, "LM_2044", "LM_2301", string2, null, null, null);
    }

    public synchronized void modifyMailBox(MBoxObj mBoxObj, String string) throws Exception {
        String string2 = "";
        String string3 = new String(String.valueOf(SolServicesAttr.DEFAULT_MAILBOX_DIRECTORY) + mBoxObj.getUserName());
        File file = new File(string3);
        if (!file.exists()) {
            try {
                mBoxObj.setUserName(string);
                this.performCreateMailbox(mBoxObj);
                String[] stringArray = new String[]{mBoxObj.getUserName(), string3};
                this.provUtil.writeLog(0, "LM_2004", "LM_2087", mBoxObj.getUserName(), mBoxObj.getMailServer(), null, null);
                return;
            }
            catch (Exception exception) {
                string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2230", exception.getLocalizedMessage(), null, null, null);
                throw new UserException(string2);
            }
        }
        String string4 = new String(String.valueOf(SolServicesAttr.DEFAULT_MAILBOX_DIRECTORY) + string);
        String string5 = new String(String.valueOf(this.mvCommand) + " " + string3 + " " + string4);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(string5);
            process.getInputStream().close();
            process.getErrorStream().close();
        }
        catch (Exception exception) {
            string2 = this.provUtil.writeLog(2, "LM_2005", "LM_2230", exception.getLocalizedMessage(), null, null, null);
            throw new UserException(string2);
        }
        this.provUtil.writeLog(0, "LM_2004", "LM_2087", mBoxObj.getUserName(), mBoxObj.getMailServer(), null, null);
    }

    private void performCreateMailbox(MBoxObj mBoxObj) throws Exception {
        String string = new String(String.valueOf(DEFAULT_MAILBOX_DIRECTORY) + mBoxObj.getUserName());
        String string2 = new String(String.valueOf(this.touchCommand) + " " + string);
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(string2);
        process.getInputStream().close();
        process.getErrorStream().close();
        string2 = new String(String.valueOf(this.chmodCommand) + " " + DEFAULT_MAILBOX_PERMISSIONS + " " + string);
        process = runtime.exec(string2);
        process.getInputStream().close();
        process.getErrorStream().close();
        string2 = new String(String.valueOf(this.chownCommand) + " " + mBoxObj.getUserUID() + " " + string);
        process = runtime.exec(string2);
        process.getInputStream().close();
        process.getErrorStream().close();
        string2 = new String(String.valueOf(this.chgrpCommand) + " " + DEFAULT_MAILBOX_GROUP + " " + string);
        process = runtime.exec(string2);
        process.getInputStream().close();
        process.getErrorStream().close();
    }
}

