/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.common;

import com.sun.dhcpmgr.common.Importer;
import com.sun.dhcpmgr.common.ResourceStrings;
import com.sun.dhcpmgr.data.ActionError;
import com.sun.dhcpmgr.data.ExportHeader;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.server.DhcpMgr;
import java.io.IOException;
import java.text.MessageFormat;

public class ImportController {
    Importer importer;
    DhcpMgr server;
    String file;
    Object ref = null;
    ExportHeader header = null;
    private static final int OPTION_OPS = 1;
    private static final int MACRO_OPS = 5;
    private static final int NET_OPS = 150;

    public ImportController(Importer importer, DhcpMgr dhcpMgr) {
        this.importer = importer;
        this.server = dhcpMgr;
    }

    public void closeFile() {
        if (this.ref != null) {
            try {
                this.server.closeImportFile(this.ref, false);
            }
            catch (IOException iOException) {
                this.displayError(ResourceStrings.getString("imp_err_io"), iOException.getMessage());
            }
        }
        this.ref = null;
        this.header = null;
    }

    private void displayError(String string, String string2) {
        MessageFormat messageFormat = new MessageFormat(string);
        String[] stringArray = new String[]{string2};
        this.importer.displayError(messageFormat.format(stringArray));
    }

    public ExportHeader getHeader() throws ClassNotFoundException, IOException {
        if (this.header == null) {
            if (this.ref == null) {
                this.ref = this.server.openImportFile(this.file);
                if (this.ref == null) {
                    String[] stringArray = new String[]{this.server.getDhcpServiceMgr().getServerName(), this.server.getLockPath()};
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("lock_error"));
                    this.importer.displayError(messageFormat.format(stringArray));
                    return null;
                }
            }
            this.header = this.server.getExportHeader(this.ref);
        }
        return this.header;
    }

    public boolean importData(boolean bl) {
        int n;
        boolean bl2;
        block13: {
            bl2 = false;
            n = 0;
            try {
                try {
                    if (this.getHeader() == null) {
                        break block13;
                    }
                    int n2 = this.header.getRecCount();
                    n = 6 + 150 * (n2 - 2);
                    this.importer.initializeProgress(n);
                    int n3 = 0;
                    this.importer.updateProgress(n3, ResourceStrings.getString("importing_options"));
                    ActionError[] actionErrorArray = this.server.importOptions(this.ref, bl);
                    if (actionErrorArray.length > 0) {
                        this.importer.displayErrors(ResourceStrings.getString("imp_err_importing_options"), ResourceStrings.getString("imp_option"), actionErrorArray);
                    }
                    this.importer.updateProgress(++n3, ResourceStrings.getString("importing_macros"));
                    actionErrorArray = this.server.importMacros(this.ref, bl);
                    if (actionErrorArray.length > 0) {
                        this.importer.displayErrors(ResourceStrings.getString("imp_err_importing_macros"), ResourceStrings.getString("imp_macro"), actionErrorArray);
                    }
                    n3 += 5;
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("importing_network"));
                    String[] stringArray = new String[1];
                    Network[] networkArray = this.header.getNetworks();
                    int n4 = 0;
                    while (n4 < networkArray.length) {
                        stringArray[0] = networkArray[n4].toString();
                        this.importer.updateProgress(n3, messageFormat.format(stringArray));
                        actionErrorArray = this.server.importNetwork(networkArray[n4], this.ref, bl);
                        if (actionErrorArray.length > 0) {
                            MessageFormat messageFormat2 = new MessageFormat(ResourceStrings.getString("imp_err_importing_net"));
                            this.importer.displayErrors(messageFormat2.format(stringArray), ResourceStrings.getString("imp_address"), actionErrorArray);
                        }
                        n3 += 150;
                        ++n4;
                    }
                    bl2 = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.displayError(ResourceStrings.getString("imp_err_file_fmt"), classNotFoundException.getMessage());
                }
                catch (Exception exception) {
                    this.displayError(ResourceStrings.getString("imp_err_io"), exception.getMessage());
                }
            }
            catch (Throwable throwable) {}
        }
        try {
            this.importer.updateProgress(n, ResourceStrings.getString("import_completed"));
        }
        catch (InterruptedException interruptedException) {}
        this.closeFile();
        return bl2;
    }

    public void setFile(String string) {
        this.closeFile();
        this.file = string;
    }
}

