/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhcpconfig;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.DhcpCfgFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.IPAddressList;
import com.sun.dhcpmgr.common.ExportController;
import com.sun.dhcpmgr.common.Exporter;
import com.sun.dhcpmgr.data.ActionError;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.ValidationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ExportData
extends DhcpCfgFunction
implements Exporter {
    private static final int[] supportedOptions = new int[]{109, 111, 97, 120, 102};
    private static final String ALL = "ALL";
    private String exportFile;

    public ExportData(String string) {
        this.validOptions = supportedOptions;
        this.exportFile = string;
    }

    private String[] argsToArray(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    public void displayError(String string) {
        Object[] objectArray = new Object[]{string};
        this.printErrMessage(this.getString("export_err_message"), objectArray);
    }

    public void displayErrors(String string, String string2, ActionError[] actionErrorArray) {
        this.printErrMessage(string);
        Object[] objectArray = new Object[3];
        objectArray[0] = string2;
        MessageFormat messageFormat = new MessageFormat(this.getString("export_action_error"));
        int n = 0;
        while (n < actionErrorArray.length) {
            objectArray[1] = actionErrorArray[n].getName();
            objectArray[2] = actionErrorArray[n].getException().getMessage();
            this.printErrMessage(messageFormat.format(objectArray));
            ++n;
        }
    }

    public int execute() {
        Object object;
        if (!this.isServerConfigured()) {
            return -1;
        }
        if (!this.isVersionValid(false)) {
            return -1;
        }
        boolean bl = this.options.isSet(102);
        boolean bl2 = this.options.isSet(120);
        ExportController exportController = new ExportController((Exporter)this, DhcpCliFunction.getDhcpMgr());
        exportController.setFile(this.exportFile);
        exportController.setUser(System.getProperty("user.name"));
        if (this.options.isSet(109)) {
            object = this.options.valueOf(109);
            if (ALL.equals(object)) {
                exportController.setAllMacros();
            } else {
                exportController.setMacros(this.argsToArray((String)object));
            }
        }
        if (this.options.isSet(111)) {
            object = this.options.valueOf(111);
            if (ALL.equals(object)) {
                exportController.setAllOptions();
            } else {
                exportController.setOptions(this.argsToArray((String)object));
            }
        }
        if (this.options.isSet(97)) {
            object = this.options.valueOf(97);
            if (ALL.equals(object)) {
                exportController.setAllNetworks();
            } else {
                IPAddressList iPAddressList;
                try {
                    iPAddressList = new IPAddressList((String)object);
                }
                catch (ValidationException validationException) {
                    this.printErrMessage(DhcpCliFunction.getMessage(validationException));
                    this.printErrMessage(this.getString("export_abort"));
                    return -1;
                }
                ArrayList<Network> arrayList = new ArrayList<Network>();
                try {
                    Network[] networkArray = DhcpCliFunction.getNetMgr().getNetworks();
                    int n = 0;
                    while (!iPAddressList.isEmpty() && n < networkArray.length) {
                        int n2 = iPAddressList.indexOf(networkArray[n].getNetworkNumber());
                        if (n2 != -1) {
                            arrayList.add(networkArray[n]);
                            iPAddressList.remove(n2);
                        }
                        ++n;
                    }
                }
                catch (BridgeException bridgeException) {
                    bridgeException.printStackTrace();
                }
                if (!iPAddressList.isEmpty()) {
                    System.err.print(iPAddressList.firstElement());
                    System.err.println(" is not a valid network");
                    return -1;
                }
                exportController.setNetworks(arrayList.toArray(new Network[0]));
            }
        }
        try {
            if (!exportController.exportData(bl2, bl)) {
                return -1;
            }
        }
        catch (ExistsException existsException) {
            object = new Object[]{this.exportFile};
            this.printErrMessage(this.getString("export_file_exist_error"), (Object[])object);
            this.printErrMessage(this.getString("export_abort"));
            return -1;
        }
        return 0;
    }

    public void initializeProgress(int n) {
    }

    public void updateProgress(int n, String string) {
        this.printMessage(string);
    }
}

