/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhcpconfig;

import com.sun.dhcpmgr.cli.dhcpconfig.ResourceStrings;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.ValidationException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class IPAddressList
extends Vector {
    public IPAddressList(String string) throws ValidationException {
        this.removeAllElements();
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                this.addElement(new IPAddress(string2.trim()));
            }
            catch (ValidationException validationException) {
                Object[] objectArray = new Object[]{string2};
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_ip_address"));
                throw new ValidationException(messageFormat.format(objectArray));
            }
        }
    }

    public IPAddressList(IPAddress[] iPAddressArray) {
        this.removeAllElements();
        if (iPAddressArray == null) {
            return;
        }
        int n = 0;
        while (n < iPAddressArray.length) {
            this.addElement(iPAddressArray[n]);
            ++n;
        }
    }

    public IPAddress[] toIPAddressArray() {
        return this.toArray(new IPAddress[this.size()]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(((IPAddress)enumeration.nextElement()).getHostAddress());
        }
        return stringBuffer.toString();
    }
}

