/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.pntadm;

import com.sun.dhcpmgr.bridge.NoTableException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.common.Format;
import com.sun.dhcpmgr.cli.pntadm.PntAdmFunction;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.Network;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DisplayNetworkTable
extends PntAdmFunction {
    static final int[] supportedOptions = new int[]{118, 120, 114, 117, 112};

    public DisplayNetworkTable() {
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        Network network;
        int n = 0;
        boolean bl = false;
        if (this.options.isSet(118)) {
            bl = true;
        }
        boolean bl2 = false;
        if (this.options.isSet(120)) {
            bl2 = true;
        }
        if (bl && bl2) {
            String string = this.getString("display_mode_error");
            throw new IllegalArgumentException(string);
        }
        DhcpClientRecord[] dhcpClientRecordArray = null;
        try {
            network = DhcpCliFunction.getNetMgr().getNetwork(this.networkName);
            if (network == null) {
                this.printErrMessage(this.getString("network_name_error"));
                return 3;
            }
            dhcpClientRecordArray = DhcpCliFunction.getNetMgr().loadNetwork(network.toString(), this.getDhcpDatastore());
        }
        catch (NoTableException noTableException) {
            this.printErrMessage(DhcpCliFunction.getMessage(noTableException));
            return 2;
        }
        catch (Throwable throwable) {
            this.printErrMessage(DhcpCliFunction.getMessage(throwable));
            return 3;
        }
        Format.print(System.out, "%-8s\t", this.getString("Client_ID"));
        Format.print(System.out, "%-4s\t", this.getString("Flags"));
        Format.print(System.out, "%-8s\t", this.getString("Client_IP"));
        Format.print(System.out, "%-8s\t", this.getString("Server_IP"));
        Format.print(System.out, "%-25s\t", this.getString("Lease_Expiration"));
        Format.print(System.out, "%-8s\t", this.getString("Macro"));
        Format.print(System.out, "%s\n\n", this.getString("Comment"));
        int n2 = 0;
        while (dhcpClientRecordArray != null && n2 < dhcpClientRecordArray.length) {
            String string;
            network = dhcpClientRecordArray[n2];
            Format.print(System.out, "%-8s\t", network.getClientId());
            Format.print(System.out, "%-4s\t", network.getFlagString(bl));
            String string2 = bl ? network.getClientIP().getHostName() : network.getClientIP().toString();
            Format.print(System.out, "%-8s\t", string2);
            String string3 = bl ? network.getServerIP().getHostName() : network.getServerIP().toString();
            Format.print(System.out, "%-8s\t", string3);
            Date date = network.getExpiration();
            if (!(bl2 || date != null && date.getTime() != 0L)) {
                string = this.getString("Zero");
            } else if (!bl2 && date.getTime() < 0L) {
                string = this.getString("Forever");
            } else if (bl) {
                string = date.toString();
            } else if (bl2) {
                string = Long.toString(date.getTime() / 1000L);
            } else {
                String string4 = this.getString("expiration_format");
                string = new SimpleDateFormat(string4).format(date);
            }
            Format.print(System.out, "%-25s\t", string);
            Format.print(System.out, "%-8s\t", network.getMacro());
            Format.print(System.out, "%s\n", network.getComment());
            ++n2;
        }
        return n;
    }
}

