/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.dhcpconfig;

import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.cli.common.Console;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.dhcpconfig.DhcpCfgFunction;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.Network;

public class ConvertDataStore
extends DhcpCfgFunction {
    static final int[] supportedOptions = new int[]{102, 107, 114, 117, 112};

    public ConvertDataStore() {
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        block34: {
            Object[] objectArray;
            Object object;
            Object[] objectArray2;
            Object[] objectArray3;
            if (this.options.valueOf(114) == null || this.options.valueOf(112) == null) {
                String string = this.getString("convert_null_datastore_error");
                throw new IllegalArgumentException(string);
            }
            try {
                this.setDhcpDatastore(DhcpCliFunction.getSvcMgr().getDataStore(this.options.valueOf(114)));
                this.getDhcpDatastore().setLocation(this.options.valueOf(112));
                this.getDhcpDatastore().setConfig(this.options.valueOf(117));
            }
            catch (Throwable throwable) {}
            if (this.getDhcpDatastore() == null || !this.getDhcpDatastore().isEnabled()) {
                Object[] objectArray4 = new Object[]{this.getDhcpDatastore().getResource()};
                this.printErrMessage(this.getString("convert_invalid_resource_error"), objectArray4);
                return -1;
            }
            boolean bl = this.options.isSet(107) ^ true;
            DhcpdOptions dhcpdOptions = null;
            try {
                dhcpdOptions = DhcpCliFunction.getSvcMgr().readDefaults();
            }
            catch (Throwable throwable) {
                Object[] objectArray5 = new Object[]{DhcpCliFunction.getMessage(throwable)};
                this.printErrMessage(this.getString("convert_conf_read_error"), objectArray5);
                return -1;
            }
            DhcpDatastore dhcpDatastore = dhcpdOptions.getDhcpDatastore();
            if (this.getDhcpDatastore().equals((Object)dhcpDatastore)) {
                this.printErrMessage(this.getString("convert_same_datastore_error"));
                return -1;
            }
            if (!this.options.isSet(102)) {
                this.printMessage(this.getString("convert_explanation"));
                objectArray3 = this.getString("convert_confirmation");
                objectArray2 = this.getString("affirmative");
                object = this.getString("negative");
                boolean bl2 = Console.promptUser((String)objectArray3, (String)objectArray2, (String)object, true);
                if (!bl2) {
                    return -1;
                }
            }
            try {
                DhcpCliFunction.getSvcMgr().makeLocation(this.getDhcpDatastore());
            }
            catch (ExistsException existsException) {
            }
            catch (Throwable throwable) {
                objectArray3 = new Object[]{this.getDhcpDatastore().getLocation()};
                this.printErrMessage(this.getString("convert_make_location_error"), objectArray3);
                return -1;
            }
            try {
                if (DhcpCliFunction.getSvcMgr().isServerRunning()) {
                    DhcpCliFunction.getSvcMgr().shutdown();
                    this.printMessage(this.getString("convert_shutdown_progress"));
                } else {
                    this.printMessage(this.getString("convert_no_shutdown_progress"));
                }
            }
            catch (Throwable throwable) {
                objectArray2 = new Object[]{DhcpCliFunction.getMessage(throwable)};
                this.printErrMessage(this.getString("convert_shutdown_error"), objectArray2);
            }
            try {
                DhcpCliFunction.getDhcptabMgr().cvtDhcptab(this.getDhcpDatastore());
                this.printMessage(this.getString("convert_dhcptab_progress"));
            }
            catch (Throwable throwable) {
                objectArray2 = new Object[]{DhcpCliFunction.getMessage(throwable)};
                this.printErrMessage(this.getString("convert_dhcptab_error"), objectArray2);
                bl = false;
            }
            objectArray3 = new Network[]{};
            try {
                objectArray3 = DhcpCliFunction.getNetMgr().getNetworks(dhcpDatastore);
                if (objectArray3 == null) {
                    objectArray3 = new Network[]{};
                }
            }
            catch (Throwable throwable) {
                object = new Object[]{DhcpCliFunction.getMessage(throwable)};
                this.printErrMessage(this.getString("convert_get_nets_error"), (Object[])object);
                bl = false;
            }
            int n = 0;
            while (n < objectArray3.length) {
                object = objectArray3[n].toString();
                try {
                    DhcpCliFunction.getNetMgr().cvtNetwork((String)object, this.getDhcpDatastore());
                    Object[] objectArray6 = new Object[]{object};
                    this.printMessage(this.getString("convert_network_progress"), objectArray6);
                }
                catch (Throwable throwable) {
                    objectArray = new Object[]{object, DhcpCliFunction.getMessage(throwable)};
                    this.printErrMessage(this.getString("convert_network_error"), objectArray);
                }
                ++n;
            }
            dhcpdOptions.setDhcpDatastore(this.getDhcpDatastore());
            try {
                DhcpCliFunction.getSvcMgr().writeDefaults(dhcpdOptions);
                this.printMessage(this.getString("convert_conf_update_progress"));
            }
            catch (Throwable throwable) {
                Object[] objectArray7 = new Object[]{DhcpCliFunction.getMessage(throwable)};
                this.printErrMessage(this.getString("convert_conf_write_error"), objectArray7);
                bl = false;
            }
            if (bl) {
                int n2 = 0;
                while (n2 < objectArray3.length) {
                    String string = objectArray3[n2].toString();
                    try {
                        DhcpCliFunction.getNetMgr().deleteNetwork(string, false, false, dhcpDatastore);
                        objectArray = new Object[]{string};
                        this.printMessage(this.getString("convert_delete_network_progress"), objectArray);
                    }
                    catch (Throwable throwable) {
                        Object[] objectArray8 = new Object[]{string, DhcpCliFunction.getMessage(throwable)};
                        this.printErrMessage(this.getString("convert_delete_network_error"), objectArray8);
                    }
                    ++n2;
                }
                try {
                    DhcpCliFunction.getDhcptabMgr().deleteDhcptab(dhcpDatastore);
                    this.printMessage(this.getString("convert_delete_dhcptab_progress"));
                }
                catch (Throwable throwable) {
                    objectArray = new Object[]{DhcpCliFunction.getMessage(throwable)};
                    this.printErrMessage(this.getString("convert_delete_dhcptab_error"), objectArray);
                }
            }
            if (!dhcpdOptions.isDaemonEnabled()) break block34;
            try {
                DhcpCliFunction.getSvcMgr().startup();
                this.printMessage(this.getString("convert_startup_progress"));
            }
            catch (Throwable throwable) {
                Object[] objectArray9 = new Object[]{DhcpCliFunction.getMessage(throwable)};
                this.printErrMessage(this.getString("convert_startup_error"), objectArray9);
            }
        }
        return 0;
    }
}

