/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class FieldLayout
implements LayoutManager {
    public static final String LABEL = "Label";
    public static final String LABELTOP = "LabelTop";
    public static final String FIELD = "Field";
    Vector rows;
    int hgap;
    int vgap;

    public FieldLayout() {
        this(5, 5);
    }

    public FieldLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
        this.rows = new Vector();
    }

    public void addLayoutComponent(String string, Component component) {
        if (LABEL.equals(string)) {
            Row row = new Row();
            row.label = component;
            row.center = true;
            this.rows.addElement(row);
        } else if (LABELTOP.equals(string)) {
            Row row = new Row();
            row.label = component;
            row.center = false;
            this.rows.addElement(row);
        } else if (FIELD.equals(string)) {
            ((Row)this.rows.lastElement()).field = component;
        }
    }

    public void layoutContainer(Container container) {
        Serializable serializable;
        Row row;
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = 0;
        int n2 = insets.top;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Dimension dimension2 = this.preferredLayoutSize(container);
        boolean bl = true;
        if (dimension2.height > dimension.height - insets.top - insets.bottom || dimension2.width > dimension.width - insets.left - insets.right) {
            bl = false;
            dimension2 = this.minimumLayoutSize(container);
            n5 = dimension.height - insets.top - insets.bottom - dimension2.height;
            if (n5 < 0) {
                n5 = 0;
            }
        }
        double d = 0.0;
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            row = (Row)enumeration.nextElement();
            if (!row.label.isVisible() || !row.field.isVisible()) continue;
            serializable = bl ? row.label.getPreferredSize() : row.label.getMinimumSize();
            n4 = Math.max(n4, ((Dimension)serializable).width);
            if (!bl) {
                double d2 = row.label.getPreferredSize().getHeight() / row.label.getMinimumSize().getHeight();
                double d3 = row.field.getPreferredSize().getHeight() / row.field.getMinimumSize().getHeight();
                row.yRatio = Math.max(d2, d3);
            }
            if (row.yRatio == 1.0) {
                row.yRatio = 0.0;
            }
            d += row.yRatio;
        }
        enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            row = (Row)enumeration.nextElement();
            serializable = row.label;
            Component component = row.field;
            if (!((Component)serializable).isVisible() || !component.isVisible()) continue;
            Dimension dimension3 = bl ? ((Component)serializable).getPreferredSize() : ((Component)serializable).getMinimumSize();
            Dimension dimension4 = bl ? component.getPreferredSize() : component.getMinimumSize();
            int n6 = Math.max(dimension3.height, dimension4.height) + (int)((double)n5 * row.yRatio / d);
            n = insets.left;
            n += Math.max(n4 - dimension3.width, 0);
            n3 = 0;
            if (row.center) {
                n3 = Math.max(0, (n6 - dimension3.height) / 2);
            }
            int n7 = n6;
            if (((Component)serializable).getPreferredSize().height == ((Component)serializable).getMinimumSize().height) {
                n7 = dimension3.height;
            }
            ((Component)serializable).setBounds(n, n2 + n3, dimension3.width, n7);
            n = insets.left + n4 + this.hgap;
            int n8 = dimension.width - n - this.hgap;
            component.setBounds(n, n2, n8, n6);
            n2 += n6 + this.vgap;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Object object;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            object = (Row)enumeration.nextElement();
            if (!((Row)object).label.isVisible() || !((Row)object).field.isVisible()) continue;
            Dimension dimension2 = ((Row)object).label.getMinimumSize();
            n = Math.max(n, dimension2.width);
            Dimension dimension3 = ((Row)object).field.getMinimumSize();
            n2 = Math.max(n2, dimension3.width);
            dimension.height += Math.max(dimension2.height, dimension3.height) + this.vgap;
        }
        dimension.width = n + this.hgap + n2;
        object = container.getInsets();
        dimension.width += ((Insets)object).left + ((Insets)object).right + this.hgap * 2;
        dimension.height += ((Insets)object).top + ((Insets)object).bottom + this.vgap;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Object object;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            object = (Row)enumeration.nextElement();
            if (!((Row)object).label.isVisible() || !((Row)object).field.isVisible()) continue;
            Dimension dimension2 = ((Row)object).label.getPreferredSize();
            n = Math.max(n, dimension2.width);
            Dimension dimension3 = ((Row)object).field.getPreferredSize();
            n2 = Math.max(n2, dimension3.width);
            dimension.height += Math.max(dimension2.height, dimension3.height) + this.vgap;
        }
        dimension.width = n + this.hgap + n2;
        object = container.getInsets();
        dimension.width += ((Insets)object).left + ((Insets)object).right + this.hgap * 2;
        dimension.height += ((Insets)object).top + ((Insets)object).bottom + this.vgap;
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
        Enumeration enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            Row row = (Row)enumeration.nextElement();
            if (component != row.label && component != row.field) continue;
            this.rows.removeElement(row);
            return;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    class Row {
        Component label = null;
        Component field = null;
        double yRatio = 1.0;
        boolean center = true;
    }
}

