/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.cli.pntadm;

import com.sun.dhcpmgr.bridge.TableExistsException;
import com.sun.dhcpmgr.cli.common.DhcpCliFunction;
import com.sun.dhcpmgr.cli.pntadm.PntAdmFunction;
import com.sun.dhcpmgr.data.Network;

public class CreateNetworkTable
extends PntAdmFunction {
    static final int[] supportedOptions = new int[]{114, 117, 112};

    public CreateNetworkTable() {
        this.validOptions = supportedOptions;
    }

    public int execute() throws IllegalArgumentException {
        int n = 0;
        try {
            Network network = DhcpCliFunction.getNetMgr().getNetwork(this.networkName);
            if (network == null) {
                this.printErrMessage(this.getString("network_name_error"));
                return 3;
            }
            DhcpCliFunction.getNetMgr().createNetwork(network.toString(), this.getDhcpDatastore());
        }
        catch (TableExistsException tableExistsException) {
            this.printErrMessage(DhcpCliFunction.getMessage(tableExistsException));
            n = 1;
        }
        catch (Throwable throwable) {
            this.printErrMessage(DhcpCliFunction.getMessage(throwable));
            n = 3;
        }
        return n;
    }
}

