/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IntegerField
extends JTextField {
    public IntegerField() {
        this("");
    }

    public IntegerField(int n) {
        this();
        this.setValue(n);
    }

    public IntegerField(Integer n) {
        this();
        this.setValue(n);
    }

    public IntegerField(String string) {
        this(string, 5);
    }

    public IntegerField(String string, int n) {
        super(string, n);
        this.setHorizontalAlignment(4);
    }

    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    public int getValue() {
        String string = this.getText();
        if (string == null || string.length() == 0) {
            return 0;
        }
        return Integer.parseInt(this.getText());
    }

    public void setValue(int n) {
        this.setText(String.valueOf(n));
    }

    public void setValue(Integer n) {
        if (n != null) {
            this.setValue((int)n);
        }
    }

    static class IntegerDocument
    extends PlainDocument {
        IntegerDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null) {
                char[] cArray = string.toCharArray();
                int n2 = 0;
                while (n2 < cArray.length) {
                    if (!Character.isDigit(cArray[n2])) {
                        throw new BadLocationException("", n);
                    }
                    ++n2;
                }
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

