/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import com.sun.dhcpmgr.ui.ALIGNMENT;
import com.sun.dhcpmgr.ui.ButtonLayout;
import com.sun.dhcpmgr.ui.ButtonPanelListener;
import com.sun.dhcpmgr.ui.ResourceStrings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    JButton okButton;
    JButton resetButton;
    JButton cancelButton;
    JButton helpButton;
    ButtonAdaptor adaptor;
    Vector listeners;

    public ButtonPanel(boolean bl) {
        this(bl, true);
    }

    public ButtonPanel(boolean bl, boolean bl2) {
        this.setLayout(new ButtonLayout(ALIGNMENT.RIGHT));
        this.adaptor = new ButtonAdaptor();
        this.listeners = new Vector();
        this.okButton = new JButton(ResourceStrings.getString("ok_button"));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(this.adaptor);
        this.add(this.okButton);
        if (bl) {
            this.resetButton = new JButton(ResourceStrings.getString("reset_button"));
            this.resetButton.addActionListener(this.adaptor);
            this.add(this.resetButton);
        } else {
            this.resetButton = null;
        }
        this.cancelButton = new JButton(ResourceStrings.getString("cancel_button"));
        this.cancelButton.addActionListener(this.adaptor);
        this.add(this.cancelButton);
        if (bl2) {
            this.helpButton = new JButton(ResourceStrings.getString("help_button"));
            this.helpButton.addActionListener(this.adaptor);
            this.add(this.helpButton);
        } else {
            this.helpButton = null;
        }
    }

    public void addButtonPanelListener(ButtonPanelListener buttonPanelListener) {
        this.listeners.addElement(buttonPanelListener);
    }

    public boolean isOkEnabled() {
        return this.okButton.isEnabled();
    }

    public void removeButtonPanelListener(ButtonPanelListener buttonPanelListener) {
        this.listeners.removeElement(buttonPanelListener);
    }

    public void setOkEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    class ButtonAdaptor
    implements ActionListener {
        ButtonAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            Object object = actionEvent.getSource();
            if (object == ButtonPanel.this.okButton) {
                n = 0;
            } else if (object == ButtonPanel.this.resetButton) {
                n = 3;
            } else if (object == ButtonPanel.this.cancelButton) {
                n = 1;
            } else if (object == ButtonPanel.this.helpButton) {
                n = 2;
            }
            Enumeration enumeration = ButtonPanel.this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ButtonPanelListener buttonPanelListener = (ButtonPanelListener)enumeration.nextElement();
                buttonPanelListener.buttonPressed(n);
            }
        }
    }
}

