/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.NotRunningException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.OptionNameField;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionContext;
import com.sun.dhcpmgr.data.OptionType;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.server.DhcptabMgr;
import com.sun.dhcpmgr.ui.ButtonPanel;
import com.sun.dhcpmgr.ui.ButtonPanelListener;
import com.sun.dhcpmgr.ui.DownButton;
import com.sun.dhcpmgr.ui.IntegerField;
import com.sun.dhcpmgr.ui.UpButton;
import com.sun.dhcpmgr.ui.VerticalButtonLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CreateOptionDialog
extends JDialog
implements ButtonPanelListener {
    public static final int CREATE = 0;
    public static final int EDIT = 1;
    public static final int DUPLICATE = 2;
    private int mode = 0;
    private OptionNameField name;
    private JComboBox category;
    private IntegerField code;
    private JComboBox type;
    private JList classList;
    private JTextField clientClass;
    private IntegerField granularity;
    private IntegerField maximum;
    private JCheckBox signalBox;
    private Vector listeners;
    private Option option;
    private Option originalOption;
    private ButtonPanel buttonPanel;
    private ClassListModel classListModel;
    private JButton add;
    private JButton delete;
    private UpButton moveUp;
    private DownButton moveDown;
    private OptionContext[] categories = new OptionContext[]{Option.ctxts[Option.EXTEND], Option.ctxts[Option.VENDOR], Option.ctxts[Option.SITE]};

    public CreateOptionDialog(Frame frame, int n) {
        super(frame);
        this.setLocationRelativeTo(frame);
        this.listeners = new Vector();
        this.mode = n;
        switch (n) {
            case 0: {
                this.setTitle(ResourceStrings.getString("create_option_title"));
                break;
            }
            case 1: {
                this.setTitle(ResourceStrings.getString("edit_option_title"));
                break;
            }
            case 2: {
                this.setTitle(ResourceStrings.getString("duplicate_option_title"));
                break;
            }
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(ResourceStrings.getString("name_label"), 4);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.name = new OptionNameField("");
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        jPanel2.add(this.name);
        jLabel = new JLabel(ResourceStrings.getString("category_label"), 4);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.category = new JComboBox<OptionContext>(this.categories);
        this.category.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.category, gridBagConstraints);
        jPanel2.add(this.category);
        jLabel = new JLabel(ResourceStrings.getString("option_code_label"), 4);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.code = new IntegerField();
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.code, gridBagConstraints);
        jPanel2.add(this.code);
        jLabel = new JLabel(ResourceStrings.getString("data_type_label"), 4);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.type = new JComboBox<OptionType>(Option.types);
        this.type.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.type, gridBagConstraints);
        jPanel2.add(this.type);
        JLabel jLabel2 = new JLabel(ResourceStrings.getString("granularity_label"), 4);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        this.granularity = new IntegerField(5);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.granularity, gridBagConstraints);
        jPanel2.add(this.granularity);
        JLabel jLabel3 = new JLabel(ResourceStrings.getString("maximum_label"), 4);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        this.maximum = new IntegerField(5);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.maximum, gridBagConstraints);
        jPanel2.add(this.maximum);
        jPanel.add((Component)jPanel2, "West");
        gridBagLayout = new GridBagLayout();
        JPanel jPanel3 = new JPanel(gridBagLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ResourceStrings.getString("client_classes_label"));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        this.clientClass = new JTextField("", 20);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.clientClass, gridBagConstraints);
        jPanel3.add(this.clientClass);
        this.add = new JButton(ResourceStrings.getString("add"));
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(this.add, gridBagConstraints);
        jPanel3.add(this.add);
        this.classListModel = new ClassListModel();
        this.classList = new JList(this.classListModel);
        this.classList.setPrototypeCellValue("abcdefghijklmnopqrst");
        this.classList.setSelectionMode(2);
        JScrollPane jScrollPane = new JScrollPane(this.classList);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel(new VerticalButtonLayout());
        this.moveUp = new UpButton();
        jPanel4.add(this.moveUp);
        this.moveDown = new DownButton();
        jPanel4.add(this.moveDown);
        this.delete = new JButton(ResourceStrings.getString("delete"));
        jPanel4.add(this.delete);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.5;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel3.add(jPanel4);
        this.add.setEnabled(false);
        this.delete.setEnabled(false);
        this.moveUp.setEnabled(false);
        this.moveDown.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == CreateOptionDialog.this.add || actionEvent.getSource() == CreateOptionDialog.this.clientClass) {
                    try {
                        CreateOptionDialog.this.classListModel.addElement(CreateOptionDialog.this.clientClass.getText());
                    }
                    catch (ValidationException validationException) {
                        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_client_class"));
                        Object[] objectArray = new Object[]{CreateOptionDialog.this.clientClass.getText()};
                        JOptionPane.showMessageDialog(CreateOptionDialog.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                        return;
                    }
                } else if (actionEvent.getSource() == CreateOptionDialog.this.delete) {
                    int n;
                    int[] nArray = CreateOptionDialog.this.classList.getSelectedIndices();
                    if (nArray.length > 1) {
                        n = 0;
                        while (n < nArray.length) {
                            int n2 = n;
                            while (n2 < nArray.length) {
                                if (nArray[n] > nArray[n2]) {
                                    int n3 = nArray[n];
                                    nArray[n] = nArray[n2];
                                    nArray[n2] = n3;
                                }
                                ++n2;
                            }
                            ++n;
                        }
                    }
                    n = nArray.length - 1;
                    while (n >= 0) {
                        CreateOptionDialog.this.classListModel.removeElementAt(nArray[n]);
                        --n;
                    }
                    if (nArray.length > 1) {
                        CreateOptionDialog.this.classList.clearSelection();
                        CreateOptionDialog.this.delete.setEnabled(false);
                    } else if (CreateOptionDialog.this.classListModel.getSize() == 0) {
                        CreateOptionDialog.this.delete.setEnabled(false);
                    } else if (nArray[0] >= CreateOptionDialog.this.classListModel.getSize()) {
                        CreateOptionDialog.this.classList.setSelectedIndex(CreateOptionDialog.this.classListModel.getSize() - 1);
                    } else {
                        CreateOptionDialog.this.classList.setSelectedIndex(nArray[0]);
                    }
                } else if (actionEvent.getSource() == CreateOptionDialog.this.moveUp) {
                    int n = CreateOptionDialog.this.classList.getSelectedIndex();
                    CreateOptionDialog.this.classListModel.moveUp(n);
                    CreateOptionDialog.this.classList.setSelectedIndex(n - 1);
                } else if (actionEvent.getSource() == CreateOptionDialog.this.moveDown) {
                    int n = CreateOptionDialog.this.classList.getSelectedIndex();
                    CreateOptionDialog.this.classListModel.moveDown(n);
                    CreateOptionDialog.this.classList.setSelectedIndex(n + 1);
                }
            }
        };
        this.clientClass.addActionListener(actionListener);
        this.add.addActionListener(actionListener);
        this.delete.addActionListener(actionListener);
        this.moveUp.addActionListener(actionListener);
        this.moveDown.addActionListener(actionListener);
        this.classList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = CreateOptionDialog.this.classList.getSelectedIndices();
                switch (nArray.length) {
                    case 0: {
                        CreateOptionDialog.this.delete.setEnabled(false);
                        CreateOptionDialog.this.moveUp.setEnabled(false);
                        CreateOptionDialog.this.moveDown.setEnabled(false);
                        break;
                    }
                    case 1: {
                        CreateOptionDialog.this.delete.setEnabled(true);
                        CreateOptionDialog.this.moveUp.setEnabled(nArray[0] != 0);
                        if (nArray[0] == CreateOptionDialog.this.classListModel.getSize() - 1) {
                            CreateOptionDialog.this.moveDown.setEnabled(false);
                            break;
                        }
                        CreateOptionDialog.this.moveDown.setEnabled(true);
                        break;
                    }
                    default: {
                        CreateOptionDialog.this.delete.setEnabled(true);
                        CreateOptionDialog.this.moveUp.setEnabled(false);
                        CreateOptionDialog.this.moveDown.setEnabled(false);
                    }
                }
            }
        });
        this.clientClass.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateOptionDialog.this.add.setEnabled(CreateOptionDialog.this.clientClass.getText().length() != 0);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        jPanel.add((Component)jPanel3, "Center");
        this.signalBox = new JCheckBox(ResourceStrings.getString("signal_server"), true);
        this.signalBox.setHorizontalAlignment(0);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.signalBox);
        jPanel.add((Component)jPanel5, "South");
        this.getContentPane().add(jPanel);
        this.getContentPane().add(new JSeparator());
        this.buttonPanel = new ButtonPanel(true);
        this.buttonPanel.addButtonPanelListener(this);
        this.getContentPane().add(this.buttonPanel);
        this.setOption(new Option());
        if (n == 1) {
            this.buttonPanel.setOkEnabled(true);
        }
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateOptionDialog.this.buttonPanel.setOkEnabled(documentEvent.getDocument().getLength() != 0);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        this.category.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl;
                OptionContext optionContext = CreateOptionDialog.this.categories[CreateOptionDialog.this.category.getSelectedIndex()];
                boolean bl2 = bl = optionContext.getCode() == Option.ctxts[Option.VENDOR].getCode();
                if (!bl) {
                    CreateOptionDialog.this.option.clearVendors();
                    CreateOptionDialog.this.clientClass.setText("");
                }
                CreateOptionDialog.this.clientClass.setEnabled(bl);
                CreateOptionDialog.this.classList.setEnabled(bl);
            }
        });
        this.type.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OptionType optionType = Option.types[CreateOptionDialog.this.type.getSelectedIndex()];
                byte by = optionType.getCode();
                if (by == Option.types[Option.ASCII].getCode() || by == Option.types[Option.OCTET].getCode()) {
                    CreateOptionDialog.this.granularity.setText("1");
                    CreateOptionDialog.this.granularity.setEditable(false);
                    CreateOptionDialog.this.maximum.setEditable(true);
                } else if (by == Option.types[Option.BOOLEAN].getCode()) {
                    CreateOptionDialog.this.granularity.setText("0");
                    CreateOptionDialog.this.granularity.setEditable(false);
                    CreateOptionDialog.this.maximum.setText("0");
                    CreateOptionDialog.this.maximum.setEditable(false);
                } else if (by == Option.types[Option.NUMBER].getCode() || by == Option.types[Option.UNUMBER8].getCode() || by == Option.types[Option.UNUMBER16].getCode() || by == Option.types[Option.UNUMBER32].getCode() || by == Option.types[Option.UNUMBER64].getCode() || by == Option.types[Option.SNUMBER8].getCode() || by == Option.types[Option.SNUMBER16].getCode() || by == Option.types[Option.SNUMBER32].getCode() || by == Option.types[Option.SNUMBER64].getCode() || by == Option.types[Option.IP].getCode()) {
                    CreateOptionDialog.this.granularity.setEditable(true);
                    CreateOptionDialog.this.maximum.setEditable(true);
                }
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                try {
                    OptionContext optionContext = this.categories[this.category.getSelectedIndex()];
                    OptionType optionType = Option.types[this.type.getSelectedIndex()];
                    this.option.setKey(this.name.getText());
                    this.option.setContext(optionContext.getCode());
                    this.option.setCode((short)this.code.getValue());
                    this.option.setType(optionType.getCode());
                    this.option.setGranularity(this.granularity.getValue());
                    this.option.setMaximum(this.maximum.getValue());
                    if (optionContext.getCode() == Option.ctxts[Option.VENDOR].getCode() && this.option.getVendorCount() == 0) {
                        JOptionPane.showMessageDialog(this, ResourceStrings.getString("empty_vendor_error"), ResourceStrings.getString("server_error_title"), 0);
                        return;
                    }
                    DhcptabMgr dhcptabMgr = DataManager.get().getDhcptabMgr();
                    if (this.mode == 0 || this.mode == 2) {
                        dhcptabMgr.createRecord((DhcptabRecord)this.option, this.signalBox.isSelected());
                    } else if (this.mode == 1) {
                        dhcptabMgr.modifyRecord((DhcptabRecord)this.originalOption, (DhcptabRecord)this.option, this.signalBox.isSelected());
                    }
                    this.fireActionPerformed();
                    ((Component)this).setVisible(false);
                    this.dispose();
                }
                catch (NotRunningException notRunningException) {
                    JOptionPane.showMessageDialog(this, ResourceStrings.getString("server_not_running"), ResourceStrings.getString("warning"), 2);
                    this.fireActionPerformed();
                    ((Component)this).setVisible(false);
                    this.dispose();
                }
                catch (Exception exception) {
                    MessageFormat messageFormat = null;
                    Object[] objectArray = new Object[2];
                    switch (this.mode) {
                        case 0: 
                        case 2: {
                            messageFormat = new MessageFormat(ResourceStrings.getString("create_option_error"));
                            objectArray[0] = this.option.getKey();
                            break;
                        }
                        case 1: {
                            messageFormat = new MessageFormat(ResourceStrings.getString("edit_option_error"));
                            objectArray[0] = this.originalOption.getKey();
                            break;
                        }
                    }
                    objectArray[1] = exception.getMessage();
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
                }
                break;
            }
            case 1: {
                ((Component)this).setVisible(false);
                this.dispose();
                break;
            }
            case 2: {
                String string = null;
                switch (this.mode) {
                    case 0: {
                        string = "create_option";
                        break;
                    }
                    case 2: {
                        string = "duplicate_option";
                        break;
                    }
                    case 1: {
                        string = "modify_option";
                        break;
                    }
                }
                DhcpmgrApplet.showHelp(string);
                break;
            }
            case 3: {
                this.setOption(this.originalOption);
                break;
            }
        }
    }

    protected void fireActionPerformed() {
        String string = null;
        switch (this.mode) {
            case 0: {
                string = "create";
            }
            case 2: {
                string = "duplicate";
                break;
            }
            case 1: {
                string = "edit";
                break;
            }
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    private void resetValues() {
        if (this.mode == 2) {
            this.name.setText("");
        } else {
            this.name.setText(this.option.getKey());
        }
        int n = 0;
        while (n < this.categories.length) {
            if (this.categories[n].getCode() == this.option.getContext()) {
                this.category.setSelectedIndex(n);
                break;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < Option.types.length) {
            if (Option.types[n2].getCode() == this.option.getType()) {
                this.type.setSelectedIndex(n2);
                break;
            }
            ++n2;
        }
        this.code.setValue(this.option.getCode());
        this.granularity.setValue(this.option.getGranularity());
        this.maximum.setValue(this.option.getMaximum());
        this.classListModel.reset();
        this.signalBox.setSelected(true);
    }

    public void setOption(Option option) {
        this.originalOption = option;
        this.option = (Option)option.clone();
        this.resetValues();
    }

    class ClassListModel
    extends AbstractListModel {
        public void addElement(String string) throws ValidationException {
            CreateOptionDialog.this.option.addVendor(string);
            this.fireIntervalAdded(this, CreateOptionDialog.this.option.getVendorCount() - 1, CreateOptionDialog.this.option.getVendorCount() - 1);
        }

        public Object getElementAt(int n) {
            return CreateOptionDialog.this.option.getVendorAt(n);
        }

        public int getSize() {
            return CreateOptionDialog.this.option.getVendorCount();
        }

        public void moveDown(int n) {
            String string = CreateOptionDialog.this.option.getVendorAt(n + 1);
            CreateOptionDialog.this.option.setVendorAt(CreateOptionDialog.this.option.getVendorAt(n), n + 1);
            CreateOptionDialog.this.option.setVendorAt(string, n);
            this.fireContentsChanged(this, n, n + 1);
        }

        public void moveUp(int n) {
            String string = CreateOptionDialog.this.option.getVendorAt(n - 1);
            CreateOptionDialog.this.option.setVendorAt(CreateOptionDialog.this.option.getVendorAt(n), n - 1);
            CreateOptionDialog.this.option.setVendorAt(string, n);
            this.fireContentsChanged(this, n - 1, n);
        }

        public void removeElementAt(int n) {
            CreateOptionDialog.this.option.removeVendorAt(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public void reset() {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }
}

