/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.server;

import com.sun.dhcpmgr.bridge.Bridge;
import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.data.ActionError;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.data.OptionsTable;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.server.DhcptabMgr;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.TimeZone;
import java.util.Vector;

public class DhcptabMgrImpl
implements DhcptabMgr {
    private Bridge bridge;

    public DhcptabMgrImpl(Bridge bridge) {
        this.bridge = bridge;
    }

    public void createDhcptab() throws BridgeException {
        this.createDhcptab(null);
    }

    public void createDhcptab(DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.createDhcptab(dhcpDatastore);
    }

    public void createLocaleMacro() throws BridgeException, ValidationException {
        this.createLocaleMacro(null);
    }

    public void createLocaleMacro(DhcpDatastore dhcpDatastore) throws BridgeException, ValidationException {
        Macro macro = new Macro();
        macro.setKey("Locale");
        macro.storeOption("UTCoffst", (Object)String.valueOf(TimeZone.getDefault().getRawOffset() / 1000));
        this.createRecord((DhcptabRecord)macro, false);
    }

    public synchronized void createNetworkMacro(Network network, IPAddress[] iPAddressArray, boolean bl, String string, Vector vector, String string2, Vector vector2) throws BridgeException, ValidationException {
        this.createNetworkMacro(network, iPAddressArray, bl, string, vector, string2, vector2, null);
    }

    public void createNetworkMacro(Network network, IPAddress[] iPAddressArray, boolean bl, String string, Vector vector, String string2, Vector vector2, DhcpDatastore dhcpDatastore) throws BridgeException, ValidationException {
        Macro macro = new Macro();
        macro.setKey(network.toString());
        macro.storeOption("Subnet", (Object)network.getMask());
        if (iPAddressArray == null) {
            macro.storeOption("RDiscvyF", (Object)"1");
        } else {
            int n = 0;
            while (n < iPAddressArray.length) {
                macro.storeOption("Router", (Object)iPAddressArray[n]);
                ++n;
            }
        }
        if (bl) {
            macro.storeOption("Broadcst", (Object)network.getBroadcastAddress());
        }
        if (string != null && string.length() != 0 && vector != null && vector.size() != 0) {
            macro.storeOption("NISdmain", (Object)string);
            macro.storeOption("NISservs", (Object)vector);
        }
        if (string2 != null && string2.length() != 0 && vector2 != null && vector2.size() != 0) {
            macro.storeOption("NIS+dom", (Object)string2);
            macro.storeOption("NIS+serv", (Object)vector2);
        }
        this.createRecord((DhcptabRecord)macro, false);
    }

    public Option createOption(String string, String string2) throws BridgeException {
        return this.bridge.createOption(string, string2);
    }

    public void createRecord(DhcptabRecord dhcptabRecord, boolean bl) throws BridgeException {
        this.createRecord(dhcptabRecord, bl, null);
    }

    public void createRecord(DhcptabRecord dhcptabRecord, boolean bl, DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.createDhcptabRecord(dhcptabRecord, dhcpDatastore);
        if (bl) {
            this.bridge.reload();
        }
    }

    public void createServerMacro(String string, InetAddress inetAddress, int n, boolean bl, String string2, Vector vector) throws BridgeException, ValidationException {
        this.createServerMacro(string, inetAddress, n, bl, string2, vector, null);
    }

    public void createServerMacro(String string, InetAddress inetAddress, int n, boolean bl, String string2, Vector vector, DhcpDatastore dhcpDatastore) throws BridgeException, ValidationException {
        Macro macro = new Macro();
        macro.setKey(string);
        macro.storeOption("Include", (Object)"Locale");
        macro.storeOption("Timeserv", (Object)inetAddress);
        macro.storeOption("LeaseTim", (Object)String.valueOf(n));
        if (bl) {
            macro.storeOption("LeaseNeg", null);
        }
        if (string2 != null && string2.length() != 0 && vector != null && vector.size() != 0) {
            macro.storeOption("DNSdmain", (Object)string2);
            macro.storeOption("DNSserv", (Object)vector);
        }
        try {
            this.deleteRecord((DhcptabRecord)macro, false);
        }
        catch (Throwable throwable) {}
        this.createRecord((DhcptabRecord)macro, false);
    }

    public void cvtDhcptab(DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.cvtDhcptab(dhcpDatastore);
    }

    public ActionError[] deleteAllMacros() throws BridgeException {
        return this.deleteAllRecords("m");
    }

    public ActionError[] deleteAllOptions() throws BridgeException {
        return this.deleteAllRecords("s");
    }

    private ActionError[] deleteAllRecords(String string) throws BridgeException {
        Object[] objectArray = string.equals("m") ? this.getMacros() : this.getOptions();
        return this.deleteRecords((DhcptabRecord[])objectArray);
    }

    public void deleteDhcptab() throws BridgeException {
        this.deleteDhcptab(null);
    }

    public void deleteDhcptab(DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.deleteDhcptab(dhcpDatastore);
    }

    public ActionError[] deleteMacros(String[] stringArray) {
        ArrayList<ActionError> arrayList = new ArrayList<ActionError>();
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.deleteRecord(stringArray[n], "m");
            }
            catch (BridgeException bridgeException) {
                arrayList.add(new ActionError(stringArray[n], (Exception)bridgeException));
            }
            ++n;
        }
        return arrayList.toArray(new ActionError[0]);
    }

    public ActionError[] deleteOptions(String[] stringArray) {
        ArrayList<ActionError> arrayList = new ArrayList<ActionError>();
        int n = 0;
        while (n < stringArray.length) {
            try {
                this.deleteRecord(stringArray[n], "s");
            }
            catch (BridgeException bridgeException) {
                arrayList.add(new ActionError(stringArray[n], (Exception)bridgeException));
            }
            ++n;
        }
        return arrayList.toArray(new ActionError[0]);
    }

    public void deleteRecord(DhcptabRecord dhcptabRecord, boolean bl) throws BridgeException {
        this.deleteRecord(dhcptabRecord, bl, null);
    }

    public void deleteRecord(DhcptabRecord dhcptabRecord, boolean bl, DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.deleteDhcptabRecord(dhcptabRecord, dhcpDatastore);
        if (bl) {
            this.bridge.reload();
        }
    }

    private void deleteRecord(String string, String string2) throws BridgeException {
        Object object = null;
        object = string2.equals("m") ? this.getMacro(string) : this.getOption(string);
        this.deleteRecord((DhcptabRecord)object, false);
    }

    private ActionError[] deleteRecords(DhcptabRecord[] dhcptabRecordArray) {
        ArrayList<ActionError> arrayList = new ArrayList<ActionError>();
        int n = 0;
        while (n < dhcptabRecordArray.length) {
            try {
                this.deleteRecord(dhcptabRecordArray[n], false);
            }
            catch (BridgeException bridgeException) {
                arrayList.add(new ActionError(dhcptabRecordArray[n].getKey(), (Exception)bridgeException));
            }
            ++n;
        }
        return arrayList.toArray(new ActionError[0]);
    }

    public Macro getMacro(String string) throws BridgeException {
        return this.getMacro(string, null);
    }

    public Macro getMacro(String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        OptionsTable optionsTable = OptionsTable.getTable();
        optionsTable.add(this.bridge.getOptions(dhcpDatastore));
        return this.bridge.getMacro(string, dhcpDatastore);
    }

    public Macro[] getMacros() throws BridgeException {
        return this.getMacros(null);
    }

    public Macro[] getMacros(DhcpDatastore dhcpDatastore) throws BridgeException {
        OptionsTable optionsTable = OptionsTable.getTable();
        optionsTable.add(this.bridge.getOptions(dhcpDatastore));
        return this.bridge.getMacros(dhcpDatastore);
    }

    public Option getOption(String string) throws BridgeException {
        return this.getOption(string, null);
    }

    public Option getOption(String string, DhcpDatastore dhcpDatastore) throws BridgeException {
        return this.bridge.getOption(string, dhcpDatastore);
    }

    public Option[] getOptions() throws BridgeException {
        return this.getOptions(null);
    }

    public Option[] getOptions(DhcpDatastore dhcpDatastore) throws BridgeException {
        return this.bridge.getOptions(dhcpDatastore);
    }

    public void modifyRecord(DhcptabRecord dhcptabRecord, DhcptabRecord dhcptabRecord2, boolean bl) throws BridgeException {
        this.modifyRecord(dhcptabRecord, dhcptabRecord2, bl, null);
    }

    public void modifyRecord(DhcptabRecord dhcptabRecord, DhcptabRecord dhcptabRecord2, boolean bl, DhcpDatastore dhcpDatastore) throws BridgeException {
        this.bridge.modifyDhcptabRecord(dhcptabRecord, dhcptabRecord2, dhcpDatastore);
        if (bl) {
            this.bridge.reload();
        }
    }
}

