/*
 * Decompiled with CFR 0.152.
 */
package com.sun.smartcard.gui.supplemental.plugins.sample;

import com.sun.smartcard.gui.client.plugin.PluginButton;
import com.sun.smartcard.gui.client.plugin.PluginCheckBox;
import com.sun.smartcard.gui.client.plugin.PluginComboBox;
import com.sun.smartcard.gui.client.plugin.PluginGuiCtx;
import com.sun.smartcard.gui.client.plugin.PluginPassword;
import com.sun.smartcard.gui.client.plugin.PluginSlider;
import com.sun.smartcard.gui.client.plugin.PluginTab;
import com.sun.smartcard.gui.client.plugin.PluginTextField;
import com.sun.smartcard.gui.client.plugin.SmartCardPlugin;
import java.util.Properties;

public class SamplePlugin
implements SmartCardPlugin {
    private PluginTextField tf1;
    private PluginTextField tf2;
    private PluginTextField tf3;
    private PluginSlider sldr;
    private PluginComboBox combo1;
    private PluginCheckBox cbx1;
    private PluginGuiCtx pgc;
    private Properties props;

    public SamplePlugin(Properties p) {
        this(p, null);
    }

    public SamplePlugin(Properties p, PluginGuiCtx guicontext) {
        this.props = p;
        this.pgc = guicontext;
        this.pgc.setCallback((SmartCardPlugin)this);
        PluginTab tab1 = this.pgc.addTab("Plugin Tab #1");
        this.tf1 = tab1.addTextField("Textfield #1");
        this.tf2 = tab1.addTextField("Textfield #2");
        PluginTab tab2 = this.pgc.addTab("Plugin Tab #2");
        this.tf3 = tab2.addTextField("Textfield #3");
        this.combo1 = tab2.addComboBox("Editable Combo Box", true);
        this.combo1.addEntry("Mama Bear");
        this.combo1.addEntry("Papa Bear");
        this.combo1.addEntry("Baby Bear");
        this.combo1.addEntry("Little Red Riding Hood");
        this.combo1.addEntry("The Seven Dwarfs");
        this.cbx1 = tab2.addCheckBox("Just checking");
        this.sldr = tab2.addSlider("Pick a number", 0, 50);
    }

    public void activeState(boolean b) {
        if (b) {
            this.pgc.popupInfo("Active state changed", "New target: activate");
        } else {
            this.pgc.popupInfo("Active state changed", "New target: deactivate");
        }
    }

    public void buttonAction(PluginButton b) {
    }

    public boolean cancelOperation() {
        this.pgc.popupInfo("Time To Go Bye Bye", "       See ya...");
        return true;
    }

    public void checkBoxAction(PluginCheckBox cb) {
        String x = "<" + cb.getState() + ">";
        this.pgc.popupInfo("Checkbox Updated", "State changed to:  " + x.toUpperCase());
    }

    public void comboAction(PluginComboBox cb) {
        this.pgc.popupInfo("Combo Box Item Selected", "New item:  \"" + cb.getSelectedEntry() + "\"   ");
    }

    public Properties okButtonPushed(boolean toggleState) {
        String t1 = this.tf1.getText();
        String t2 = this.tf2.getText();
        String t3 = this.tf3.getText();
        String c1 = this.combo1.getSelectedEntry();
        String b1 = "<" + this.cbx1.getState() + ">";
        this.pgc.popupInfo("OK Button pushed.", "  TF1:    \"" + t1 + "\"\n" + "  TF2:    \"" + t2 + "\"\n" + "  TF3:    \"" + t3 + "\"\n" + "  CB1:    \"" + c1 + "\"\n" + "  TGL:    \"" + (toggleState ? "ON" : "OFF") + "  CX1:    " + b1.toUpperCase() + "\n\n" + "(Main OK button greyed)\n\n");
        String ync = this.pgc.popupQuestion("Just answer the question", "Do you want to press: ");
        if (ync.equals("YES")) {
            this.pgc.popupWarning("Way too affirmative", "You're going to have to slow down!");
        } else if (ync.equals("NO")) {
            this.pgc.popupWarning("Way Way Way too negative", "You need to work on your attitude!");
        } else if (ync.equals("CANCEL")) {
            this.pgc.popupWarning("This was the correct response", "I'm not going to remind you again");
        }
        return this.props;
    }

    public void passwordAction(PluginPassword pp) {
    }

    public void sliderAction(PluginSlider sl) {
    }

    public void textAction(PluginTextField tf) {
        String tfnbr = null;
        if (tf == this.tf1) {
            tfnbr = "1";
        } else if (tf == this.tf2) {
            tfnbr = "2";
        } else if (tf == this.tf3) {
            tfnbr = "3";
        }
        this.pgc.popupInfo("Text Field #" + tfnbr + " Updated", "Contents: \"" + tf.getText() + "\"");
    }

    public void toggleButtonAction(boolean toggleState) {
        if (toggleState) {
            this.pgc.popupInfo("Toggle button switched", "New state: 'AFFIRMATIVE'");
        } else {
            this.pgc.popupInfo("Toggle button switched", "New state: 'NEGATIVE'");
        }
    }
}

