/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.serialmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.MemberSelectorDialog;
import com.sun.admin.cis.common.MemberSelectorPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.cis.common.sort.TableSorter;
import com.sun.admin.serialmgr.client.AbstractTableViewModel;
import com.sun.admin.serialmgr.client.ListView;
import com.sun.admin.serialmgr.client.Main;
import com.sun.admin.serialmgr.client.SerialMgrContextHelpListener;
import com.sun.admin.serialmgr.common.SerialPortException;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class AbstractTableView
extends ListView {
    protected Object[][] theData;
    private JTable table;
    private TableSorter tableSorter;
    private int oldViewSortColumn;
    private int viewSortColumn;
    private boolean ascendSort = true;
    private ResourceBundle bundle = Main.getApp().getResourceBundle();
    protected Vector dataCache = new Vector();

    protected abstract void onDoubleClick();

    protected abstract AbstractTableViewModel getTableViewModel();

    protected void createTable() {
        AbstractTableViewModel abstractTableViewModel = this.getTableViewModel();
        this.theData = new Object[0][abstractTableViewModel.getColumnKeys().size()];
        this.tableSorter = new TableSorter(abstractTableViewModel);
        this.table = new JTable(this.tableSorter);
        this.table.setBackground(Color.white);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(4);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(2);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 1());
        this.table.addMouseListener(new TableMouseListener());
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(new 2());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = 0;
        while (n < tableColumnModel.getColumnCount()) {
            String string = (String)this.getAvailableSortAttributes().elementAt(n);
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            this.setColumnWidth(tableColumn, abstractTableViewModel.getDataWidth(string));
            tableColumn.setIdentifier(string);
            ++n;
        }
        this.setViewportView(this.table);
        this.setBackground(Color.white);
    }

    private void setColumnWidth(TableColumn tableColumn, int n) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        Font font = jTableHeader.getFont();
        String string = (String)tableColumn.getHeaderValue();
        int n2 = Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth(string);
        int n3 = Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("A");
        tableColumn.setWidth(Math.max(n2 += Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth("AAAA"), n3 *= n));
    }

    public void setDataCache(Vector vector) {
        this.dataCache = vector;
    }

    public int getViewType() {
        return 2;
    }

    public void populate() {
        String string = ResourceStrings.getString(this.bundle, "PopulateTableView");
        Object[] objectArray = new Object[2];
        objectArray[1] = new Integer(this.dataCache.size());
        this.theData = new Object[this.dataCache.size()][this.getTableViewModel().getColumnKeys().size()];
        int n = 0;
        while (n < this.dataCache.size()) {
            this.getTableViewModel().addObjectAtRow(n, this.dataCache.elementAt(n));
            if ((n + 1) % 10 == 0) {
                objectArray[0] = new Integer(n + 1);
                Main.getApp().setStatusBar(MessageFormat.format(string, objectArray));
            }
            ++n;
        }
        objectArray[0] = new Integer(this.dataCache.size());
        Main.getApp().setStatusBar(MessageFormat.format(string, objectArray));
        this.tableSorter.tableChanged(new TableModelEvent(this.getTableViewModel()));
        int n2 = this.table.convertColumnIndexToModel(this.viewSortColumn);
        this.tableSorter.sortByColumn(n2, this.ascendSort);
        this.fireSortChanged();
    }

    public void clear() {
        this.clearSelection();
        this.theData = new Object[0][this.getTableViewModel().getColumnKeys().size()];
        this.tableSorter.tableChanged(new TableModelEvent(this.getTableViewModel()));
    }

    public void append(Vector vector) {
        int n;
        Object[][] objectArray = new Object[this.dataCache.size() + vector.size()][this.getTableViewModel().getColumnKeys().size()];
        int n2 = 0;
        while (n2 < this.dataCache.size()) {
            n = 0;
            while (n < this.getTableViewModel().getColumnKeys().size()) {
                objectArray[n2][n] = this.theData[n2][n];
                ++n;
            }
            ++n2;
        }
        this.theData = objectArray;
        n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            this.getTableViewModel().addObjectAtRow(n2, e);
            this.dataCache.addElement(e);
            ++n;
            ++n2;
        }
        this.tableSorter.tableChanged(new TableModelEvent(this.getTableViewModel()));
    }

    public Vector getSelected() {
        Vector vector = new Vector();
        int[] nArray = this.table.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(this.dataCache.elementAt(this.tableSorter.convertRowIndexToModel(nArray[n])));
            ++n;
        }
        return vector;
    }

    public void setSelected(Vector vector) {
        if (vector.size() == 0) {
            return;
        }
        this.clearSelection();
        int n = 0;
        while (n < this.table.getRowCount()) {
            Object e = this.dataCache.elementAt(this.tableSorter.convertRowIndexToModel(n));
            int n2 = 0;
            while (n2 < vector.size()) {
                Object e2 = vector.elementAt(n2);
                if (e == e2) {
                    this.table.addRowSelectionInterval(n, n);
                    break;
                }
                ++n2;
            }
            ++n;
        }
    }

    public int getNumSelections() {
        return this.table.getSelectedRowCount();
    }

    private void onSelect() {
        Main.getApp().setHelp(this.getTableViewModel().getHelpName(null));
        this.fireItemPressed(1);
    }

    public void selectAll() {
        this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
    }

    public void clearSelection() {
        this.table.clearSelection();
        this.fireItemPressed(0);
    }

    public void sortAscending() {
        Main.getApp().getClientComm().waitOn();
        Vector vector = this.getSelected();
        this.ascendSort = true;
        int n = this.table.convertColumnIndexToModel(this.viewSortColumn);
        this.tableSorter.sortByColumn(n, this.ascendSort);
        this.fireSortChanged();
        this.setSelected(vector);
        Main.getApp().getClientComm().waitOff();
    }

    public void sortDescending() {
        Main.getApp().getClientComm().waitOn();
        Vector vector = this.getSelected();
        this.ascendSort = false;
        int n = this.table.convertColumnIndexToModel(this.viewSortColumn);
        this.tableSorter.sortByColumn(n, this.ascendSort);
        this.fireSortChanged();
        this.setSelected(vector);
        Main.getApp().getClientComm().waitOff();
    }

    public void sortByAttribute(String string) {
        Main.getApp().getClientComm().waitOn();
        Vector vector = this.getSelected();
        try {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            this.oldViewSortColumn = this.viewSortColumn;
            this.viewSortColumn = tableColumnModel.getColumnIndex(string);
            int n = this.table.convertColumnIndexToModel(this.viewSortColumn);
            this.tableSorter.sortByColumn(n, this.ascendSort);
            this.fireSortChanged();
        }
        catch (Exception exception) {
            this.fireSortChanged();
        }
        this.setSelected(vector);
        Main.getApp().getClientComm().waitOff();
    }

    public int getSortOrder() {
        if (this.ascendSort) {
            return 3;
        }
        return 4;
    }

    public String getSortAttribute() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.viewSortColumn);
        return (String)tableColumn.getIdentifier();
    }

    public void find(String string) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        int n = -1;
        if (this.getNumSelections() > 0) {
            int[] nArray = this.table.getSelectedRows();
            n = nArray[nArray.length - 1];
        }
        int n2 = 0;
        while (n2++ < this.table.getRowCount()) {
            if (++n == this.table.getRowCount()) {
                n = 0;
            }
            int n3 = 0;
            while (n3 < this.getTableViewModel().getColumnCount()) {
                int n4 = this.tableSorter.convertRowIndexToModel(n);
                String string2 = (String)this.getTableViewModel().getValueAt(n4, n3);
                if (string2.length() != 0 && string2.indexOf(string) >= 0) {
                    this.table.clearSelection();
                    this.table.setRowSelectionInterval(n, n);
                    Rectangle rectangle = this.table.getCellRect(n, 0, false);
                    this.table.scrollRectToVisible(rectangle);
                    return;
                }
                ++n3;
            }
        }
        Main.getApp().reportErrorException(new SerialPortException("EXM_SPRT_GUI_FIND_FAILED", string));
    }

    public void find(Object object) {
        if (this.table.getRowCount() <= 0) {
            return;
        }
        int n = 0;
        while (n < this.table.getRowCount()) {
            Object e = this.dataCache.elementAt(this.tableSorter.convertRowIndexToModel(n));
            if (e.equals(object)) {
                this.table.clearSelection();
                this.table.setRowSelectionInterval(n, n);
                Rectangle rectangle = this.table.getCellRect(n, 0, false);
                this.table.scrollRectToVisible(rectangle);
                return;
            }
            ++n;
        }
    }

    private void handlePopupTrigger(MouseEvent mouseEvent) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (!this.table.isRowSelected(n)) {
            this.table.clearSelection();
            this.table.setRowSelectionInterval(n, n);
        }
        this.firePopupTriggered(SwingUtilities.convertMouseEvent(this.table, mouseEvent, this.getViewport()));
    }

    public void configureHeader() {
        Object object;
        Vector vector = this.getAvailableSortAttributes();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = this.getTableViewModel().getColumnKeys();
        int n = 0;
        while (n < vector3.size()) {
            object = (String)vector3.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                if (((String)object).compareTo((String)vector.elementAt(n2)) == 0) break;
                ++n2;
            }
            if (n2 == vector.size()) {
                vector2.addElement((String)object);
            }
            ++n;
        }
        MemberSelectorPanel memberSelectorPanel = new MemberSelectorPanel(vector2, vector, "com.sun.admin.serialmgr.resources.ResourceBundle");
        memberSelectorPanel.setLabels(new ActionString(this.bundle, "AvailableColumns"), new ActionString(this.bundle, "DisplayableColumns"), new ActionString(this.bundle, "AddToColumn"), new ActionString(this.bundle, "RemoveFromColumn"));
        object = new MemberSelectorDialog(Main.getApp().getFrame(), memberSelectorPanel);
        ActionString actionString = new ActionString(this.bundle, "ViewDisplayColumns");
        String string = actionString.getString();
        ((Dialog)object).setTitle(string.substring(0, string.length() - 3));
        ((MemberSelectorDialog)object).getOkButton().addActionListener(new 3((MemberSelectorDialog)object, memberSelectorPanel, this, vector));
        ((MemberSelectorDialog)object).setDefaultFocusListener(new SerialMgrContextHelpListener(((AdminDialog)object).getInfoPanel(), "dlg_columns_overview"), true);
        memberSelectorPanel.setFocusListeners(new SerialMgrContextHelpListener(((AdminDialog)object).getInfoPanel(), "dlg_columns_available"), new SerialMgrContextHelpListener(((AdminDialog)object).getInfoPanel(), "dlg_columns_display"), new SerialMgrContextHelpListener(((AdminDialog)object).getInfoPanel(), "dlg_columns_add"), new SerialMgrContextHelpListener(((AdminDialog)object).getInfoPanel(), "dlg_columns_remove"), new SerialMgrContextHelpListener(((AdminDialog)object).getInfoPanel(), "dlg_columns_up"), new SerialMgrContextHelpListener(((AdminDialog)object).getInfoPanel(), "dlg_columns_down"));
        ((Dialog)object).show();
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AbstractTableView.this.onSelect();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        boolean needSort = false;

        public void mouseExited(MouseEvent mouseEvent) {
            this.needSort = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.needSort = true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.needSort) {
                return;
            }
            this.needSort = false;
            TableColumnModel tableColumnModel = AbstractTableView.this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = AbstractTableView.this.table.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                Main.getApp().getClientComm().waitOn();
                Vector vector = AbstractTableView.this.getSelected();
                AbstractTableView.this.oldViewSortColumn = AbstractTableView.this.viewSortColumn;
                AbstractTableView.this.viewSortColumn = n;
                if (AbstractTableView.this.viewSortColumn == AbstractTableView.this.oldViewSortColumn) {
                    AbstractTableView.this.ascendSort = !AbstractTableView.this.ascendSort;
                } else {
                    AbstractTableView.this.ascendSort = true;
                }
                AbstractTableView.this.tableSorter.sortByColumn(n2, AbstractTableView.this.ascendSort);
                AbstractTableView.this.fireSortChanged();
                AbstractTableView.this.setSelected(vector);
                Main.getApp().getClientComm().waitOff();
            }
        }

        /* synthetic */ 2() {
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AbstractTableView.this.handlePopupTrigger(mouseEvent);
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (AbstractTableView.this.table.rowAtPoint(mouseEvent.getPoint()) < 0 || AbstractTableView.this.table.columnAtPoint(mouseEvent.getPoint()) < 0) {
                    AbstractTableView.this.clearSelection();
                    return;
                }
                if (mouseEvent.isControlDown() || mouseEvent.getClickCount() != 2) {
                    return;
                }
                AbstractTableView.this.onDoubleClick();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AbstractTableView.this.handlePopupTrigger(mouseEvent);
                return;
            }
        }

        TableMouseListener() {
            AbstractTableView.this = AbstractTableView.this;
        }
    }

    private static final class 3
    implements ActionListener {
        private final /* synthetic */ MemberSelectorDialog val$selectorDialog;
        private final /* synthetic */ Vector val$vColumns;
        private final /* synthetic */ AbstractTableView this$0;
        private final /* synthetic */ MemberSelectorPanel val$selectorPanel;

        public void actionPerformed(ActionEvent actionEvent) {
            TableColumn tableColumn;
            int n;
            Vector vector = this.val$selectorPanel.getInItems();
            Vector vector2 = this.val$selectorPanel.getOutItems();
            if (vector2.size() <= 0) {
                Main.getApp().reportErrorException(new SerialPortException("EXM_SPRT_GUI_NO_COLUMNS_TO_DISPLAY"));
                return;
            }
            int n2 = this.this$0.table.convertColumnIndexToModel(this.this$0.viewSortColumn);
            TableColumnModel tableColumnModel = this.this$0.table.getColumnModel();
            int n3 = 0;
            while (n3 < vector.size()) {
                try {
                    String string = (String)vector.elementAt(n3);
                    n = tableColumnModel.getColumnIndex(string);
                    int n4 = this.this$0.table.convertColumnIndexToModel(n);
                    tableColumn = tableColumnModel.getColumn(n);
                    this.val$vColumns.removeElementAt(n);
                    tableColumnModel.removeColumn(tableColumn);
                    if (n4 == n2) {
                        n2 = -1;
                    }
                }
                catch (Exception exception) {}
                ++n3;
            }
            int n5 = 0;
            while (n5 < vector2.size()) {
                String string;
                try {
                    string = (String)vector2.elementAt(n5);
                    tableColumnModel.getColumnIndex(string);
                }
                catch (Exception exception) {
                    string = (String)vector2.elementAt(n5);
                    this.val$vColumns.addElement(string);
                    ActionString actionString = new ActionString(this.this$0.bundle, string);
                    tableColumn = new TableColumn();
                    tableColumn.setIdentifier(string);
                    tableColumn.setHeaderValue(actionString.getString());
                    tableColumn.setModelIndex(this.this$0.getTableViewModel().getColumnModelIndex(string));
                    tableColumnModel.addColumn(tableColumn);
                    this.this$0.setColumnWidth(tableColumn, this.this$0.getTableViewModel().getDataWidth(string));
                }
                ++n5;
            }
            n = 0;
            while (n < vector2.size()) {
                try {
                    String string = (String)vector2.elementAt(n);
                    int n6 = tableColumnModel.getColumnIndex(string);
                    int n7 = 0;
                    while (n7 < this.val$vColumns.size()) {
                        if (((String)this.val$vColumns.elementAt(n7)).compareTo(string) == 0) break;
                        ++n7;
                    }
                    Object e = this.val$vColumns.elementAt(n);
                    this.val$vColumns.setElementAt(string, n);
                    this.val$vColumns.setElementAt(e, n7);
                    tableColumnModel.moveColumn(n6, n);
                }
                catch (Exception exception) {}
                ++n;
            }
            if (n2 < 0) {
                n2 = this.this$0.table.convertColumnIndexToModel(0);
            }
            this.this$0.oldViewSortColumn = this.this$0.viewSortColumn;
            this.this$0.tableSorter.sortByColumn(n2, this.this$0.ascendSort);
            this.this$0.viewSortColumn = this.this$0.table.convertColumnIndexToView(n2);
            this.this$0.table.sizeColumnsToFit(-1);
            this.this$0.fireSortChanged();
            this.val$selectorDialog.dispose();
        }

        /* synthetic */ 3(MemberSelectorDialog memberSelectorDialog, MemberSelectorPanel memberSelectorPanel, AbstractTableView abstractTableView, Vector vector) {
            this.val$selectorDialog = memberSelectorDialog;
            this.val$selectorPanel = memberSelectorPanel;
            this.this$0 = abstractTableView;
            this.val$vColumns = vector;
        }
    }
}

