/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.hostmgr.client.AbstractTableView;
import com.sun.admin.hostmgr.client.AbstractTableViewModel;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostData;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import java.util.Vector;

public class HostTableView
extends AbstractTableView {
    DataTableModel dataModel;
    Vector vColumns = new Vector();
    ResourceBundle bundle = Main.getApp().getResourceBundle();
    String[] columnKeys = new String[]{"hostListComputerName", "hostListIPAddress", "hostListComment", "hostListAliases", "hostListEnetAddress"};

    public HostTableView() {
        this.vColumns.addElement(new String("hostListComputerName"));
        this.vColumns.addElement(new String("hostListIPAddress"));
        this.vColumns.addElement(new String("hostListComment"));
        this.vColumns.addElement(new String("hostListAliases"));
        this.dataModel = new DataTableModel();
        this.createTable();
    }

    protected AbstractTableViewModel getTableViewModel() {
        if (this.dataModel == null) {
            this.dataModel = new DataTableModel();
        }
        return this.dataModel;
    }

    public Vector getAvailableSortAttributes() {
        return this.vColumns;
    }

    protected void onDoubleClick() {
        this.fireItemPressed(2);
        ActionEvent actionEvent = new ActionEvent(this, 1001, "ViewProps");
        HostActionsListener hostActionsListener = new HostActionsListener();
        hostActionsListener.actionPerformed(actionEvent);
    }

    class DataTableModel
    extends AbstractTableViewModel {
        Vector vColumnKeys = new Vector();

        public int getColumnCount() {
            return HostTableView.this.vColumns.size();
        }

        public int getRowCount() {
            return HostTableView.this.theData.length;
        }

        public Object getValueAt(int n, int n2) {
            if (HostTableView.this.theData.length == 0) {
                return null;
            }
            return HostTableView.this.theData[n][n2];
        }

        public Object getIPaddrValueAt(int n, int n2) throws Exception {
            if (n2 != this.getColumnModelIndex("hostListIPAddress")) {
                throw new Exception();
            }
            HostData hostData = (HostData)HostTableView.this.dataCache.elementAt(n);
            return new Long(hostData.getNetworkAddressLong());
        }

        public String getColumnName(int n) {
            String string = (String)HostTableView.this.vColumns.elementAt(n);
            ActionString actionString = new ActionString(HostTableView.this.bundle, string);
            return actionString.getString();
        }

        public void addObjectAtRow(int n, Object object) {
            HostData hostData = (HostData)object;
            HostTableView.this.theData[n][this.getColumnModelIndex((String)"hostListComputerName")] = hostData.getHostName();
            HostTableView.this.theData[n][this.getColumnModelIndex((String)"hostListIPAddress")] = hostData.getNetworkAddress();
            HostTableView.this.theData[n][this.getColumnModelIndex((String)"hostListComment")] = hostData.getDescription();
            HostTableView.this.theData[n][this.getColumnModelIndex((String)"hostListAliases")] = hostData.getAliases();
            HostTableView.this.theData[n][this.getColumnModelIndex((String)"hostListEnetAddress")] = hostData.getEthernetAddress();
        }

        public int getDataWidth(String string) {
            if (string.compareTo("hostListComputerName") == 0) {
                return 16;
            }
            if (string.compareTo("hostListIPAddress") == 0) {
                return 16;
            }
            if (string.compareTo("hostListComment") == 0) {
                return 32;
            }
            if (string.compareTo("hostListAliases") == 0) {
                return 32;
            }
            if (string.compareTo("hostListEnetAddress") == 0) {
                return 18;
            }
            return 8;
        }

        public String getHelpName(Object object) {
            return "main_hostlist";
        }

        public Vector getColumnKeys() {
            return this.vColumnKeys;
        }

        public int getColumnModelIndex(String string) {
            int n = 0;
            while (n < HostTableView.this.columnKeys.length) {
                if (string.compareTo(HostTableView.this.columnKeys[n]) == 0) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public DataTableModel() {
            HostTableView.this = HostTableView.this;
            int n = 0;
            while (n < HostTableView.this.columnKeys.length) {
                this.vColumnKeys.addElement(HostTableView.this.columnKeys[n]);
                ++n;
            }
        }
    }
}

