/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.HostAdvPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class HostAdvPropsPanel
extends AbstractPropsPanel {
    private HostData originalHostObj;
    private JTextField aliases;
    private JTextArea description;
    private JTextField etherAddress;
    private boolean bNewHost;

    public HostAdvPropsPanel(GenInfoPanel genInfoPanel, HostData hostData, boolean bl) {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.bNewHost = bl;
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "AdvPropsTabName");
        this.setBorder(BorderFactory.createTitledBorder(actionString.getString()));
        actionString = new ActionString(resourceBundle, "GenPropsAliases");
        JLabel jLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, jLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 10, 5, 10, 5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.aliases = new JTextField(hostData.getAliases(), 24);
        Constraints.constrain(this, this.aliases, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 10, 0, 10, 5);
        this.aliases.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor(this.aliases);
        actionString = new ActionString(resourceBundle, "GenPropsDescription");
        jLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, jLabel, 0, -1, 1, 1, 0, 18, 0.0, 0.0, 0, 5, 10, 5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.description = new JTextArea(hostData.getDescription(), 3, 24);
        this.description.setLineWrap(true);
        this.description.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor(this.description);
        JScrollPane jScrollPane = new JScrollPane(this.description, 20, 31);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Constraints.constrain(this, jScrollPane, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        actionString = new ActionString(resourceBundle, "AdvPropsEtherAddr");
        jLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, jLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 10, 5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.etherAddress = new JTextField(hostData.getEthernetAddress(), 24);
        Constraints.constrain(this, this.etherAddress, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        this.etherAddress.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor(this.etherAddress);
        if (!bl) {
            MultihomeHostComponent multihomeHostComponent = new MultihomeHostComponent(genInfoPanel, hostData);
            Constraints.constrain(this, multihomeHostComponent.getLabelPanel(), 0, -1, 1, 1, 0, 18, 0.0, 0.0, 0, 5, 10, 5);
            Constraints.constrain(this, multihomeHostComponent.getValuePanel(), 1, -1, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 10, 5);
        }
        if (!bl) {
            this.aliases.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_hostprop_alias"));
            this.description.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_hostprop_desc"));
            this.etherAddress.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_hostprop_ether"));
        } else {
            this.aliases.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newhost_alias"));
            this.description.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newhost_desc"));
            this.etherAddress.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newhost_ether"));
        }
        this.originalHostObj = hostData;
    }

    public void dialogDataExchange(Object object) throws HostException {
        HostData hostData = (HostData)object;
        if (this.etherAddress.getText().length() > 0) {
            try {
                HostData.validateEthernetAddress(this.etherAddress.getText());
                hostData.setEthernetAddress(this.etherAddress.getText());
            }
            catch (HostException hostException) {
                this.etherAddress.requestFocus();
                throw hostException;
            }
        }
        if (this.description.getText().length() > 0) {
            try {
                HostData.validateDescription(this.description.getText());
                hostData.setDescription(this.description.getText());
            }
            catch (HostException hostException) {
                this.description.requestFocus();
                throw hostException;
            }
        }
        if (this.aliases.getText().length() > 0) {
            try {
                HostData.validateAliasNames(this.aliases.getText());
                hostData.setAliases(this.aliases.getText());
                return;
            }
            catch (HostException hostException) {
                this.aliases.requestFocus();
                throw hostException;
            }
        }
    }

    public void dialogDataInitialize(Object object) {
        HostData hostData = (HostData)object;
        this.etherAddress.setText(hostData.getEthernetAddress());
        this.description.setText(hostData.getDescription());
        this.aliases.setText(hostData.getAliases());
        this.originalHostObj = hostData;
    }

    class MultihomeHostComponent {
        private JPanel labelPanel;
        private JPanel valuePanel;
        private JButton getButton;
        private JTextArea otherIPAddresses;
        private HostData hostData;
        private ResourceBundle bundle = Main.getApp().getResourceBundle();

        public MultihomeHostComponent(GenInfoPanel genInfoPanel, HostData hostData) {
            HostAdvPropsPanel.this = HostAdvPropsPanel.this;
            this.hostData = hostData;
            this.labelPanel = new JPanel();
            this.labelPanel.setLayout(new GridBagLayout());
            ActionString actionString = new ActionString(this.bundle, "AdvPropsMultihome1");
            JLabel jLabel = new JLabel(actionString.getString());
            Constraints.constrain(this.labelPanel, jLabel, 0, 0, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
            jLabel.setDisplayedMnemonic(actionString.getMnemonic());
            jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
            jLabel.setFont(Constants.PROPS_LABEL_FONT);
            actionString = new ActionString(this.bundle, "AdvPropsMultihome2");
            JLabel jLabel2 = new JLabel(actionString.getString());
            Constraints.constrain(this.labelPanel, jLabel2, 0, 1, 1, 1, 0, 18, 0.0, 0.0, 0, 0, 0, 0);
            jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
            jLabel2.setFont(Constants.PROPS_LABEL_FONT);
            this.valuePanel = new JPanel();
            this.valuePanel.setLayout(new GridBagLayout());
            this.otherIPAddresses = new JTextArea(3, 16);
            this.otherIPAddresses.setEditable(false);
            this.otherIPAddresses.setLineWrap(true);
            this.otherIPAddresses.setBackground(HostAdvPropsPanel.this.getBackground());
            this.otherIPAddresses.setFont(Constants.PROPS_RW_VALUE_FONT);
            jLabel.setLabelFor(this.otherIPAddresses);
            JScrollPane jScrollPane = new JScrollPane(this.otherIPAddresses, 20, 31);
            jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
            Constraints.constrain(this.valuePanel, jScrollPane, 0, 0, 1, 1, 2, 18, 1.0, 0.0, 0, 0, 0, 0);
            this.otherIPAddresses.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_hostprop_multihome"));
            actionString = new ActionString(this.bundle, "AdvPropsMultihomeGet");
            this.getButton = new JButton(actionString.getString());
            Constraints.constrain(this.valuePanel, this.getButton, 0, 1, 1, 1, 0, 13, 0.0, 0.0, 3, 0, 0, 0);
            this.getButton.addActionListener(new 1(this));
            this.getButton.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_hostprop_multihome"));
        }

        private void onGet() {
            Vector vector = null;
            Main.getApp().getClientComm().waitOn();
            try {
                vector = Main.getApp().getHostMgr().getHostOtherAddrs(this.hostData);
                String string = new String();
                int n = 0;
                while (n < vector.size()) {
                    string = String.valueOf(string) + (String)vector.elementAt(n);
                    if (n < vector.size() - 1) {
                        string = String.valueOf(string) + "\n";
                    }
                    ++n;
                }
                this.otherIPAddresses.setText(string);
            }
            catch (Exception exception) {
                Main.getApp().reportErrorException(exception);
            }
            Main.getApp().getClientComm().waitOff();
        }

        public JPanel getLabelPanel() {
            return this.labelPanel;
        }

        public JPanel getValuePanel() {
            return this.valuePanel;
        }

        static /* synthetic */ void access$0(MultihomeHostComponent multihomeHostComponent) {
            multihomeHostComponent.onGet();
        }
    }
}

