/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.usage;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.fsmgr.client.usage.UsageListView;
import com.sun.admin.fsmgr.client.usage.UsageListViewListener;
import com.sun.admin.fsmgr.client.usage.UsageTableView;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class UsageViewPanel
extends JPanel {
    private UsageTableView tableView;
    private UsageListView currentView;

    public UsageViewPanel() {
        this.setLayout(new GridBagLayout());
        this.tableView = new UsageTableView();
        this.setBackground(Color.white);
        this.setView(this.tableView);
        this.addMouseListener(new ViewMouseListener());
    }

    public void showTableView() {
        this.currentView.clearSelection();
        this.setView(this.tableView);
    }

    public UsageListView getCurrentView() {
        return this.currentView;
    }

    public void repaintView() {
        this.setView(this.currentView);
    }

    private void setView(UsageListView usageListView) {
        this.removeAll();
        usageListView.populate();
        this.currentView = usageListView;
        Constraints.constrain(this, usageListView, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
        this.currentView.clearSelection();
        this.currentView.fireViewChanged();
    }

    public void addListViewListener(UsageListViewListener usageListViewListener) {
        this.tableView.addListViewListener(usageListViewListener);
    }

    public void removeListViewListener(UsageListViewListener usageListViewListener) {
        this.tableView.removeListViewListener(usageListViewListener);
    }

    class ViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                UsageViewPanel.this.tableView.clearSelection();
            }
        }

        ViewMouseListener() {
            UsageViewPanel.this = UsageViewPanel.this;
        }
    }
}

